/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.scene.DirectionalLightHelper;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGDirectionalLight;
import com.sun.javafx.sg.prism.NGNode;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point3D;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.paint.Color;

public non-sealed class DirectionalLight
extends LightBase {
    private ObjectProperty<Point3D> direction;
    private static final Point3D DEFAULT_DIRECTION;

    public DirectionalLight() {
        DirectionalLightHelper.initHelper(this);
    }

    public DirectionalLight(Color color) {
        super(color);
        DirectionalLightHelper.initHelper(this);
    }

    public final void setDirection(Point3D point3D) {
        this.directionProperty().set((Object)point3D);
    }

    public final Point3D getDirection() {
        return this.direction == null ? DEFAULT_DIRECTION : (Point3D)this.direction.get();
    }

    public final ObjectProperty<Point3D> directionProperty() {
        if (this.direction == null) {
            this.direction = new SimpleObjectProperty<Point3D>((Object)this, "direction", DEFAULT_DIRECTION){

                protected void invalidated() {
                    NodeHelper.markDirty(DirectionalLight.this, DirtyBits.NODE_LIGHT);
                }
            };
        }
        return this.direction;
    }

    private NGNode doCreatePeer() {
        return new NGDirectionalLight();
    }

    private void doUpdatePeer() {
        if (this.isDirty(DirtyBits.NODE_LIGHT)) {
            NGDirectionalLight nGDirectionalLight = (NGDirectionalLight)this.getPeer();
            nGDirectionalLight.setDirection(this.getDirection());
        }
    }

    static {
        DirectionalLightHelper.setDirectionalLightAccessor(new DirectionalLightHelper.DirectionalLightAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((DirectionalLight)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((DirectionalLight)node).doUpdatePeer();
            }
        });
        DEFAULT_DIRECTION = NGDirectionalLight.getDefaultDirection();
    }
}

