/*
 *    reentr.inc
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 *  !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *  This file is built by reentrl.pl from data in reentr.pl.
 */

#ifndef REENTRINC
#define REENTRINC

#ifdef USE_REENTRANT_API

/*
 * As of OpenBSD 3.7, reentrant functions are now working, they just are
 * incompatible with everyone else.  To make OpenBSD happy, we have to
 * memzero out certain structures before calling the functions.
 */
#if defined(__OpenBSD__)
#    define REENTR_MEMZERO(a,b) memzero(a,b)
#else
#    define REENTR_MEMZERO(a,b) 0
#endif

/* The reentrant wrappers. */

#ifdef HAS_ASCTIME_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef asctime
#   if !defined(asctime) && ASCTIME_R_PROTO == REENTRANT_PROTO_B_SB
#       define asctime(a) asctime_r(a, PL_reentrant_buffer->_asctime_buffer)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(asctime) && ASCTIME_R_PROTO == REENTRANT_PROTO_B_SBI
#       define asctime(a) asctime_r(a, PL_reentrant_buffer->_asctime_buffer, PL_reentrant_buffer->_asctime_size)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(asctime) && ASCTIME_R_PROTO == REENTRANT_PROTO_I_SB
#       define asctime(a) (asctime_r(a, PL_reentrant_buffer->_asctime_buffer) == 0 ? PL_reentrant_buffer->_asctime_buffer : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(asctime) && ASCTIME_R_PROTO == REENTRANT_PROTO_I_SBI
#       define asctime(a) (asctime_r(a, PL_reentrant_buffer->_asctime_buffer, PL_reentrant_buffer->_asctime_size) == 0 ? PL_reentrant_buffer->_asctime_buffer : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_ASCTIME */
#endif /* HAS_ASCTIME_R */

#ifdef HAS_CRYPT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef crypt
#   if !defined(crypt) && CRYPT_R_PROTO == REENTRANT_PROTO_B_CCS
#       define crypt(a, b) crypt_r(a, b, PL_reentrant_buffer->_crypt_struct_buffer)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(crypt) && CRYPT_R_PROTO == REENTRANT_PROTO_B_CCD
#       define crypt(a, b) crypt_r(a, b, &PL_reentrant_buffer->_crypt_data)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_CRYPT */
#endif /* HAS_CRYPT_R */

#ifdef HAS_CTERMID_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef ctermid
#   if !defined(ctermid) && CTERMID_R_PROTO == REENTRANT_PROTO_B_B
#       define ctermid(a) ctermid_r(a)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_CTERMID */
#endif /* HAS_CTERMID_R */

#ifdef HAS_CTIME_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef ctime
#   if !defined(ctime) && CTIME_R_PROTO == REENTRANT_PROTO_B_SB
#       define ctime(a) ctime_r(a, PL_reentrant_buffer->_ctime_buffer)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(ctime) && CTIME_R_PROTO == REENTRANT_PROTO_B_SBI
#       define ctime(a) ctime_r(a, PL_reentrant_buffer->_ctime_buffer, PL_reentrant_buffer->_ctime_size)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(ctime) && CTIME_R_PROTO == REENTRANT_PROTO_I_SB
#       define ctime(a) (ctime_r(a, PL_reentrant_buffer->_ctime_buffer) == 0 ? PL_reentrant_buffer->_ctime_buffer : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(ctime) && CTIME_R_PROTO == REENTRANT_PROTO_I_SBI
#       define ctime(a) (ctime_r(a, PL_reentrant_buffer->_ctime_buffer, PL_reentrant_buffer->_ctime_size) == 0 ? PL_reentrant_buffer->_ctime_buffer : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_CTIME */
#endif /* HAS_CTIME_R */

#ifdef HAS_DRAND48_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef drand48
#   if !defined(drand48) && DRAND48_R_PROTO == REENTRANT_PROTO_I_ST
#       define drand48() (drand48_r(&PL_reentrant_buffer->_drand48_struct, &PL_reentrant_buffer->_drand48_double) == 0 ? PL_reentrant_buffer->_drand48_double : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_DRAND48 */
#endif /* HAS_DRAND48_R */

#ifdef HAS_ENDGRENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef endgrent
#   if !defined(endgrent) && ENDGRENT_R_PROTO == REENTRANT_PROTO_I_H
#       define endgrent() (endgrent_r(&PL_reentrant_buffer->_grent_fptr) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(endgrent) && ENDGRENT_R_PROTO == REENTRANT_PROTO_V_H
#       define endgrent() endgrent_r(&PL_reentrant_buffer->_grent_fptr)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_ENDGRENT */
#endif /* HAS_ENDGRENT_R */

#ifdef HAS_ENDHOSTENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef endhostent
#   if !defined(endhostent) && ENDHOSTENT_R_PROTO == REENTRANT_PROTO_I_D
#       define endhostent() (endhostent_r(&PL_reentrant_buffer->_hostent_data) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(endhostent) && ENDHOSTENT_R_PROTO == REENTRANT_PROTO_V_D
#       define endhostent() endhostent_r(&PL_reentrant_buffer->_hostent_data)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_ENDHOSTENT */
#endif /* HAS_ENDHOSTENT_R */

#ifdef HAS_ENDNETENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef endnetent
#   if !defined(endnetent) && ENDNETENT_R_PROTO == REENTRANT_PROTO_I_D
#       define endnetent() (endnetent_r(&PL_reentrant_buffer->_netent_data) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(endnetent) && ENDNETENT_R_PROTO == REENTRANT_PROTO_V_D
#       define endnetent() endnetent_r(&PL_reentrant_buffer->_netent_data)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_ENDNETENT */
#endif /* HAS_ENDNETENT_R */

#ifdef HAS_ENDPROTOENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef endprotoent
#   if !defined(endprotoent) && ENDPROTOENT_R_PROTO == REENTRANT_PROTO_I_D
#       define endprotoent() (endprotoent_r(&PL_reentrant_buffer->_protoent_data) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(endprotoent) && ENDPROTOENT_R_PROTO == REENTRANT_PROTO_V_D
#       define endprotoent() endprotoent_r(&PL_reentrant_buffer->_protoent_data)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_ENDPROTOENT */
#endif /* HAS_ENDPROTOENT_R */

#ifdef HAS_ENDPWENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef endpwent
#   if !defined(endpwent) && ENDPWENT_R_PROTO == REENTRANT_PROTO_I_H
#       define endpwent() (endpwent_r(&PL_reentrant_buffer->_pwent_fptr) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(endpwent) && ENDPWENT_R_PROTO == REENTRANT_PROTO_V_H
#       define endpwent() endpwent_r(&PL_reentrant_buffer->_pwent_fptr)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_ENDPWENT */
#endif /* HAS_ENDPWENT_R */

#ifdef HAS_ENDSERVENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef endservent
#   if !defined(endservent) && ENDSERVENT_R_PROTO == REENTRANT_PROTO_I_D
#       define endservent() (endservent_r(&PL_reentrant_buffer->_servent_data) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(endservent) && ENDSERVENT_R_PROTO == REENTRANT_PROTO_V_D
#       define endservent() endservent_r(&PL_reentrant_buffer->_servent_data)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_ENDSERVENT */
#endif /* HAS_ENDSERVENT_R */

#ifdef HAS_GETGRENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getgrent
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_I_SBWR
#       ifdef PERL_CORE
#           define getgrent() (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0));})
#           else
#               define getgrent() Perl_reentr_getgrent()
                static struct group* Perl_reentr_getgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_I_SBIR
#       ifdef PERL_CORE
#           define getgrent() (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0));})
#           else
#               define getgrent() Perl_reentr_getgrent()
                static struct group* Perl_reentr_getgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_S_SBW
#       define getgrent() (getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? (struct group *) Perl_reentrant_retry("getgrent") : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       define getgrent() (getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? (struct group *) Perl_reentrant_retry("getgrent") : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define getgrent() (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0));})
#           else
#               define getgrent() Perl_reentr_getgrent()
                static struct group* Perl_reentr_getgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrent) && GETGRENT_R_PROTO == REENTRANT_PROTO_I_SBIH
#       ifdef PERL_CORE
#           define getgrent() (((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_fptr)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_fptr)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0));})
#           else
#               define getgrent() Perl_reentr_getgrent()
                static struct group* Perl_reentr_getgrent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getgrent_r(&PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_fptr)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETGRENT */
#endif /* HAS_GETGRENT_R */

#ifdef HAS_GETGRGID_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getgrgid
#   if !defined(getgrgid) && GETGRGID_R_PROTO == REENTRANT_PROTO_I_TSBWR
#       ifdef PERL_CORE
#           define getgrgid(a) (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrgid", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrgid(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrgid", a) : 0));})
#           else
#               define getgrgid(a) Perl_reentr_getgrgid(a)
                static struct group* Perl_reentr_getgrgid(gid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrgid", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrgid) && GETGRGID_R_PROTO == REENTRANT_PROTO_I_TSBIR
#       ifdef PERL_CORE
#           define getgrgid(a) (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrgid", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrgid(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrgid", a) : 0));})
#           else
#               define getgrgid(a) Perl_reentr_getgrgid(a)
                static struct group* Perl_reentr_getgrgid(gid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrgid", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrgid) && GETGRGID_R_PROTO == REENTRANT_PROTO_I_TSBI
#       ifdef PERL_CORE
#           define getgrgid(a) (((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrgid", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrgid(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrgid", a) : 0));})
#           else
#               define getgrgid(a) Perl_reentr_getgrgid(a)
                static struct group* Perl_reentr_getgrgid(gid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrgid", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrgid) && GETGRGID_R_PROTO == REENTRANT_PROTO_S_TSBI
#       define getgrgid(a) (getgrgid_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? (struct group *) Perl_reentrant_retry("getgrgid", a) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETGRGID */
#endif /* HAS_GETGRGID_R */

#ifdef HAS_GETGRNAM_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getgrnam
#   if !defined(getgrnam) && GETGRNAM_R_PROTO == REENTRANT_PROTO_I_CSBWR
#       ifdef PERL_CORE
#           define getgrnam(a) (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrnam", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrnam(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrnam", a) : 0));})
#           else
#               define getgrnam(a) Perl_reentr_getgrnam(a)
                static struct group* Perl_reentr_getgrnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrnam", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrnam) && GETGRNAM_R_PROTO == REENTRANT_PROTO_I_CSBIR
#       ifdef PERL_CORE
#           define getgrnam(a) (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrnam", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrnam(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrnam", a) : 0));})
#           else
#               define getgrnam(a) Perl_reentr_getgrnam(a)
                static struct group* Perl_reentr_getgrnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size, &PL_reentrant_buffer->_grent_ptr)) == 0 ? PL_reentrant_buffer->_grent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrnam", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrnam) && GETGRNAM_R_PROTO == REENTRANT_PROTO_S_CBI
#       define getgrnam(a) (getgrnam_r(a, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? PL_reentrant_buffer->_grent_buffer : ((errno == ERANGE) ? (struct group *) Perl_reentrant_retry("getgrnam", a) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrnam) && GETGRNAM_R_PROTO == REENTRANT_PROTO_I_CSBI
#       ifdef PERL_CORE
#           define getgrnam(a) (((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrnam", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getgrnam(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrnam", a) : 0));})
#           else
#               define getgrnam(a) Perl_reentr_getgrnam(a)
                static struct group* Perl_reentr_getgrnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size)) == 0 ? &PL_reentrant_buffer->_grent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct group*)Perl_reentrant_retry("getgrnam", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getgrnam) && GETGRNAM_R_PROTO == REENTRANT_PROTO_S_CSBI
#       define getgrnam(a) (getgrnam_r(a, &PL_reentrant_buffer->_grent_struct, PL_reentrant_buffer->_grent_buffer, PL_reentrant_buffer->_grent_size) ? &PL_reentrant_buffer->_grent_struct : ((errno == ERANGE) ? (struct group *) Perl_reentrant_retry("getgrnam", a) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETGRNAM */
#endif /* HAS_GETGRNAM_R */

#ifdef HAS_GETHOSTBYADDR_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef gethostbyaddr
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_I_CWISBWRE
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) Perl_reentr_gethostbyaddr(a, b, c)
                static struct hostent* Perl_reentr_gethostbyaddr(const char* a, size_t b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_CWISBWIE
#       define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? (struct hostent *) Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_CWISBIE
#       define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? (struct hostent *) Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_TWISBIE
#       define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? (struct hostent *) Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_CIISBIE
#       define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? (struct hostent *) Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_CSBIE
#       define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? 1 : ((errno == ERANGE) ? (struct hostent *) Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_S_TSBIE
#       define gethostbyaddr(a, b, c) (gethostbyaddr_r(a, b, c, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? 1 : ((errno == ERANGE) ? (struct hostent *) Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_I_CWISD
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) Perl_reentr_gethostbyaddr(a, b, c)
                static struct hostent* Perl_reentr_gethostbyaddr(const char* a, size_t b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_I_CIISD
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) Perl_reentr_gethostbyaddr(a, b, c)
                static struct hostent* Perl_reentr_gethostbyaddr(const char* a, int b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_I_CII
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c)) == 0 ? 1 : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c)) == 0 ? 1 : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) Perl_reentr_gethostbyaddr(a, b, c)
                static struct hostent* Perl_reentr_gethostbyaddr(const char* a, int b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c)) == 0 ? 1 : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyaddr) && GETHOSTBYADDR_R_PROTO == REENTRANT_PROTO_I_TsISBWRE
#       ifdef PERL_CORE
#           define gethostbyaddr(a, b, c) (((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyaddr(a, b, c) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));})
#           else
#               define gethostbyaddr(a, b, c) Perl_reentr_gethostbyaddr(a, b, c)
                static struct hostent* Perl_reentr_gethostbyaddr(const void* a, socklen_t b, int c) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostbyaddr_r(a, b, c, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyaddr", a, b, c) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETHOSTBYADDR */
#endif /* HAS_GETHOSTBYADDR_R */

#ifdef HAS_GETHOSTBYNAME_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef gethostbyname
#   if !defined(gethostbyname) && GETHOSTBYNAME_R_PROTO == REENTRANT_PROTO_I_CSBWRE
#       ifdef PERL_CORE
#           define gethostbyname(a) (((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyname", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyname(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyname", a) : 0));})
#           else
#               define gethostbyname(a) Perl_reentr_gethostbyname(a)
                static struct hostent* Perl_reentr_gethostbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyname", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyname) && GETHOSTBYNAME_R_PROTO == REENTRANT_PROTO_S_CSBIE
#       define gethostbyname(a) (gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? (struct hostent *) Perl_reentrant_retry("gethostbyname", a) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostbyname) && GETHOSTBYNAME_R_PROTO == REENTRANT_PROTO_I_CSD
#       ifdef PERL_CORE
#           define gethostbyname(a) (((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyname", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostbyname(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyname", a) : 0));})
#           else
#               define gethostbyname(a) Perl_reentr_gethostbyname(a)
                static struct hostent* Perl_reentr_gethostbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostbyname_r(a, &PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostbyname", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETHOSTBYNAME */
#endif /* HAS_GETHOSTBYNAME_R */

#ifdef HAS_GETHOSTENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef gethostent
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_I_SBWRE
#       ifdef PERL_CORE
#           define gethostent() (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0));})
#           else
#               define gethostent() Perl_reentr_gethostent()
                static struct hostent* Perl_reentr_gethostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_ptr, &PL_reentrant_buffer->_hostent_errno)) == 0 ? PL_reentrant_buffer->_hostent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_I_SBIE
#       ifdef PERL_CORE
#           define gethostent() (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0));})
#           else
#               define gethostent() Perl_reentr_gethostent()
                static struct hostent* Perl_reentr_gethostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_S_SBIE
#       define gethostent() (gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size, &PL_reentrant_buffer->_hostent_errno) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? (struct hostent *) Perl_reentrant_retry("gethostent") : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       define gethostent() (gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size) ? &PL_reentrant_buffer->_hostent_struct : ((errno == ERANGE) ? (struct hostent *) Perl_reentrant_retry("gethostent") : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define gethostent() (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0));})
#           else
#               define gethostent() Perl_reentr_gethostent()
                static struct hostent* Perl_reentr_gethostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, PL_reentrant_buffer->_hostent_buffer, PL_reentrant_buffer->_hostent_size)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gethostent) && GETHOSTENT_R_PROTO == REENTRANT_PROTO_I_SD
#       ifdef PERL_CORE
#           define gethostent() (((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define gethostent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0));})
#           else
#               define gethostent() Perl_reentr_gethostent()
                static struct hostent* Perl_reentr_gethostent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = gethostent_r(&PL_reentrant_buffer->_hostent_struct, &PL_reentrant_buffer->_hostent_data)) == 0 ? &PL_reentrant_buffer->_hostent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct hostent*)Perl_reentrant_retry("gethostent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETHOSTENT */
#endif /* HAS_GETHOSTENT_R */

#ifdef HAS_GETLOGIN_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getlogin
#   if !defined(getlogin) && GETLOGIN_R_PROTO == REENTRANT_PROTO_I_BW
#       ifdef PERL_CORE
#           define getlogin() (((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size)) == 0 ? PL_reentrant_buffer->_getlogin_buffer : ((PL_REENTRANT_RETINT == ERANGE) ? (char*)Perl_reentrant_retry("getlogin") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getlogin() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size)) == 0 ? PL_reentrant_buffer->_getlogin_buffer : ((PL_REENTRANT_RETINT == ERANGE) ? (char*)Perl_reentrant_retry("getlogin") : 0));})
#           else
#               define getlogin() Perl_reentr_getlogin()
                static char* Perl_reentr_getlogin() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size)) == 0 ? PL_reentrant_buffer->_getlogin_buffer : ((PL_REENTRANT_RETINT == ERANGE) ? (char*)Perl_reentrant_retry("getlogin") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getlogin) && GETLOGIN_R_PROTO == REENTRANT_PROTO_I_BI
#       ifdef PERL_CORE
#           define getlogin() (((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size)) == 0 ? PL_reentrant_buffer->_getlogin_buffer : ((PL_REENTRANT_RETINT == ERANGE) ? (char*)Perl_reentrant_retry("getlogin") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getlogin() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size)) == 0 ? PL_reentrant_buffer->_getlogin_buffer : ((PL_REENTRANT_RETINT == ERANGE) ? (char*)Perl_reentrant_retry("getlogin") : 0));})
#           else
#               define getlogin() Perl_reentr_getlogin()
                static char* Perl_reentr_getlogin() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size)) == 0 ? PL_reentrant_buffer->_getlogin_buffer : ((PL_REENTRANT_RETINT == ERANGE) ? (char*)Perl_reentrant_retry("getlogin") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getlogin) && GETLOGIN_R_PROTO == REENTRANT_PROTO_B_BW
#       define getlogin() getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getlogin) && GETLOGIN_R_PROTO == REENTRANT_PROTO_B_BI
#       define getlogin() getlogin_r(PL_reentrant_buffer->_getlogin_buffer, PL_reentrant_buffer->_getlogin_size)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETLOGIN */
#endif /* HAS_GETLOGIN_R */

#ifdef HAS_GETNETBYADDR_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getnetbyaddr
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_UISBWRE
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) Perl_reentr_getnetbyaddr(a, b)
                static struct netent* Perl_reentr_getnetbyaddr(unsigned long a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_LISBI
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) Perl_reentr_getnetbyaddr(a, b)
                static struct netent* Perl_reentr_getnetbyaddr(long a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_S_TISBI
#       define getnetbyaddr(a, b) (getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? (struct netent *) Perl_reentrant_retry("getnetbyaddr", a, b) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_S_LISBI
#       define getnetbyaddr(a, b) (getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? (struct netent *) Perl_reentrant_retry("getnetbyaddr", a, b) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_TISD
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) Perl_reentr_getnetbyaddr(a, b)
                static struct netent* Perl_reentr_getnetbyaddr(in_addr_t a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_LISD
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) Perl_reentr_getnetbyaddr(a, b)
                static struct netent* Perl_reentr_getnetbyaddr(long a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_IISD
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) Perl_reentr_getnetbyaddr(a, b)
                static struct netent* Perl_reentr_getnetbyaddr(int a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetbyaddr) && GETNETBYADDR_R_PROTO == REENTRANT_PROTO_I_uISBWRE
#       ifdef PERL_CORE
#           define getnetbyaddr(a, b) (((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyaddr(a, b) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));})
#           else
#               define getnetbyaddr(a, b) Perl_reentr_getnetbyaddr(a, b)
                static struct netent* Perl_reentr_getnetbyaddr(uint32_t a, int b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetbyaddr_r(a, b, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyaddr", a, b) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETNETBYADDR */
#endif /* HAS_GETNETBYADDR_R */

#ifdef HAS_GETNETBYNAME_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getnetbyname
#   if !defined(getnetbyname) && GETNETBYNAME_R_PROTO == REENTRANT_PROTO_I_CSBWRE
#       ifdef PERL_CORE
#           define getnetbyname(a) (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyname", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyname(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyname", a) : 0));})
#           else
#               define getnetbyname(a) Perl_reentr_getnetbyname(a)
                static struct netent* Perl_reentr_getnetbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyname", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetbyname) && GETNETBYNAME_R_PROTO == REENTRANT_PROTO_I_CSBI
#       ifdef PERL_CORE
#           define getnetbyname(a) (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyname", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyname(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyname", a) : 0));})
#           else
#               define getnetbyname(a) Perl_reentr_getnetbyname(a)
                static struct netent* Perl_reentr_getnetbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyname", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetbyname) && GETNETBYNAME_R_PROTO == REENTRANT_PROTO_S_CSBI
#       define getnetbyname(a) (getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? (struct netent *) Perl_reentrant_retry("getnetbyname", a) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetbyname) && GETNETBYNAME_R_PROTO == REENTRANT_PROTO_I_CSD
#       ifdef PERL_CORE
#           define getnetbyname(a) (((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyname", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetbyname(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyname", a) : 0));})
#           else
#               define getnetbyname(a) Perl_reentr_getnetbyname(a)
                static struct netent* Perl_reentr_getnetbyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetbyname_r(a, &PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetbyname", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETNETBYNAME */
#endif /* HAS_GETNETBYNAME_R */

#ifdef HAS_GETNETENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getnetent
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_I_SBWRE
#       ifdef PERL_CORE
#           define getnetent() (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0));})
#           else
#               define getnetent() Perl_reentr_getnetent()
                static struct netent* Perl_reentr_getnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_ptr, &PL_reentrant_buffer->_netent_errno)) == 0 ? PL_reentrant_buffer->_netent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_I_SBIE
#       ifdef PERL_CORE
#           define getnetent() (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_errno)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_errno)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0));})
#           else
#               define getnetent() Perl_reentr_getnetent()
                static struct netent* Perl_reentr_getnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_errno)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_S_SBIE
#       define getnetent() (getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size, &PL_reentrant_buffer->_netent_errno) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? (struct netent *) Perl_reentrant_retry("getnetent") : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       define getnetent() (getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size) ? &PL_reentrant_buffer->_netent_struct : ((errno == ERANGE) ? (struct netent *) Perl_reentrant_retry("getnetent") : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define getnetent() (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0));})
#           else
#               define getnetent() Perl_reentr_getnetent()
                static struct netent* Perl_reentr_getnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, PL_reentrant_buffer->_netent_buffer, PL_reentrant_buffer->_netent_size)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getnetent) && GETNETENT_R_PROTO == REENTRANT_PROTO_I_SD
#       ifdef PERL_CORE
#           define getnetent() (((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getnetent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0));})
#           else
#               define getnetent() Perl_reentr_getnetent()
                static struct netent* Perl_reentr_getnetent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getnetent_r(&PL_reentrant_buffer->_netent_struct, &PL_reentrant_buffer->_netent_data)) == 0 ? &PL_reentrant_buffer->_netent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct netent*)Perl_reentrant_retry("getnetent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETNETENT */
#endif /* HAS_GETNETENT_R */

#ifdef HAS_GETPROTOBYNAME_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getprotobyname
#   if !defined(getprotobyname) && GETPROTOBYNAME_R_PROTO == REENTRANT_PROTO_I_CSBWR
#       ifdef PERL_CORE
#           define getprotobyname(a) (((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr)) == 0 ? PL_reentrant_buffer->_protoent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobyname", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotobyname(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr)) == 0 ? PL_reentrant_buffer->_protoent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobyname", a) : 0));})
#           else
#               define getprotobyname(a) Perl_reentr_getprotobyname(a)
                static struct protoent* Perl_reentr_getprotobyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr)) == 0 ? PL_reentrant_buffer->_protoent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobyname", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getprotobyname) && GETPROTOBYNAME_R_PROTO == REENTRANT_PROTO_S_CSBI
#       define getprotobyname(a) (getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? (struct protoent *) Perl_reentrant_retry("getprotobyname", a) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getprotobyname) && GETPROTOBYNAME_R_PROTO == REENTRANT_PROTO_I_CSD
#       ifdef PERL_CORE
#           define getprotobyname(a) (REENTR_MEMZERO(&PL_reentrant_buffer->_protoent_data, sizeof(PL_reentrant_buffer->_protoent_data)), ((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobyname", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotobyname(a) ({int PL_REENTRANT_RETINT; REENTR_MEMZERO(&PL_reentrant_buffer->_protoent_data, sizeof(PL_reentrant_buffer->_protoent_data)); ((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobyname", a) : 0));})
#           else
#               define getprotobyname(a) Perl_reentr_getprotobyname(a)
                static struct protoent* Perl_reentr_getprotobyname(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    REENTR_MEMZERO(&PL_reentrant_buffer->_protoent_data, sizeof(PL_reentrant_buffer->_protoent_data));
		    return ((PL_REENTRANT_RETINT = getprotobyname_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobyname", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETPROTOBYNAME */
#endif /* HAS_GETPROTOBYNAME_R */

#ifdef HAS_GETPROTOBYNUMBER_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getprotobynumber
#   if !defined(getprotobynumber) && GETPROTOBYNUMBER_R_PROTO == REENTRANT_PROTO_I_ISBWR
#       ifdef PERL_CORE
#           define getprotobynumber(a) (((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr)) == 0 ? PL_reentrant_buffer->_protoent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobynumber", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotobynumber(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr)) == 0 ? PL_reentrant_buffer->_protoent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobynumber", a) : 0));})
#           else
#               define getprotobynumber(a) Perl_reentr_getprotobynumber(a)
                static struct protoent* Perl_reentr_getprotobynumber(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr)) == 0 ? PL_reentrant_buffer->_protoent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobynumber", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getprotobynumber) && GETPROTOBYNUMBER_R_PROTO == REENTRANT_PROTO_S_ISBI
#       define getprotobynumber(a) (getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? (struct protoent *) Perl_reentrant_retry("getprotobynumber", a) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getprotobynumber) && GETPROTOBYNUMBER_R_PROTO == REENTRANT_PROTO_I_ISD
#       ifdef PERL_CORE
#           define getprotobynumber(a) (REENTR_MEMZERO(&PL_reentrant_buffer->_protoent_data, sizeof(PL_reentrant_buffer->_protoent_data)), ((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobynumber", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotobynumber(a) ({int PL_REENTRANT_RETINT; REENTR_MEMZERO(&PL_reentrant_buffer->_protoent_data, sizeof(PL_reentrant_buffer->_protoent_data)); ((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobynumber", a) : 0));})
#           else
#               define getprotobynumber(a) Perl_reentr_getprotobynumber(a)
                static struct protoent* Perl_reentr_getprotobynumber(int a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    REENTR_MEMZERO(&PL_reentrant_buffer->_protoent_data, sizeof(PL_reentrant_buffer->_protoent_data));
		    return ((PL_REENTRANT_RETINT = getprotobynumber_r(a, &PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotobynumber", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETPROTOBYNUMBER */
#endif /* HAS_GETPROTOBYNUMBER_R */

#ifdef HAS_GETPROTOENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getprotoent
#   if !defined(getprotoent) && GETPROTOENT_R_PROTO == REENTRANT_PROTO_I_SBWR
#       ifdef PERL_CORE
#           define getprotoent() (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr)) == 0 ? PL_reentrant_buffer->_protoent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotoent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotoent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr)) == 0 ? PL_reentrant_buffer->_protoent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotoent") : 0));})
#           else
#               define getprotoent() Perl_reentr_getprotoent()
                static struct protoent* Perl_reentr_getprotoent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size, &PL_reentrant_buffer->_protoent_ptr)) == 0 ? PL_reentrant_buffer->_protoent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotoent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getprotoent) && GETPROTOENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define getprotoent() (((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotoent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotoent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotoent") : 0));})
#           else
#               define getprotoent() Perl_reentr_getprotoent()
                static struct protoent* Perl_reentr_getprotoent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotoent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getprotoent) && GETPROTOENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       define getprotoent() (getprotoent_r(&PL_reentrant_buffer->_protoent_struct, PL_reentrant_buffer->_protoent_buffer, PL_reentrant_buffer->_protoent_size) ? &PL_reentrant_buffer->_protoent_struct : ((errno == ERANGE) ? (struct protoent *) Perl_reentrant_retry("getprotoent") : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getprotoent) && GETPROTOENT_R_PROTO == REENTRANT_PROTO_I_SD
#       ifdef PERL_CORE
#           define getprotoent() (REENTR_MEMZERO(&PL_reentrant_buffer->_protoent_data, sizeof(PL_reentrant_buffer->_protoent_data)), ((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotoent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getprotoent() ({int PL_REENTRANT_RETINT; REENTR_MEMZERO(&PL_reentrant_buffer->_protoent_data, sizeof(PL_reentrant_buffer->_protoent_data)); ((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotoent") : 0));})
#           else
#               define getprotoent() Perl_reentr_getprotoent()
                static struct protoent* Perl_reentr_getprotoent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    REENTR_MEMZERO(&PL_reentrant_buffer->_protoent_data, sizeof(PL_reentrant_buffer->_protoent_data));
		    return ((PL_REENTRANT_RETINT = getprotoent_r(&PL_reentrant_buffer->_protoent_struct, &PL_reentrant_buffer->_protoent_data)) == 0 ? &PL_reentrant_buffer->_protoent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct protoent*)Perl_reentrant_retry("getprotoent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETPROTOENT */
#endif /* HAS_GETPROTOENT_R */

#ifdef HAS_GETPWENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getpwent
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_I_SBWR
#       ifdef PERL_CORE
#           define getpwent() (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0));})
#           else
#               define getpwent() Perl_reentr_getpwent()
                static struct passwd* Perl_reentr_getpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_I_SBIR
#       ifdef PERL_CORE
#           define getpwent() (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0));})
#           else
#               define getpwent() Perl_reentr_getpwent()
                static struct passwd* Perl_reentr_getpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_S_SBW
#       define getpwent() (getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? (struct passwd *) Perl_reentrant_retry("getpwent") : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       define getpwent() (getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? (struct passwd *) Perl_reentrant_retry("getpwent") : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define getpwent() (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0));})
#           else
#               define getpwent() Perl_reentr_getpwent()
                static struct passwd* Perl_reentr_getpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwent) && GETPWENT_R_PROTO == REENTRANT_PROTO_I_SBIH
#       ifdef PERL_CORE
#           define getpwent() (((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_fptr)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_fptr)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0));})
#           else
#               define getpwent() Perl_reentr_getpwent()
                static struct passwd* Perl_reentr_getpwent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getpwent_r(&PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_fptr)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETPWENT */
#endif /* HAS_GETPWENT_R */

#ifdef HAS_GETPWNAM_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getpwnam
#   if !defined(getpwnam) && GETPWNAM_R_PROTO == REENTRANT_PROTO_I_CSBWR
#       ifdef PERL_CORE
#           define getpwnam(a) (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwnam", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwnam(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwnam", a) : 0));})
#           else
#               define getpwnam(a) Perl_reentr_getpwnam(a)
                static struct passwd* Perl_reentr_getpwnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwnam", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwnam) && GETPWNAM_R_PROTO == REENTRANT_PROTO_I_CSBIR
#       ifdef PERL_CORE
#           define getpwnam(a) (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwnam", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwnam(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwnam", a) : 0));})
#           else
#               define getpwnam(a) Perl_reentr_getpwnam(a)
                static struct passwd* Perl_reentr_getpwnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwnam", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwnam) && GETPWNAM_R_PROTO == REENTRANT_PROTO_S_CSBI
#       define getpwnam(a) (getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? (struct passwd *) Perl_reentrant_retry("getpwnam", a) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwnam) && GETPWNAM_R_PROTO == REENTRANT_PROTO_I_CSBI
#       ifdef PERL_CORE
#           define getpwnam(a) (((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwnam", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwnam(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwnam", a) : 0));})
#           else
#               define getpwnam(a) Perl_reentr_getpwnam(a)
                static struct passwd* Perl_reentr_getpwnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getpwnam_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwnam", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETPWNAM */
#endif /* HAS_GETPWNAM_R */

#ifdef HAS_GETPWUID_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getpwuid
#   if !defined(getpwuid) && GETPWUID_R_PROTO == REENTRANT_PROTO_I_TSBWR
#       ifdef PERL_CORE
#           define getpwuid(a) (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwuid", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwuid(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwuid", a) : 0));})
#           else
#               define getpwuid(a) Perl_reentr_getpwuid(a)
                static struct passwd* Perl_reentr_getpwuid(uid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwuid", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwuid) && GETPWUID_R_PROTO == REENTRANT_PROTO_I_TSBIR
#       ifdef PERL_CORE
#           define getpwuid(a) (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwuid", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwuid(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwuid", a) : 0));})
#           else
#               define getpwuid(a) Perl_reentr_getpwuid(a)
                static struct passwd* Perl_reentr_getpwuid(uid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size, &PL_reentrant_buffer->_pwent_ptr)) == 0 ? PL_reentrant_buffer->_pwent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwuid", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwuid) && GETPWUID_R_PROTO == REENTRANT_PROTO_I_TSBI
#       ifdef PERL_CORE
#           define getpwuid(a) (((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwuid", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getpwuid(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwuid", a) : 0));})
#           else
#               define getpwuid(a) Perl_reentr_getpwuid(a)
                static struct passwd* Perl_reentr_getpwuid(uid_t a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size)) == 0 ? &PL_reentrant_buffer->_pwent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct passwd*)Perl_reentrant_retry("getpwuid", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getpwuid) && GETPWUID_R_PROTO == REENTRANT_PROTO_S_TSBI
#       define getpwuid(a) (getpwuid_r(a, &PL_reentrant_buffer->_pwent_struct, PL_reentrant_buffer->_pwent_buffer, PL_reentrant_buffer->_pwent_size) ? &PL_reentrant_buffer->_pwent_struct : ((errno == ERANGE) ? (struct passwd *) Perl_reentrant_retry("getpwuid", a) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETPWUID */
#endif /* HAS_GETPWUID_R */

#ifdef HAS_GETSERVBYNAME_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getservbyname
#   if !defined(getservbyname) && GETSERVBYNAME_R_PROTO == REENTRANT_PROTO_I_CCSBWR
#       ifdef PERL_CORE
#           define getservbyname(a, b) (((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr)) == 0 ? PL_reentrant_buffer->_servent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyname", a, b) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservbyname(a, b) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr)) == 0 ? PL_reentrant_buffer->_servent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyname", a, b) : 0));})
#           else
#               define getservbyname(a, b) Perl_reentr_getservbyname(a, b)
                static struct servent* Perl_reentr_getservbyname(const char* a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr)) == 0 ? PL_reentrant_buffer->_servent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyname", a, b) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getservbyname) && GETSERVBYNAME_R_PROTO == REENTRANT_PROTO_S_CCSBI
#       define getservbyname(a, b) (getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? (struct servent *) Perl_reentrant_retry("getservbyname", a, b) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getservbyname) && GETSERVBYNAME_R_PROTO == REENTRANT_PROTO_I_CCSD
#       ifdef PERL_CORE
#           define getservbyname(a, b) (REENTR_MEMZERO(&PL_reentrant_buffer->_servent_data, sizeof(PL_reentrant_buffer->_servent_data)), ((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyname", a, b) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservbyname(a, b) ({int PL_REENTRANT_RETINT; REENTR_MEMZERO(&PL_reentrant_buffer->_servent_data, sizeof(PL_reentrant_buffer->_servent_data)); ((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyname", a, b) : 0));})
#           else
#               define getservbyname(a, b) Perl_reentr_getservbyname(a, b)
                static struct servent* Perl_reentr_getservbyname(const char* a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    REENTR_MEMZERO(&PL_reentrant_buffer->_servent_data, sizeof(PL_reentrant_buffer->_servent_data));
		    return ((PL_REENTRANT_RETINT = getservbyname_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyname", a, b) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETSERVBYNAME */
#endif /* HAS_GETSERVBYNAME_R */

#ifdef HAS_GETSERVBYPORT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getservbyport
#   if !defined(getservbyport) && GETSERVBYPORT_R_PROTO == REENTRANT_PROTO_I_ICSBWR
#       ifdef PERL_CORE
#           define getservbyport(a, b) (((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr)) == 0 ? PL_reentrant_buffer->_servent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyport", a, b) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservbyport(a, b) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr)) == 0 ? PL_reentrant_buffer->_servent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyport", a, b) : 0));})
#           else
#               define getservbyport(a, b) Perl_reentr_getservbyport(a, b)
                static struct servent* Perl_reentr_getservbyport(int a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr)) == 0 ? PL_reentrant_buffer->_servent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyport", a, b) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getservbyport) && GETSERVBYPORT_R_PROTO == REENTRANT_PROTO_S_ICSBI
#       define getservbyport(a, b) (getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? (struct servent *) Perl_reentrant_retry("getservbyport", a, b) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getservbyport) && GETSERVBYPORT_R_PROTO == REENTRANT_PROTO_I_ICSD
#       ifdef PERL_CORE
#           define getservbyport(a, b) (REENTR_MEMZERO(&PL_reentrant_buffer->_servent_data, sizeof(PL_reentrant_buffer->_servent_data)), ((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyport", a, b) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservbyport(a, b) ({int PL_REENTRANT_RETINT; REENTR_MEMZERO(&PL_reentrant_buffer->_servent_data, sizeof(PL_reentrant_buffer->_servent_data)); ((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyport", a, b) : 0));})
#           else
#               define getservbyport(a, b) Perl_reentr_getservbyport(a, b)
                static struct servent* Perl_reentr_getservbyport(int a, const char* b) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    REENTR_MEMZERO(&PL_reentrant_buffer->_servent_data, sizeof(PL_reentrant_buffer->_servent_data));
		    return ((PL_REENTRANT_RETINT = getservbyport_r(a, b, &PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservbyport", a, b) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETSERVBYPORT */
#endif /* HAS_GETSERVBYPORT_R */

#ifdef HAS_GETSERVENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getservent
#   if !defined(getservent) && GETSERVENT_R_PROTO == REENTRANT_PROTO_I_SBWR
#       ifdef PERL_CORE
#           define getservent() (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr)) == 0 ? PL_reentrant_buffer->_servent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr)) == 0 ? PL_reentrant_buffer->_servent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservent") : 0));})
#           else
#               define getservent() Perl_reentr_getservent()
                static struct servent* Perl_reentr_getservent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size, &PL_reentrant_buffer->_servent_ptr)) == 0 ? PL_reentrant_buffer->_servent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getservent) && GETSERVENT_R_PROTO == REENTRANT_PROTO_I_SBI
#       ifdef PERL_CORE
#           define getservent() (((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservent() ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservent") : 0));})
#           else
#               define getservent() Perl_reentr_getservent()
                static struct servent* Perl_reentr_getservent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getservent) && GETSERVENT_R_PROTO == REENTRANT_PROTO_S_SBI
#       define getservent() (getservent_r(&PL_reentrant_buffer->_servent_struct, PL_reentrant_buffer->_servent_buffer, PL_reentrant_buffer->_servent_size) ? &PL_reentrant_buffer->_servent_struct : ((errno == ERANGE) ? (struct servent *) Perl_reentrant_retry("getservent") : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getservent) && GETSERVENT_R_PROTO == REENTRANT_PROTO_I_SD
#       ifdef PERL_CORE
#           define getservent() (REENTR_MEMZERO(&PL_reentrant_buffer->_servent_data, sizeof(PL_reentrant_buffer->_servent_data)), ((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservent") : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getservent() ({int PL_REENTRANT_RETINT; REENTR_MEMZERO(&PL_reentrant_buffer->_servent_data, sizeof(PL_reentrant_buffer->_servent_data)); ((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservent") : 0));})
#           else
#               define getservent() Perl_reentr_getservent()
                static struct servent* Perl_reentr_getservent() {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    REENTR_MEMZERO(&PL_reentrant_buffer->_servent_data, sizeof(PL_reentrant_buffer->_servent_data));
		    return ((PL_REENTRANT_RETINT = getservent_r(&PL_reentrant_buffer->_servent_struct, &PL_reentrant_buffer->_servent_data)) == 0 ? &PL_reentrant_buffer->_servent_struct : ((PL_REENTRANT_RETINT == ERANGE) ? (struct servent*)Perl_reentrant_retry("getservent") : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETSERVENT */
#endif /* HAS_GETSERVENT_R */

#ifdef HAS_GETSPNAM_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef getspnam
#   if !defined(getspnam) && GETSPNAM_R_PROTO == REENTRANT_PROTO_I_CSBWR
#       ifdef PERL_CORE
#           define getspnam(a) (((PL_REENTRANT_RETINT = getspnam_r(a, &PL_reentrant_buffer->_spent_struct, PL_reentrant_buffer->_spent_buffer, PL_reentrant_buffer->_spent_size, &PL_reentrant_buffer->_spent_ptr)) == 0 ? PL_reentrant_buffer->_spent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct spwd*)Perl_reentrant_retry("getspnam", a) : 0)))
#       else
#           if defined(__GNUC__) && !defined(__STRICT_ANSI__) && !defined(PERL_GCC_PEDANTIC)
#               define getspnam(a) ({int PL_REENTRANT_RETINT; ; ((PL_REENTRANT_RETINT = getspnam_r(a, &PL_reentrant_buffer->_spent_struct, PL_reentrant_buffer->_spent_buffer, PL_reentrant_buffer->_spent_size, &PL_reentrant_buffer->_spent_ptr)) == 0 ? PL_reentrant_buffer->_spent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct spwd*)Perl_reentrant_retry("getspnam", a) : 0));})
#           else
#               define getspnam(a) Perl_reentr_getspnam(a)
                static struct spwd* Perl_reentr_getspnam(const char* a) {
                    dTHX;
                    int PL_REENTRANT_RETINT;
                    ;
		    return ((PL_REENTRANT_RETINT = getspnam_r(a, &PL_reentrant_buffer->_spent_struct, PL_reentrant_buffer->_spent_buffer, PL_reentrant_buffer->_spent_size, &PL_reentrant_buffer->_spent_ptr)) == 0 ? PL_reentrant_buffer->_spent_ptr : ((PL_REENTRANT_RETINT == ERANGE) ? (struct spwd*)Perl_reentrant_retry("getspnam", a) : 0));
                }
#           endif
#       endif
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(getspnam) && GETSPNAM_R_PROTO == REENTRANT_PROTO_S_CSBI
#       define getspnam(a) (getspnam_r(a, &PL_reentrant_buffer->_spent_struct, PL_reentrant_buffer->_spent_buffer, PL_reentrant_buffer->_spent_size) ? &PL_reentrant_buffer->_spent_struct : ((errno == ERANGE) ? (struct spwd *) Perl_reentrant_retry("getspnam", a) : 0))
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GETSPNAM */
#endif /* HAS_GETSPNAM_R */

#ifdef HAS_GMTIME_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef gmtime
#   if !defined(gmtime) && GMTIME_R_PROTO == REENTRANT_PROTO_S_TS
#       define gmtime(a) (gmtime_r(a, &PL_reentrant_buffer->_gmtime_struct) ? &PL_reentrant_buffer->_gmtime_struct : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(gmtime) && GMTIME_R_PROTO == REENTRANT_PROTO_I_TS
#       define gmtime(a) (gmtime_r(a, &PL_reentrant_buffer->_gmtime_struct) == 0 ? &PL_reentrant_buffer->_gmtime_struct : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_GMTIME */
#endif /* HAS_GMTIME_R */

#ifdef HAS_LOCALTIME_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef localtime
#   if !defined(localtime) && LOCALTIME_R_PROTO == REENTRANT_PROTO_S_TS
#       define localtime(a) (L_R_TZSET localtime_r(a, &PL_reentrant_buffer->_localtime_struct) ? &PL_reentrant_buffer->_localtime_struct : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(localtime) && LOCALTIME_R_PROTO == REENTRANT_PROTO_I_TS
#       define localtime(a) (L_R_TZSET localtime_r(a, &PL_reentrant_buffer->_localtime_struct) == 0 ? &PL_reentrant_buffer->_localtime_struct : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_LOCALTIME */
#endif /* HAS_LOCALTIME_R */

#ifdef HAS_RANDOM_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef random
#   if !defined(random) && RANDOM_R_PROTO == REENTRANT_PROTO_I_iS
#       define random() (random_r(&PL_reentrant_buffer->_random_retval, &PL_reentrant_buffer->_random_struct) == 0 ? PL_reentrant_buffer->_random_retval : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(random) && RANDOM_R_PROTO == REENTRANT_PROTO_I_lS
#       define random() (random_r(&PL_reentrant_buffer->_random_retval, &PL_reentrant_buffer->_random_struct) == 0 ? PL_reentrant_buffer->_random_retval : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(random) && RANDOM_R_PROTO == REENTRANT_PROTO_I_St
#       define random() (random_r(&PL_reentrant_buffer->_random_struct, &PL_reentrant_buffer->_random_retval) == 0 ? PL_reentrant_buffer->_random_retval : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_RANDOM */
#endif /* HAS_RANDOM_R */

#ifdef HAS_READDIR_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef readdir
#   if !defined(readdir) && READDIR_R_PROTO == REENTRANT_PROTO_I_TSR
#       define readdir(a) (readdir_r(a, PL_reentrant_buffer->_readdir_struct, &PL_reentrant_buffer->_readdir_ptr) == 0 ? PL_reentrant_buffer->_readdir_ptr : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(readdir) && READDIR_R_PROTO == REENTRANT_PROTO_I_TS
#       define readdir(a) (readdir_r(a, PL_reentrant_buffer->_readdir_struct) == 0 ? PL_reentrant_buffer->_readdir_struct : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_READDIR */
#endif /* HAS_READDIR_R */

#ifdef HAS_READDIR64_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef readdir64
#   if !defined(readdir64) && READDIR64_R_PROTO == REENTRANT_PROTO_I_TSR
#       define readdir64(a) (readdir64_r(a, PL_reentrant_buffer->_readdir64_struct, &PL_reentrant_buffer->_readdir64_ptr) == 0 ? PL_reentrant_buffer->_readdir64_ptr : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(readdir64) && READDIR64_R_PROTO == REENTRANT_PROTO_I_TS
#       define readdir64(a) (readdir64_r(a, PL_reentrant_buffer->_readdir64_struct) == 0 ? PL_reentrant_buffer->_readdir64_struct : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_READDIR64 */
#endif /* HAS_READDIR64_R */

#ifdef HAS_SETGRENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef setgrent
#   if !defined(setgrent) && SETGRENT_R_PROTO == REENTRANT_PROTO_I_H
#       define setgrent() (setgrent_r(&PL_reentrant_buffer->_grent_fptr) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(setgrent) && SETGRENT_R_PROTO == REENTRANT_PROTO_V_H
#       define setgrent() setgrent_r(&PL_reentrant_buffer->_grent_fptr)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_SETGRENT */
#endif /* HAS_SETGRENT_R */

#ifdef HAS_SETHOSTENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef sethostent
#   if !defined(sethostent) && SETHOSTENT_R_PROTO == REENTRANT_PROTO_I_ID
#       define sethostent(a) (sethostent_r(a, &PL_reentrant_buffer->_hostent_data) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(sethostent) && SETHOSTENT_R_PROTO == REENTRANT_PROTO_V_ID
#       define sethostent(a) sethostent_r(a, &PL_reentrant_buffer->_hostent_data)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_SETHOSTENT */
#endif /* HAS_SETHOSTENT_R */

#ifdef HAS_SETLOCALE_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef setlocale
#   if !defined(setlocale) && SETLOCALE_R_PROTO == REENTRANT_PROTO_I_ICBI
#       define setlocale(a, b) (setlocale_r(a, b, PL_reentrant_buffer->_setlocale_buffer, PL_reentrant_buffer->_setlocale_size) == 0 ? PL_reentrant_buffer->_setlocale_buffer : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_SETLOCALE */
#endif /* HAS_SETLOCALE_R */

#ifdef HAS_SETNETENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef setnetent
#   if !defined(setnetent) && SETNETENT_R_PROTO == REENTRANT_PROTO_I_ID
#       define setnetent(a) (setnetent_r(a, &PL_reentrant_buffer->_netent_data) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(setnetent) && SETNETENT_R_PROTO == REENTRANT_PROTO_V_ID
#       define setnetent(a) setnetent_r(a, &PL_reentrant_buffer->_netent_data)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_SETNETENT */
#endif /* HAS_SETNETENT_R */

#ifdef HAS_SETPROTOENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef setprotoent
#   if !defined(setprotoent) && SETPROTOENT_R_PROTO == REENTRANT_PROTO_I_ID
#       define setprotoent(a) (setprotoent_r(a, &PL_reentrant_buffer->_protoent_data) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(setprotoent) && SETPROTOENT_R_PROTO == REENTRANT_PROTO_V_ID
#       define setprotoent(a) setprotoent_r(a, &PL_reentrant_buffer->_protoent_data)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_SETPROTOENT */
#endif /* HAS_SETPROTOENT_R */

#ifdef HAS_SETPWENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef setpwent
#   if !defined(setpwent) && SETPWENT_R_PROTO == REENTRANT_PROTO_I_H
#       define setpwent() (setpwent_r(&PL_reentrant_buffer->_pwent_fptr) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(setpwent) && SETPWENT_R_PROTO == REENTRANT_PROTO_V_H
#       define setpwent() setpwent_r(&PL_reentrant_buffer->_pwent_fptr)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_SETPWENT */
#endif /* HAS_SETPWENT_R */

#ifdef HAS_SETSERVENT_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef setservent
#   if !defined(setservent) && SETSERVENT_R_PROTO == REENTRANT_PROTO_I_ID
#       define setservent(a) (setservent_r(a, &PL_reentrant_buffer->_servent_data) == 0 ? 1 : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(setservent) && SETSERVENT_R_PROTO == REENTRANT_PROTO_V_ID
#       define setservent(a) setservent_r(a, &PL_reentrant_buffer->_servent_data)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_SETSERVENT */
#endif /* HAS_SETSERVENT_R */

#ifdef HAS_SRAND48_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef srand48
#   if !defined(srand48) && SRAND48_R_PROTO == REENTRANT_PROTO_I_LS
#       define srand48(a) (srand48_r(a, &PL_reentrant_buffer->_drand48_struct) == 0 ? &PL_reentrant_buffer->_drand48_struct : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_SRAND48 */
#endif /* HAS_SRAND48_R */

#ifdef HAS_SRANDOM_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef srandom
#   if !defined(srandom) && SRANDOM_R_PROTO == REENTRANT_PROTO_I_TS
#       define srandom(a) (srandom_r(a, &PL_reentrant_buffer->_srandom_struct) == 0 ? &PL_reentrant_buffer->_srandom_struct : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_SRANDOM */
#endif /* HAS_SRANDOM_R */

#ifdef HAS_STRERROR_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef strerror
#   if !defined(strerror) && STRERROR_R_PROTO == REENTRANT_PROTO_I_IBW
#       define strerror(a) (strerror_r(a, PL_reentrant_buffer->_strerror_buffer, PL_reentrant_buffer->_strerror_size) == 0 ? PL_reentrant_buffer->_strerror_buffer : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(strerror) && STRERROR_R_PROTO == REENTRANT_PROTO_I_IBI
#       define strerror(a) (strerror_r(a, PL_reentrant_buffer->_strerror_buffer, PL_reentrant_buffer->_strerror_size) == 0 ? PL_reentrant_buffer->_strerror_buffer : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(strerror) && STRERROR_R_PROTO == REENTRANT_PROTO_B_IBW
#       define strerror(a) strerror_r(a, PL_reentrant_buffer->_strerror_buffer, PL_reentrant_buffer->_strerror_size)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_STRERROR */
#endif /* HAS_STRERROR_R */

#ifdef HAS_TMPNAM_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef tmpnam
#   if !defined(tmpnam) && TMPNAM_R_PROTO == REENTRANT_PROTO_B_B
#       define tmpnam(a) tmpnam_r(a)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_TMPNAM */
#endif /* HAS_TMPNAM_R */

#ifdef HAS_TTYNAME_R
#  if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1)
#   undef ttyname
#   if !defined(ttyname) && TTYNAME_R_PROTO == REENTRANT_PROTO_I_IBW
#       define ttyname(a) (ttyname_r(a, PL_reentrant_buffer->_ttyname_buffer, PL_reentrant_buffer->_ttyname_size) == 0 ? PL_reentrant_buffer->_ttyname_buffer : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(ttyname) && TTYNAME_R_PROTO == REENTRANT_PROTO_I_IBI
#       define ttyname(a) (ttyname_r(a, PL_reentrant_buffer->_ttyname_buffer, PL_reentrant_buffer->_ttyname_size) == 0 ? PL_reentrant_buffer->_ttyname_buffer : 0)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   if !defined(ttyname) && TTYNAME_R_PROTO == REENTRANT_PROTO_B_IBI
#       define ttyname(a) ttyname_r(a, PL_reentrant_buffer->_ttyname_buffer, PL_reentrant_buffer->_ttyname_size)
#  endif /* if defined(PERL_REENTR_API) && (PERL_REENTR_API+0 == 1) */
#   endif /* HAS_TTYNAME */
#endif /* HAS_TTYNAME_R */



#endif /* USE_REENTRANT_API */
 
#endif

/* ex: set ro: */
