# Generated by default/object.tt
package Paws::S3Control::Exclude;
  use Moose;
  has Buckets => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'Arn', traits => ['NameInRequest']);
  has Regions => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'Region', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3Control::Exclude

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3Control::Exclude object:

  $service_obj->Method(Att1 => { Buckets => $value, ..., Regions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3Control::Exclude object:

  $result = $service_obj->Method(...);
  $result->Att1->Buckets

=head1 DESCRIPTION

A container for what Amazon S3 Storage Lens will exclude.

=head1 ATTRIBUTES


=head2 Buckets => ArrayRef[Str|Undef]

A container for the S3 Storage Lens bucket excludes.


=head2 Regions => ArrayRef[Str|Undef]

A container for the S3 Storage Lens Region excludes.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3Control>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

