#
# Test for two bugs:
#
# mod_persistentperl mixes up the perperl options on the #! line in the script
#
# mod_persistentperl can't switch tempbase between scripts because it holds open
# the tempfile.


use lib 't';
use ModTest;

my $version   = `httpd -v` =~ /Apache.2/ ? 2 : 1;
my $moddir    = `apxs -q LIBEXECDIR`;
chomp $moddir;
my $addmodule = $version > 1 ? '' : 'AddModule mod_env.c';

my $scr = 'perperl/env';

ModTest::test_init(5, [$scr], "
	<IfModule !mod_env.c>
	LoadModule env_module $moddir/mod_env.so
	$addmodule
	</IfModule>
	SetEnv	\"ENVTEST\" \"XXX\"
");

print "1..1\n";
my $txt = &ModTest::html_get("/$scr");
if ($txt =~ /ENVTEST=XXX/) {
    print "ok\n";
} else {
    print "not ok\n";
}
