class EntityUpdate {

	has $!dx;
	has $!dy;

	has $!ddx;
	has $!ddy;

	submethod BUILD(:$ddx, :$ddy) {
		.init($ddx,$ddy);
	}

	multi method init($ddx, $ddy) {
		.ddx = $ddx;
		.ddy = $ddy;
	}

	multi method get-dxdy {
		return (.dx, .dy);
	}

	multi method move-not {
		.dx = 0; 	
		.dy = 0; 	
	}

	multi method move-left {
		.dx = -1 * .ddx; 
		.dy = 0;	
	}

	multi method move-right {
		.dx = +1 * .ddx; 	
		.dy = 0;	
	}

	multi method move-up {
		.dx = 0;
		.dy = -1 * .ddy; 	
	}

	multi method move-down {
		.dx = 0;
		.dy = +1 * .ddy; 	
	}

}
