# Generated by default/object.tt
package Paws::AutoScaling::InstanceRefreshWarmPoolProgress;
  use Moose;
  has InstancesToUpdate => (is => 'ro', isa => 'Int');
  has PercentageComplete => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AutoScaling::InstanceRefreshWarmPoolProgress

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AutoScaling::InstanceRefreshWarmPoolProgress object:

  $service_obj->Method(Att1 => { InstancesToUpdate => $value, ..., PercentageComplete => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AutoScaling::InstanceRefreshWarmPoolProgress object:

  $result = $service_obj->Method(...);
  $result->Att1->InstancesToUpdate

=head1 DESCRIPTION

Reports the progress of an instance refresh on instances that are in
the warm pool.

=head1 ATTRIBUTES


=head2 InstancesToUpdate => Int

The number of instances remaining to update.


=head2 PercentageComplete => Int

The percentage of instances in the warm pool that have been replaced.
For each instance replacement, Amazon EC2 Auto Scaling tracks the
instance's health status and warm-up time. When the instance's health
status changes to healthy and the specified warm-up time passes, the
instance is considered updated and is added to the percentage complete.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

