package JIRA::REST::Class::Issue::Worklog;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.03';

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents the worklog of a JIRA issue as an object.

__PACKAGE__->mk_contextual_ro_accessors(qw/ items /);

sub init {
    my $self = shift;
    $self->SUPER::init(@_);

    $self->{data} = $self->issue->get('/worklog');
    my $items = $self->{items} = [];

    foreach my $item ( @{ $self->data->{worklogs} } ) {
        push @$items,  $self->issue->make_object('workitem', { data => $item });
    }
}

#pod =method B<items>
#pod
#pod Returns a list of individual work items, as C<JIRA::REST::Class::Issue::Worklog::Item> objects.
#pod
#pod =for stopwords worklog
#pod
#pod =cut

1;

__END__

=pod

=encoding UTF-8

=for :stopwords Packy Anderson Alexey Melezhik worklog

=head1 NAME

JIRA::REST::Class::Issue::Worklog - A helper class for C<JIRA::REST::Class> that represents the worklog of a JIRA issue as an object.

=head1 VERSION

version 0.03

=head1 METHODS

=head2 B<items>

Returns a list of individual work items, as C<JIRA::REST::Class::Issue::Worklog::Item> objects.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
