#ifdef __cplusplus
extern "C" {
#endif

/*
**  It seems that perfection is attained
**  not when there is nothing more to add,
**  but when there is nothing more to remove.
**                -- Antoine de Saint Exupery
*/

#include "uulib/CONF.h"
#include "XSUB.h"
#include "uulib/chacha.h"
#include "uulib/clear.h"
#include "uulib/clock.h"
#include "uulib/compare.h"
#include "uulib/gen.h"
#include "uulib/isnull.h"
#include "uulib/pack.h"
#include "uulib/parse.h"
#include "uulib/unpack.h"
#include "uulib/unparse.h"
#include "uulib/util.h"

#ifdef __cplusplus
}
#endif

/* 2 hex digits per byte + 4 separators + 1 trailing null */
#define UUID_BUF_SZ 37

#ifndef MUTEX_LOCK
#  define MUTEX_LOCK(m)           NOOP
#endif

#ifndef MUTEX_UNLOCK
#  define MUTEX_UNLOCK(m)         NOOP
#endif

#ifndef MUTEX_INIT
#  define MUTEX_INIT(m)           NOOP
#endif

#ifndef MUTEX_DESTROY
#  define MUTEX_DESTROY(m)        NOOP
#endif

#ifdef USE_ITHREADS
STATIC perl_mutex UUID_LOCK;
#else
#define UUID_LOCK dNOOP;
#endif

#ifndef SVf_THINKFIRST
#define SVf_THINKFIRST  (SVf_READONLY|SVf_PROTECT|SVf_ROK|SVf_FAKE \
                        |SVs_RMG|SVf_IsCOW)
#endif

#ifndef SvTHINKFIRST
#define SvTHINKFIRST(sv)  (SvFLAGS(sv) & SVf_THINKFIRST
#endif

#ifndef SV_CHECK_THINKFIRST_COW_DROP
#define SV_CHECK_THINKFIRST_COW_DROP(sv) \
    if (SvTHINKFIRST(sv)) \
        sv_force_normal_flags(sv, SV_COW_DROP_PV)
#endif

#ifndef CVf_AUTOLOAD
#define CvAUTOLOAD_off(cv) NOOP
#endif

static const char *statepath    = NULL;
static STRLEN     statepath_len = 0;


MODULE = UUID		PACKAGE = UUID


BOOT:
    MUTEX_INIT(&UUID_LOCK);
    MUTEX_LOCK(&UUID_LOCK);
    cc_srand();
    uu_v1gen_init();
    MUTEX_UNLOCK(&UUID_LOCK);


void
_hide_always();
    PROTOTYPE:
    PPCODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v1set_uniq();
        MUTEX_UNLOCK(&UUID_LOCK);

void
_hide_mac()
    PROTOTYPE:
    PPCODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v1set_rand();
        MUTEX_UNLOCK(&UUID_LOCK);

int
_persist(str)
    SV * str
    PROTOTYPE: $
    INIT:
        char    *ptr;
        STRLEN  len;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        if (SvTRUE(str)) {
            ptr = SvPVbyte(str, len);
            if (statepath)
                Safefree(statepath);
            Newxz(statepath, len+1, char);
            Copy(ptr, statepath, len, char);
            uu_init_statepath(statepath);
            statepath_len = len;
        }
        else {
            statepath     = NULL;
            statepath_len = 0;
            uu_init_statepath(statepath);
        }
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = 1;
    OUTPUT:
        RETVAL

SV *
_statepath()
    PROTOTYPE:
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        RETVAL = newSVpvn(statepath, statepath_len);
        MUTEX_UNLOCK(&UUID_LOCK);
    OUTPUT:
        RETVAL

void
clear(io)
    SV * io
    PROTOTYPE: $
    INIT:
        struct uu   su;
        char        *dptr;
    CODE:
        uu_clear(&su);
        SV_CHECK_THINKFIRST_COW_DROP(io);
        if (isGV_with_GP(io))
            croak("%s", PL_no_modify);
        SvUPGRADE(io, SVt_PV);
        dptr = SvGROW(io, sizeof(uu_t)+1);
        uu_pack(&su, (U8*)dptr);
        dptr[sizeof(uu_t)] = '\0';
        SvCUR_set(io, sizeof(uu_t));
        (void)SvPOK_only(io);
        if (SvTYPE(io) == SVt_PVCV)
            CvAUTOLOAD_off(io);

IV
compare(in1, in2)
    SV * in1
    SV * in2
    PROTOTYPE: $$
    INIT:
        STRLEN  len1, len2;
    CODE:
        if (!SvOK(in1))
            RETVAL = SvOK(in2) ? -1 : 0;
        else if (!SvOK(in2))
            RETVAL = 1;
        else if (!SvPOK(in1))
            RETVAL = SvPOK(in2) ? -1 : 0;
        else if (!SvPOK(in2))
            RETVAL = 1;
        else if (SvCUR(in1) == 16 && SvCUR(in2) == 16)
            RETVAL = uu_cmp_binary(
                (U8*)SvPV_force(in1, len1),
                (U8*)SvPV_force(in2, len2)
            );
        else
            RETVAL = sv_cmp(in1, in2);
    OUTPUT:
        RETVAL

void
copy(out, in)
    SV * out
    SV * in
    PROTOTYPE: $$
    INIT:
        struct uu   su;
        STRLEN      len;
        char        *dptr;
    CODE:
        if( SvCUR(in) != sizeof(uu_t) )
            uu_clear(&su);
        else
            uu_unpack((U8*)SvPV_force(in, len), &su);
        SV_CHECK_THINKFIRST_COW_DROP(out);
        if (isGV_with_GP(out))
            croak("%s", PL_no_modify);
        SvUPGRADE(out, SVt_PV);
        dptr = SvGROW(out, sizeof(uu_t)+1);
        uu_pack(&su, (U8*)dptr);
        dptr[sizeof(uu_t)] = '\0';
        SvCUR_set(out, sizeof(uu_t));
        (void)SvPOK_only(out);
        if (SvTYPE(out) == SVt_PVCV)
            CvAUTOLOAD_off(out);

void
generate(out)
    SV * out
    PROTOTYPE: $
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        SV_CHECK_THINKFIRST_COW_DROP(out);
        if (isGV_with_GP(out))
            croak("%s", PL_no_modify);
        SvUPGRADE(out, SVt_PV);
        dptr = SvGROW(out, sizeof(uu_t)+1);
        MUTEX_LOCK(&UUID_LOCK);
        uu_vXgen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        uu_pack(&su, (U8*)dptr);
        dptr[sizeof(uu_t)] = '\0';
        SvCUR_set(out, sizeof(uu_t));
        (void)SvPOK_only(out);
        if (SvTYPE(out) == SVt_PVCV)
            CvAUTOLOAD_off(out);

void
generate_random(out)
    SV * out
    PROTOTYPE: $
    INIT:
        char        *dptr;
        struct uu4  su;
    CODE:
        /* alias of generate_v4(), but see note there. */
        SV_CHECK_THINKFIRST_COW_DROP(out);
        if (isGV_with_GP(out))
            croak("%s", PL_no_modify);
        SvUPGRADE(out, SVt_PV);
        dptr = SvGROW(out, sizeof(uu_t)+1);
        MUTEX_LOCK(&UUID_LOCK);
        uu_v4gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        uu_pack4(&su, (U8*)dptr);
        dptr[sizeof(uu_t)] = '\0';
        SvCUR_set(out, sizeof(uu_t));
        (void)SvPOK_only(out);
        if (SvTYPE(out) == SVt_PVCV)
            CvAUTOLOAD_off(out);

void
generate_time(out)
    SV * out
    PROTOTYPE: $
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        /* alias of generate_v1(), but see note there. */
        SV_CHECK_THINKFIRST_COW_DROP(out);
        if (isGV_with_GP(out))
            croak("%s", PL_no_modify);
        SvUPGRADE(out, SVt_PV);
        dptr = SvGROW(out, 16 + 1);
        MUTEX_LOCK(&UUID_LOCK);
        uu_v1gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        uu_pack(&su, (U8*)dptr);
        dptr[16] = '\0';
        SvCUR_set(out, 16);
        (void)SvPOK_only(out);
        if (SvTYPE(out) == SVt_PVCV)
            CvAUTOLOAD_off(out);

void
generate_v0(out)
    SV * out
    PROTOTYPE: $
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        SV_CHECK_THINKFIRST_COW_DROP(out);
        if (isGV_with_GP(out))
            croak("%s", PL_no_modify);
        SvUPGRADE(out, SVt_PV);
        dptr = SvGROW(out, 16 + 1);
        MUTEX_LOCK(&UUID_LOCK);
        uu_v0gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        uu_pack(&su, (U8*)dptr);
        dptr[16] = '\0';
        SvCUR_set(out, 16);
        (void)SvPOK_only(out);
        if (SvTYPE(out) == SVt_PVCV)
            CvAUTOLOAD_off(out);

void
generate_v1(out)
    SV * out
    PROTOTYPE: $
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        /* this is an alias of generate_time(), but dont use the
        alias keyword. it generates warnings on older perls. */
        SV_CHECK_THINKFIRST_COW_DROP(out);
        if (isGV_with_GP(out))
            croak("%s", PL_no_modify);
        SvUPGRADE(out, SVt_PV);
        dptr = SvGROW(out, 16 + 1);
        MUTEX_LOCK(&UUID_LOCK);
        uu_v1gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        uu_pack(&su, (U8*)dptr);
        dptr[16] = '\0';
        SvCUR_set(out, 16);
        (void)SvPOK_only(out);
        if (SvTYPE(out) == SVt_PVCV)
            CvAUTOLOAD_off(out);

void
generate_v4(out)
    SV * out
    PROTOTYPE: $
    INIT:
        char        *dptr;
        struct uu4  su;
    CODE:
        /* this is an alias of generate_random(), but dont use the
        alias keyword. it generates warnings on older perls. */
        SV_CHECK_THINKFIRST_COW_DROP(out);
        if (isGV_with_GP(out))
            croak("%s", PL_no_modify);
        SvUPGRADE(out, SVt_PV);
        dptr = SvGROW(out, 16 + 1);
        MUTEX_LOCK(&UUID_LOCK);
        uu_v4gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        uu_pack4(&su, (U8*)dptr);
        dptr[16] = '\0';
        SvCUR_set(out, 16);
        (void)SvPOK_only(out);
        if (SvTYPE(out) == SVt_PVCV)
            CvAUTOLOAD_off(out);

void
generate_v6(out)
    SV * out
    PROTOTYPE: $
    INIT:
        char        *dptr;
        struct uu6  su;
    CODE:
        SV_CHECK_THINKFIRST_COW_DROP(out);
        if (isGV_with_GP(out))
            croak("%s", PL_no_modify);
        SvUPGRADE(out, SVt_PV);
        dptr = SvGROW(out, 16 + 1);
        MUTEX_LOCK(&UUID_LOCK);
        uu_v6gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        uu_pack6(&su, (U8*)dptr);
        dptr[16] = '\0';
        SvCUR_set(out, 16);
        (void)SvPOK_only(out);
        if (SvTYPE(out) == SVt_PVCV)
            CvAUTOLOAD_off(out);

void
generate_v7(out)
    SV * out
    PROTOTYPE: $
    INIT:
        char        *dptr;
        struct uu7  su;
    CODE:
        SV_CHECK_THINKFIRST_COW_DROP(out);
        if (isGV_with_GP(out))
            croak("%s", PL_no_modify);
        SvUPGRADE(out, SVt_PV);
        dptr = SvGROW(out, 16 + 1);
        MUTEX_LOCK(&UUID_LOCK);
        uu_v7gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        uu_pack7(&su, (U8*)dptr);
        dptr[16] = '\0';
        SvCUR_set(out, 16);
        (void)SvPOK_only(out);
        if (SvTYPE(out) == SVt_PVCV)
            CvAUTOLOAD_off(out);

IV
is_null(in)
    SV * in
    PROTOTYPE: $
    INIT:
        STRLEN  len;
    CODE:
        if( SvCUR(in) != sizeof(uu_t) )
            RETVAL = 0;
        else
            RETVAL = uu_isnull_binary( (U8*)SvPV(in, len) );
    OUTPUT:
        RETVAL

IV
parse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        if (uu_parse(sv_grow(in, UUID_BUF_SZ+1), &su))
            RETVAL = -1;
        else {
            SV_CHECK_THINKFIRST_COW_DROP(out);
            if (isGV_with_GP(out))
                croak("%s", PL_no_modify);
            SvUPGRADE(out, SVt_PV);
            dptr = SvGROW(out, 16 + 1);
            uu_pack(&su, (U8*)dptr);
            dptr[16] = '\0';
            SvCUR_set(out, 16);
            (void)SvPOK_only(out);
            if (SvTYPE(out) == SVt_PVCV)
                CvAUTOLOAD_off(out);
            RETVAL = 0;
        }
    OUTPUT:
    RETVAL

time_t
time(in)
    SV * in
    PROTOTYPE: $
    INIT:
        struct uu   su;
        char        *str;
        STRLEN      len;
        struct timeval tv = {0, 0};
    CODE:
        if (SvPOK(in)) {
            str = SvPV(in, len);
            if (len == sizeof(uu_t)) {
                uu_unpack((U8*)str, &su);
                uu_time(&su, &tv);
            }
        }
        RETVAL = PTR2UV(&tv);
    OUTPUT:
        RETVAL

IV
type(in)
    SV * in
    PROTOTYPE: $
    INIT:
        struct uu   su;
        char        *str;
        STRLEN      len;
    CODE:
        /* alias of version(), but see note there. */
        RETVAL = -1;
        if (SvPOK(in)) {
            str = SvPV(in, len);
            if (len == sizeof(uu_t)) {
                uu_unpack((unsigned char*)str, &su);
                RETVAL = uu_type(&su);
            }
        }
    OUTPUT:
        RETVAL

void
unparse(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
        struct uu   us;
        char        *str, *dptr;
    CODE:
        if (SvPOK(in)) {
            str = SvGROW(in, sizeof(uu_t));
            uu_unpack((unsigned char*)str, &us);

            SV_CHECK_THINKFIRST_COW_DROP(out);
            if (isGV_with_GP(out))
                croak("%s", PL_no_modify);
            SvUPGRADE(out, SVt_PV);
            SvPOK_only(out);
            dptr = SvGROW(out, UUID_BUF_SZ);

            uu_unparse(&us, dptr);

            dptr[UUID_BUF_SZ] = '\0';
            SvCUR_set(out, UUID_BUF_SZ-1);
            (void)SvPOK_only(out);
            if (SvTYPE(out) == SVt_PVCV)
                CvAUTOLOAD_off(out);
        }

void
unparse_lower(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
        struct uu   us;
        char        *str, *dptr;
    CODE:
        if (SvPOK(in)) {
            str = SvGROW(in, sizeof(uu_t));
            uu_unpack((unsigned char*)str, &us);

            SV_CHECK_THINKFIRST_COW_DROP(out);
            if (isGV_with_GP(out))
                croak("%s", PL_no_modify);
            SvUPGRADE(out, SVt_PV);
            SvPOK_only(out);
            dptr = SvGROW(out, UUID_BUF_SZ);

            uu_unparse_lower(&us, dptr);

            dptr[UUID_BUF_SZ] = '\0';
            SvCUR_set(out, UUID_BUF_SZ-1);
            (void)SvPOK_only(out);
            if (SvTYPE(out) == SVt_PVCV)
                CvAUTOLOAD_off(out);
        }

void
unparse_upper(in, out)
    SV * in
    SV * out
    PROTOTYPE: $$
    INIT:
        struct uu   us;
        char        *str, *dptr;
    CODE:
        if (SvPOK(in)) {
            str = SvGROW(in, sizeof(uu_t));
            uu_unpack((unsigned char*)str, &us);

            SV_CHECK_THINKFIRST_COW_DROP(out);
            if (isGV_with_GP(out))
                croak("%s", PL_no_modify);
            SvUPGRADE(out, SVt_PV);
            SvPOK_only(out);
            dptr = SvGROW(out, UUID_BUF_SZ);

            uu_unparse_upper(&us, dptr);

            dptr[UUID_BUF_SZ] = '\0';
            SvCUR_set(out, UUID_BUF_SZ-1);
            (void)SvPOK_only(out);
            if (SvTYPE(out) == SVt_PVCV)
                CvAUTOLOAD_off(out);
        }

SV *
uuid()
    PROTOTYPE:
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_vXgen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSV(UUID_BUF_SZ);
        dptr = SvPVX(RETVAL);
        uu_unparse(&su, dptr);
        dptr[UUID_BUF_SZ] = '\0';
        SvCUR_set(RETVAL, UUID_BUF_SZ-1);
        SvPOK_only(RETVAL);
    OUTPUT:
        RETVAL

SV *
uuid0()
    PROTOTYPE:
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v0gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSV(UUID_BUF_SZ);
        dptr = SvPVX(RETVAL);
        uu_unparse(&su, dptr);
        dptr[UUID_BUF_SZ] = '\0';
        SvCUR_set(RETVAL, UUID_BUF_SZ-1);
        SvPOK_only(RETVAL);
    OUTPUT:
        RETVAL

SV *
uuid1()
    PROTOTYPE:
    INIT:
        char        *dptr;
        struct uu   su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v1gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSV(UUID_BUF_SZ);
        dptr = SvPVX(RETVAL);
        uu_unparse(&su, dptr);
        dptr[UUID_BUF_SZ] = '\0';
        SvCUR_set(RETVAL, UUID_BUF_SZ-1);
        SvPOK_only(RETVAL);
    OUTPUT:
        RETVAL

SV *
uuid4()
    PROTOTYPE:
    INIT:
        char        *dptr;
        struct uu4  su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v4gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSV(UUID_BUF_SZ);
        dptr = SvPVX(RETVAL);
        uu_unparse4(&su, (char*)dptr);
        dptr[UUID_BUF_SZ] = '\0';
        SvCUR_set(RETVAL, UUID_BUF_SZ-1);
        SvPOK_only(RETVAL);
    OUTPUT:
        RETVAL

SV *
uuid6()
    PROTOTYPE:
    INIT:
        char        *dptr;
        struct uu6  su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v6gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSV(UUID_BUF_SZ);
        dptr = SvPVX(RETVAL);
        uu_unparse6(&su, (char*)dptr);
        dptr[UUID_BUF_SZ] = '\0';
        SvCUR_set(RETVAL, UUID_BUF_SZ-1);
        SvPOK_only(RETVAL);
    OUTPUT:
        RETVAL

SV *
uuid7()
    PROTOTYPE:
    INIT:
        char        *dptr;
        struct uu7  su;
    CODE:
        MUTEX_LOCK(&UUID_LOCK);
        uu_v7gen(&su);
        MUTEX_UNLOCK(&UUID_LOCK);
        RETVAL = newSV(UUID_BUF_SZ);
        dptr = SvPVX(RETVAL);
        uu_unparse7(&su, (char*)dptr);
        dptr[UUID_BUF_SZ] = '\0';
        SvCUR_set(RETVAL, UUID_BUF_SZ-1);
        SvPOK_only(RETVAL);
    OUTPUT:
        RETVAL

UV
variant(in)
    SV * in
    PROTOTYPE: $
    INIT:
        struct uu   su;
        char        *str;
        STRLEN      len;
    CODE:
        RETVAL = 0;
        if (SvPOK(in)) {
            str = SvPV(in, len);
            if (len == sizeof(uu_t)) {
                uu_unpack((unsigned char*)str, &su);
                RETVAL = uu_variant(&su);
            }
        }
    OUTPUT:
        RETVAL

IV
version(in)
    SV * in
    PROTOTYPE: $
    INIT:
        struct uu   su;
        char        *str;
        STRLEN      len;
    CODE:
        /* this is an alias of type(), but dont use the alias keyword.
        it generates warnings on older perls. */
        RETVAL = -1;
        if (SvPOK(in)) {
            str = SvPV(in, len);
            if (len == sizeof(uu_t)) {
                uu_unpack((unsigned char*)str, &su);
                RETVAL = uu_type(&su);
            }
        }
    OUTPUT:
        RETVAL

