#!/usr/bin/perl

package eBay::API::XML::DataType::ExpansionArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExpansionArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ExpansionArrayType

=head1 DESCRIPTION

Container for items returned with an expanded search.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ExpansionArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::SearchResultItemType;


my @gaProperties = ( [ 'ExpansionItem', 'ns:SearchResultItemType', '1'
	     ,'eBay::API::XML::DataType::SearchResultItemType', '1' ]
	, [ 'TotalAvailable', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setExpansionItem()

Item that is the result of an expanded search. If, in a GetSearchResults 
request, you specify true for ExpandSearch, the search is expanded when a 
small result set is returned. For example, on the US site (site ID 0), if a 
search would normally result in fewer than 10 items, then the search results 
are expanded. Specifically, the search returns items (if there are matches) 
in one or more of the following containers: InternationalExpansionArray (for 
items available from international sellers), FilterRemovedExpansionArray 
(items that would be returned if filters such as PriceRangeFilter are 
removed), StoreExpansionArray (for items listed in the Store Inventory Format),
and AllCategoriesExpansionArray (for items available if category 
filters are removed). The maximum number of items returned in each container 
is 6 to 10.

#    Argument: reference to an array  
                      of 'ns:SearchResultItemType'

=cut

sub setExpansionItem {
  my $self = shift;
  $self->{'ExpansionItem'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getExpansionItem()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

#    Returns: reference to an array  
                      of 'ns:SearchResultItemType'

=cut

sub getExpansionItem {
  my $self = shift;
  return $self->_getDataTypeArray('ExpansionItem');
}


=head2 setTotalAvailable()

The number of matching items available under the expansion.

#    Argument: 'xs:int'

=cut

sub setTotalAvailable {
  my $self = shift;
  $self->{'TotalAvailable'} = shift
}

=head2 getTotalAvailable()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getTotalAvailable {
  my $self = shift;
  return $self->{'TotalAvailable'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
