--TEST--
bcmod() function
--EXTENSIONS--
bcmath
--INI--
bcmath.scale=0
--FILE--
<?php
require(__DIR__ . "/run_bcmath_tests_function.inc");

$dividends = ["15", "-15", "1", "-9", "14.14", "-16.60", "0.15", "-0.01"];
$divisors = array_merge($dividends, [
    "15151324141414.412312232141241",
    "-132132245132134.1515123765412",
    "141241241241241248267654747412",
    "-149143276547656984948124912",
    "0.1322135476547459213732911312",
    "-0.123912932193769965476541321",
]);

run_bcmath_tests($dividends, $divisors, "mod", bcmod(...));

?>
--EXPECT--
Number "15" (scale 0)
15 mod 15                             = 0
15 mod -15                            = 0
15 mod 1                              = 0
15 mod -9                             = 6
15 mod 14.14                          = 0
15 mod -16.60                         = 15
15 mod 0.15                           = 0
15 mod -0.01                          = 0
15 mod 15151324141414.412312232141241 = 15
15 mod -132132245132134.1515123765412 = 15
15 mod 141241241241241248267654747412 = 15
15 mod -149143276547656984948124912   = 15
15 mod 0.1322135476547459213732911312 = 0
15 mod -0.123912932193769965476541321 = 0

Number "-15" (scale 0)
-15 mod 15                             = 0
-15 mod -15                            = 0
-15 mod 1                              = 0
-15 mod -9                             = -6
-15 mod 14.14                          = 0
-15 mod -16.60                         = -15
-15 mod 0.15                           = 0
-15 mod -0.01                          = 0
-15 mod 15151324141414.412312232141241 = -15
-15 mod -132132245132134.1515123765412 = -15
-15 mod 141241241241241248267654747412 = -15
-15 mod -149143276547656984948124912   = -15
-15 mod 0.1322135476547459213732911312 = 0
-15 mod -0.123912932193769965476541321 = 0

Number "1" (scale 0)
1 mod 15                             = 1
1 mod -15                            = 1
1 mod 1                              = 0
1 mod -9                             = 1
1 mod 14.14                          = 1
1 mod -16.60                         = 1
1 mod 0.15                           = 0
1 mod -0.01                          = 0
1 mod 15151324141414.412312232141241 = 1
1 mod -132132245132134.1515123765412 = 1
1 mod 141241241241241248267654747412 = 1
1 mod -149143276547656984948124912   = 1
1 mod 0.1322135476547459213732911312 = 0
1 mod -0.123912932193769965476541321 = 0

Number "-9" (scale 0)
-9 mod 15                             = -9
-9 mod -15                            = -9
-9 mod 1                              = 0
-9 mod -9                             = 0
-9 mod 14.14                          = -9
-9 mod -16.60                         = -9
-9 mod 0.15                           = 0
-9 mod -0.01                          = 0
-9 mod 15151324141414.412312232141241 = -9
-9 mod -132132245132134.1515123765412 = -9
-9 mod 141241241241241248267654747412 = -9
-9 mod -149143276547656984948124912   = -9
-9 mod 0.1322135476547459213732911312 = 0
-9 mod -0.123912932193769965476541321 = 0

Number "14.14" (scale 0)
14.14 mod 15                             = 14
14.14 mod -15                            = 14
14.14 mod 1                              = 0
14.14 mod -9                             = 5
14.14 mod 14.14                          = 0
14.14 mod -16.60                         = 14
14.14 mod 0.15                           = 0
14.14 mod -0.01                          = 0
14.14 mod 15151324141414.412312232141241 = 14
14.14 mod -132132245132134.1515123765412 = 14
14.14 mod 141241241241241248267654747412 = 14
14.14 mod -149143276547656984948124912   = 14
14.14 mod 0.1322135476547459213732911312 = 0
14.14 mod -0.123912932193769965476541321 = 0

Number "-16.60" (scale 0)
-16.60 mod 15                             = -1
-16.60 mod -15                            = -1
-16.60 mod 1                              = 0
-16.60 mod -9                             = -7
-16.60 mod 14.14                          = -2
-16.60 mod -16.60                         = 0
-16.60 mod 0.15                           = 0
-16.60 mod -0.01                          = 0
-16.60 mod 15151324141414.412312232141241 = -16
-16.60 mod -132132245132134.1515123765412 = -16
-16.60 mod 141241241241241248267654747412 = -16
-16.60 mod -149143276547656984948124912   = -16
-16.60 mod 0.1322135476547459213732911312 = 0
-16.60 mod -0.123912932193769965476541321 = 0

Number "0.15" (scale 0)
0.15 mod 15                             = 0
0.15 mod -15                            = 0
0.15 mod 1                              = 0
0.15 mod -9                             = 0
0.15 mod 14.14                          = 0
0.15 mod -16.60                         = 0
0.15 mod 0.15                           = 0
0.15 mod -0.01                          = 0
0.15 mod 15151324141414.412312232141241 = 0
0.15 mod -132132245132134.1515123765412 = 0
0.15 mod 141241241241241248267654747412 = 0
0.15 mod -149143276547656984948124912   = 0
0.15 mod 0.1322135476547459213732911312 = 0
0.15 mod -0.123912932193769965476541321 = 0

Number "-0.01" (scale 0)
-0.01 mod 15                             = 0
-0.01 mod -15                            = 0
-0.01 mod 1                              = 0
-0.01 mod -9                             = 0
-0.01 mod 14.14                          = 0
-0.01 mod -16.60                         = 0
-0.01 mod 0.15                           = 0
-0.01 mod -0.01                          = 0
-0.01 mod 15151324141414.412312232141241 = 0
-0.01 mod -132132245132134.1515123765412 = 0
-0.01 mod 141241241241241248267654747412 = 0
-0.01 mod -149143276547656984948124912   = 0
-0.01 mod 0.1322135476547459213732911312 = 0
-0.01 mod -0.123912932193769965476541321 = 0

Number "15" (scale 10)
15 mod 15                             = 0.0000000000
15 mod -15                            = 0.0000000000
15 mod 1                              = 0.0000000000
15 mod -9                             = 6.0000000000
15 mod 14.14                          = 0.8600000000
15 mod -16.60                         = 15.0000000000
15 mod 0.15                           = 0.0000000000
15 mod -0.01                          = 0.0000000000
15 mod 15151324141414.412312232141241 = 15.0000000000
15 mod -132132245132134.1515123765412 = 15.0000000000
15 mod 141241241241241248267654747412 = 15.0000000000
15 mod -149143276547656984948124912   = 15.0000000000
15 mod 0.1322135476547459213732911312 = 0.0598691150
15 mod -0.123912932193769965476541321 = 0.0065352045

Number "-15" (scale 10)
-15 mod 15                             = 0.0000000000
-15 mod -15                            = 0.0000000000
-15 mod 1                              = 0.0000000000
-15 mod -9                             = -6.0000000000
-15 mod 14.14                          = -0.8600000000
-15 mod -16.60                         = -15.0000000000
-15 mod 0.15                           = 0.0000000000
-15 mod -0.01                          = 0.0000000000
-15 mod 15151324141414.412312232141241 = -15.0000000000
-15 mod -132132245132134.1515123765412 = -15.0000000000
-15 mod 141241241241241248267654747412 = -15.0000000000
-15 mod -149143276547656984948124912   = -15.0000000000
-15 mod 0.1322135476547459213732911312 = -0.0598691150
-15 mod -0.123912932193769965476541321 = -0.0065352045

Number "1" (scale 10)
1 mod 15                             = 1.0000000000
1 mod -15                            = 1.0000000000
1 mod 1                              = 0.0000000000
1 mod -9                             = 1.0000000000
1 mod 14.14                          = 1.0000000000
1 mod -16.60                         = 1.0000000000
1 mod 0.15                           = 0.1000000000
1 mod -0.01                          = 0.0000000000
1 mod 15151324141414.412312232141241 = 1.0000000000
1 mod -132132245132134.1515123765412 = 1.0000000000
1 mod 141241241241241248267654747412 = 1.0000000000
1 mod -149143276547656984948124912   = 1.0000000000
1 mod 0.1322135476547459213732911312 = 0.0745051664
1 mod -0.123912932193769965476541321 = 0.0086965424

Number "-9" (scale 10)
-9 mod 15                             = -9.0000000000
-9 mod -15                            = -9.0000000000
-9 mod 1                              = 0.0000000000
-9 mod -9                             = 0.0000000000
-9 mod 14.14                          = -9.0000000000
-9 mod -16.60                         = -9.0000000000
-9 mod 0.15                           = 0.0000000000
-9 mod -0.01                          = 0.0000000000
-9 mod 15151324141414.412312232141241 = -9.0000000000
-9 mod -132132245132134.1515123765412 = -9.0000000000
-9 mod 141241241241241248267654747412 = -9.0000000000
-9 mod -149143276547656984948124912   = -9.0000000000
-9 mod 0.1322135476547459213732911312 = -0.0094787594
-9 mod -0.123912932193769965476541321 = -0.0782688820

Number "14.14" (scale 10)
14.14 mod 15                             = 14.1400000000
14.14 mod -15                            = 14.1400000000
14.14 mod 1                              = 0.1400000000
14.14 mod -9                             = 5.1400000000
14.14 mod 14.14                          = 0.0000000000
14.14 mod -16.60                         = 14.1400000000
14.14 mod 0.15                           = 0.0400000000
14.14 mod -0.01                          = 0.0000000000
14.14 mod 15151324141414.412312232141241 = 14.1400000000
14.14 mod -132132245132134.1515123765412 = 14.1400000000
14.14 mod 141241241241241248267654747412 = 14.1400000000
14.14 mod -149143276547656984948124912   = 14.1400000000
14.14 mod 0.1322135476547459213732911312 = 0.1253639485
14.14 mod -0.123912932193769965476541321 = 0.0139257299

Number "-16.60" (scale 10)
-16.60 mod 15                             = -1.6000000000
-16.60 mod -15                            = -1.6000000000
-16.60 mod 1                              = -0.6000000000
-16.60 mod -9                             = -7.6000000000
-16.60 mod 14.14                          = -2.4600000000
-16.60 mod -16.60                         = 0.0000000000
-16.60 mod 0.15                           = -0.1000000000
-16.60 mod -0.01                          = 0.0000000000
-16.60 mod 15151324141414.412312232141241 = -16.6000000000
-16.60 mod -132132245132134.1515123765412 = -16.6000000000
-16.60 mod 141241241241241248267654747412 = -16.6000000000
-16.60 mod -149143276547656984948124912   = -16.6000000000
-16.60 mod 0.1322135476547459213732911312 = -0.0733065431
-16.60 mod -0.123912932193769965476541321 = -0.1195800182

Number "0.15" (scale 10)
0.15 mod 15                             = 0.1500000000
0.15 mod -15                            = 0.1500000000
0.15 mod 1                              = 0.1500000000
0.15 mod -9                             = 0.1500000000
0.15 mod 14.14                          = 0.1500000000
0.15 mod -16.60                         = 0.1500000000
0.15 mod 0.15                           = 0.0000000000
0.15 mod -0.01                          = 0.0000000000
0.15 mod 15151324141414.412312232141241 = 0.1500000000
0.15 mod -132132245132134.1515123765412 = 0.1500000000
0.15 mod 141241241241241248267654747412 = 0.1500000000
0.15 mod -149143276547656984948124912   = 0.1500000000
0.15 mod 0.1322135476547459213732911312 = 0.0177864523
0.15 mod -0.123912932193769965476541321 = 0.0260870678

Number "-0.01" (scale 10)
-0.01 mod 15                             = -0.0100000000
-0.01 mod -15                            = -0.0100000000
-0.01 mod 1                              = -0.0100000000
-0.01 mod -9                             = -0.0100000000
-0.01 mod 14.14                          = -0.0100000000
-0.01 mod -16.60                         = -0.0100000000
-0.01 mod 0.15                           = -0.0100000000
-0.01 mod -0.01                          = 0.0000000000
-0.01 mod 15151324141414.412312232141241 = -0.0100000000
-0.01 mod -132132245132134.1515123765412 = -0.0100000000
-0.01 mod 141241241241241248267654747412 = -0.0100000000
-0.01 mod -149143276547656984948124912   = -0.0100000000
-0.01 mod 0.1322135476547459213732911312 = -0.0100000000
-0.01 mod -0.123912932193769965476541321 = -0.0100000000
