/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;

public abstract class CancellationExceptionTransformer {
    private static final CancellationExceptionTransformer NO_OP = new CancellationExceptionTransformer(){

        @Override
        public RuntimeException transform(RuntimeException e) {
            return e;
        }
    };

    static CancellationExceptionTransformer transformerFor(VersionDetails versionDetails) {
        if (versionDetails.honorsContractOnCancel()) {
            return NO_OP;
        }
        return new CancellationExceptionTransformer(){

            @Override
            public RuntimeException transform(RuntimeException e) {
                for (Throwable t = e; t != null; t = t.getCause()) {
                    if (!"org.gradle.api.BuildCancelledException".equals(t.getClass().getName()) && !"org.gradle.tooling.BuildCancelledException".equals(t.getClass().getName())) continue;
                    return new InternalBuildCancelledException(e.getCause());
                }
                return e;
            }
        };
    }

    abstract RuntimeException transform(RuntimeException var1);
}

