/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.search;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.protobufs.HitsMetadata;
import org.opensearch.protobufs.ProcessorExecutionDetail;
import org.opensearch.protobufs.SearchResponse;
import org.opensearch.search.pipeline.ProcessorExecutionDetail;
import org.opensearch.transport.grpc.proto.response.common.ObjectMapProtoUtils;
import org.opensearch.transport.grpc.proto.response.search.SearchHitsProtoUtils;

public class SearchResponseSectionsProtoUtils {
    private SearchResponseSectionsProtoUtils() {
    }

    protected static void toProto(SearchResponse.Builder builder, SearchResponse response) throws IOException {
        HitsMetadata.Builder hitsBuilder = HitsMetadata.newBuilder();
        SearchHitsProtoUtils.toProto(response.getHits(), hitsBuilder);
        builder.setHits(hitsBuilder.build());
        List processorResults = response.getInternalResponse().getProcessorResult();
        if (processorResults != null && !processorResults.isEmpty()) {
            for (ProcessorExecutionDetail detail : processorResults) {
                ProcessorExecutionDetail.Builder detailBuilder = org.opensearch.protobufs.ProcessorExecutionDetail.newBuilder();
                if (detail.getProcessorName() != null) {
                    detailBuilder.setProcessorName(detail.getProcessorName());
                }
                detailBuilder.setDurationMillis(detail.getDurationMillis());
                if (detail.getInputData() != null) {
                    detailBuilder.setInputData(ObjectMapProtoUtils.toProto(detail.getInputData()).getObjectMap());
                }
                if (detail.getOutputData() != null) {
                    detailBuilder.setOutputData(ObjectMapProtoUtils.toProto(detail.getOutputData()).getObjectMap());
                }
                if (detail.getStatus() != null) {
                    detailBuilder.setStatus(detail.getStatus().name().toLowerCase(Locale.ROOT));
                }
                if (detail.getErrorMessage() != null) {
                    detailBuilder.setError(detail.getErrorMessage());
                }
                if (detail.getTag() != null) {
                    detailBuilder.setTag(detail.getTag());
                }
                builder.addProcessorResults(detailBuilder.build());
            }
        }
        SearchResponseSectionsProtoUtils.checkUnsupportedFeatures(response);
    }

    private static void checkUnsupportedFeatures(SearchResponse response) {
        if (response.getAggregations() != null) {
            throw new UnsupportedOperationException("aggregation responses are not supported yet");
        }
        if (response.getSuggest() != null) {
            throw new UnsupportedOperationException("suggest responses are not supported yet");
        }
        if (response.getProfileResults() != null && !response.getProfileResults().isEmpty()) {
            throw new UnsupportedOperationException("profile results are not supported yet");
        }
        if (response.getInternalResponse().getSearchExtBuilders() != null && !response.getInternalResponse().getSearchExtBuilders().isEmpty()) {
            throw new UnsupportedOperationException("ext builder responses are not supported yet");
        }
    }
}

