/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.keystore.KeyStore;
import software.amazon.cryptography.materialproviders.BranchKeyIdSupplier;
import software.amazon.cryptography.materialproviders.IBranchKeyIdSupplier;
import software.amazon.cryptography.materialproviders.model.CacheType;

public class CreateAwsKmsHierarchicalKeyringInput {
    private final String branchKeyId;
    private final IBranchKeyIdSupplier branchKeyIdSupplier;
    private final KeyStore keyStore;
    private final long ttlSeconds;
    private final CacheType cache;
    private final String partitionId;

    protected CreateAwsKmsHierarchicalKeyringInput(BuilderImpl builder) {
        this.branchKeyId = builder.branchKeyId();
        this.branchKeyIdSupplier = builder.branchKeyIdSupplier();
        this.keyStore = builder.keyStore();
        this.ttlSeconds = builder.ttlSeconds();
        this.cache = builder.cache();
        this.partitionId = builder.partitionId();
    }

    public String branchKeyId() {
        return this.branchKeyId;
    }

    public IBranchKeyIdSupplier branchKeyIdSupplier() {
        return this.branchKeyIdSupplier;
    }

    public KeyStore keyStore() {
        return this.keyStore;
    }

    public long ttlSeconds() {
        return this.ttlSeconds;
    }

    public CacheType cache() {
        return this.cache;
    }

    public String partitionId() {
        return this.partitionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String branchKeyId;
        protected IBranchKeyIdSupplier branchKeyIdSupplier;
        protected KeyStore keyStore;
        protected long ttlSeconds;
        private boolean _ttlSecondsSet = false;
        protected CacheType cache;
        protected String partitionId;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateAwsKmsHierarchicalKeyringInput model) {
            this.branchKeyId = model.branchKeyId();
            this.branchKeyIdSupplier = model.branchKeyIdSupplier();
            this.keyStore = model.keyStore();
            this.ttlSeconds = model.ttlSeconds();
            this._ttlSecondsSet = true;
            this.cache = model.cache();
            this.partitionId = model.partitionId();
        }

        @Override
        public Builder branchKeyId(String branchKeyId) {
            this.branchKeyId = branchKeyId;
            return this;
        }

        @Override
        public String branchKeyId() {
            return this.branchKeyId;
        }

        @Override
        public Builder branchKeyIdSupplier(IBranchKeyIdSupplier branchKeyIdSupplier) {
            this.branchKeyIdSupplier = BranchKeyIdSupplier.wrap(branchKeyIdSupplier);
            return this;
        }

        @Override
        public IBranchKeyIdSupplier branchKeyIdSupplier() {
            return this.branchKeyIdSupplier;
        }

        @Override
        public Builder keyStore(KeyStore keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        @Override
        public KeyStore keyStore() {
            return this.keyStore;
        }

        @Override
        public Builder ttlSeconds(long ttlSeconds) {
            this.ttlSeconds = ttlSeconds;
            this._ttlSecondsSet = true;
            return this;
        }

        @Override
        public long ttlSeconds() {
            return this.ttlSeconds;
        }

        @Override
        public Builder cache(CacheType cache) {
            this.cache = cache;
            return this;
        }

        @Override
        public CacheType cache() {
            return this.cache;
        }

        @Override
        public Builder partitionId(String partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public String partitionId() {
            return this.partitionId;
        }

        @Override
        public CreateAwsKmsHierarchicalKeyringInput build() {
            if (Objects.isNull(this.keyStore())) {
                throw new IllegalArgumentException("Missing value for required field `keyStore`");
            }
            if (!this._ttlSecondsSet) {
                throw new IllegalArgumentException("Missing value for required field `ttlSeconds`");
            }
            if (this._ttlSecondsSet && this.ttlSeconds() < 0L) {
                throw new IllegalArgumentException("`ttlSeconds` must be greater than or equal to 0");
            }
            return new CreateAwsKmsHierarchicalKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder branchKeyId(String var1);

        public String branchKeyId();

        public Builder branchKeyIdSupplier(IBranchKeyIdSupplier var1);

        public IBranchKeyIdSupplier branchKeyIdSupplier();

        public Builder keyStore(KeyStore var1);

        public KeyStore keyStore();

        public Builder ttlSeconds(long var1);

        public long ttlSeconds();

        public Builder cache(CacheType var1);

        public CacheType cache();

        public Builder partitionId(String var1);

        public String partitionId();

        public CreateAwsKmsHierarchicalKeyringInput build();
    }
}

