/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.control.SortKey;
import org.ldaptive.control.SortRequestControl;
import org.ldaptive.control.util.VirtualListViewParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualListViewClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Connection connection;
    private final SortRequestControl sortControl;

    public VirtualListViewClient(Connection conn, SortKey ... keys) {
        this.connection = conn;
        this.sortControl = new SortRequestControl(keys);
    }

    public Response<SearchResult> execute(SearchRequest request, VirtualListViewParams params) throws LdapException {
        SearchOperation search = new SearchOperation(this.connection);
        request.setControls(this.sortControl, params.createRequestControl(true));
        return search.execute(request);
    }

    public Response<SearchResult> execute(SearchRequest request, VirtualListViewParams params, Response<SearchResult> response) throws LdapException {
        SearchOperation search = new SearchOperation(this.connection);
        request.setControls(this.sortControl, params.createRequestControl(response, true));
        return search.execute(request);
    }
}

