/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.download;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.osmand.AndroidUtils;
import net.osmand.PlatformUtil;
import net.osmand.osm.io.NetworkUtils;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.Version;
import net.osmand.plus.download.DownloadActivityType;
import net.osmand.plus.download.IndexItem;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DownloadOsmandIndexesHelper {
    private static final Log log = PlatformUtil.getLog(DownloadOsmandIndexesHelper.class);

    public static IndexFileList getIndexesList(OsmWindow app) {
        IndexFileList result = DownloadOsmandIndexesHelper.downloadIndexesListFromInternet(app);
        if (result == null) {
            result = new IndexFileList();
        } else {
            result.setDownloadedFromInternet(true);
        }
        DownloadOsmandIndexesHelper.listVoiceAssets(result, app, app.getSettings());
        return result;
    }

    private static Map<String, String> assetMapping(OsmWindow ctx) throws XmlPullParserException, IOException {
        XmlPullParser xmlParser = XmlPullParserFactory.newInstance().newPullParser();
        InputStream isBundledAssetsXml = ctx.getResource("bundled_assets.xml");
        xmlParser.setInput(isBundledAssetsXml, "UTF-8");
        HashMap<String, String> assets = new HashMap<String, String>();
        int next = 0;
        while ((next = xmlParser.next()) != 1) {
            if (next != 2 || !xmlParser.getName().equals("asset")) continue;
            String source = xmlParser.getAttributeValue(null, "source");
            String destination = xmlParser.getAttributeValue(null, "destination");
            assets.put(source, destination);
        }
        isBundledAssetsXml.close();
        return assets;
    }

    private static void listVoiceAssets(IndexFileList result, OsmWindow pApp, OsmandSettings settings) {
        try {
            String ext = DownloadActivityType.addVersionToExt(".ttsvoice.zip", 1);
            File voicePath = pApp.getAppPath("voice/");
            String date = "";
            long dateModified = System.currentTimeMillis();
            date = AndroidUtils.formatDate(dateModified);
            Map<String, String> mapping = DownloadOsmandIndexesHelper.assetMapping(pApp);
            for (String key : mapping.keySet()) {
                String target = mapping.get(key);
                if (!target.endsWith("-tts/_ttsconfig.p") || !target.startsWith("voice/")) continue;
                String voice = target.substring("voice/".length(), target.length() - "/_ttsconfig.p".length());
                File destFile = new File(voicePath, voice + File.separatorChar + "_ttsconfig.p");
                result.add(new AssetIndexItem(voice + ext, "voice", date, dateModified, "0.1", destFile.length(), key, destFile.getPath(), DownloadActivityType.VOICE_FILE));
            }
            result.sort();
        }
        catch (IOException e) {
            log.error((Object)"Error while loading tts files from assets", (Throwable)e);
        }
        catch (XmlPullParserException e) {
            log.error((Object)"Error while loading tts files from assets", (Throwable)e);
        }
    }

    public static String getIndexesUrl(OsmWindow ctx) {
        return "http://download.osmand.net/get_indexes?gzip&" + Version.getVersionAsURLParam(ctx);
    }

    private static IndexFileList downloadIndexesListFromInternet(OsmWindow ctx) {
        try {
            IndexFileList result = new IndexFileList();
            log.debug((Object)"Start loading list of index files");
            try {
                int next;
                String strUrl = DownloadOsmandIndexesHelper.getIndexesUrl(ctx);
                OsmandSettings settings = ctx.getSettings();
                long nd = System.currentTimeMillis();
                if (nd > 0L) {
                    strUrl = strUrl + "&nd=" + (System.currentTimeMillis() - nd) / 86400000L;
                }
                strUrl = strUrl + "&ns=1";
                try {
                    strUrl = strUrl + "&aid=cafebabe";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                log.info((Object)strUrl);
                XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
                HttpURLConnection connection = NetworkUtils.getHttpURLConnection(strUrl);
                InputStream in = connection.getInputStream();
                GZIPInputStream gzin = new GZIPInputStream(in);
                parser.setInput((InputStream)gzin, "UTF-8");
                while ((next = parser.next()) != 1) {
                    if (next != 2) continue;
                    DownloadActivityType tp = DownloadActivityType.getIndexType(parser.getAttributeValue(null, "type"));
                    if (tp != null) {
                        IndexItem it = tp.parseIndexItem(ctx, parser);
                        if (it == null || it.getFileName().contains("_wiki")) continue;
                        result.add(it);
                        continue;
                    }
                    if (!"osmand_regions".equals(parser.getName())) continue;
                    String mapversion = parser.getAttributeValue(null, "mapversion");
                    result.setMapVersion(mapversion);
                }
                result.sort();
                gzin.close();
                in.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while loading indexes from repository", (Throwable)e);
                return null;
            }
            catch (XmlPullParserException e) {
                log.error((Object)"Error while loading indexes from repository", (Throwable)e);
                return null;
            }
            if (result.isAcceptable()) {
                return result;
            }
            return null;
        }
        catch (RuntimeException e) {
            log.error((Object)"Error while loading indexes from repository", (Throwable)e);
            return null;
        }
    }

    public static class AssetIndexItem
    extends IndexItem {
        private final String assetName;
        private final String destFile;
        private final long dateModified;

        public AssetIndexItem(String fileName, String description, String date, long dateModified, String size, long sizeL, String assetName, String destFile, DownloadActivityType type) {
            super(fileName, description, dateModified, size, sizeL, sizeL, type);
            this.dateModified = dateModified;
            this.assetName = assetName;
            this.destFile = destFile;
        }

        public long getDateModified() {
            return this.dateModified;
        }

        @Override
        public IndexItem.DownloadEntry createDownloadEntry(OsmWindow ctx) {
            return new IndexItem.DownloadEntry(this.assetName, this.destFile, this.dateModified);
        }

        public String getDestFile() {
            return this.destFile;
        }
    }

    public static class IndexFileList
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean downloadedFromInternet = false;
        IndexItem basemap;
        ArrayList<IndexItem> indexFiles = new ArrayList();
        private String mapversion;
        private Comparator<IndexItem> comparator = new Comparator<IndexItem>(){

            @Override
            public int compare(IndexItem o1, IndexItem o2) {
                String object1 = o1.getFileName();
                String object2 = o2.getFileName();
                if (object1.endsWith("voice.zip")) {
                    if (object2.endsWith("voice.zip")) {
                        return object1.compareTo(object2);
                    }
                    return -1;
                }
                if (object2.endsWith("voice.zip")) {
                    return 1;
                }
                return object1.compareTo(object2);
            }
        };

        public void setDownloadedFromInternet(boolean downloadedFromInternet) {
            this.downloadedFromInternet = downloadedFromInternet;
        }

        public boolean isDownloadedFromInternet() {
            return this.downloadedFromInternet;
        }

        public void setMapVersion(String mapversion) {
            this.mapversion = mapversion;
        }

        public void add(IndexItem indexItem) {
            this.indexFiles.add(indexItem);
            if (indexItem.getFileName().toLowerCase().startsWith("world_basemap")) {
                this.basemap = indexItem;
            }
        }

        public void sort() {
            Collections.sort(this.indexFiles, this.comparator);
        }

        public boolean isAcceptable() {
            return this.indexFiles != null && !this.indexFiles.isEmpty() || this.mapversion != null;
        }

        public List<IndexItem> getIndexFiles() {
            return this.indexFiles;
        }

        public IndexItem getBasemap() {
            return this.basemap;
        }

        public boolean isIncreasedMapVersion() {
            try {
                int mapVersionInList = Integer.parseInt(this.mapversion);
                return 2 < mapVersionInList;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }
}

