/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.openide.awt.HtmlRenderer;

public final class GtkViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int BUMP_X_PAD = 0;
    private static final int BUMP_WIDTH = 0;
    private static final int TXT_X_PAD = 7;
    private static final int TXT_Y_PAD = 5;
    private static final int ICON_X_PAD = 2;
    private static Map<Integer, String[]> buttonIconPaths;
    private static JTabbedPane dummyTab;
    private static final Logger LOG;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private GtkViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new GtkViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 19 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 5;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ColorUtil.setupAntialiasing(graphics);
        Color color = jComponent.getBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paintOverallBorder(graphics, jComponent);
        super.paint(graphics, jComponent);
    }

    protected void paintOverallBorder(Graphics graphics, JComponent jComponent) {
    }

    @Override
    protected Font getTxtFont() {
        Font font = UIManager.getFont("controlFont");
        if (font != null) {
            return font;
        }
        return super.getTxtFont();
    }

    @Override
    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        Object object;
        Object object2;
        --n5;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n6 = n4;
        if (this.isSelected(n)) {
            Component component = this.getControlButtons();
            if (null != component) {
                object2 = component.getPreferredSize();
                if (n4 < ((Dimension)object2).width + 2) {
                    component.setVisible(false);
                } else {
                    component.setVisible(true);
                    n6 = n4 - (((Dimension)object2).width + 2 + 7);
                    component.setLocation(n2 + n6 + 7, n3 + (n5 - ((Dimension)object2).height) / 2 + 2);
                }
            }
        } else {
            n6 = n4 - 14;
        }
        this.drawBump(graphics, n, n2 + 4, n3 + 6, 0, n5 - 8);
        boolean bl = false;
        object2 = this.displayer.getContainerWinsysInfo();
        if (null != object2 && ((WinsysInfoForTabbedContainer)object2).isSlidedOutContainer()) {
            bl = false;
        }
        if (this.isTabBusy(n) && !bl) {
            object = BusyTabsSupport.getDefault().getBusyIcon(this.isSelected(n));
            n6 -= object.getIconWidth() - 3 - 7;
            object.paintIcon(this.displayer, graphics, n2 + 7, n3 + (n5 - object.getIconHeight()) / 2);
            n2 += object.getIconWidth() + 3;
        }
        object = UIManager.getColor("textText");
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + 7), (int)(n3 + fontMetrics.getAscent() + 5), (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)object, (int)1, (boolean)true);
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    private static void paintTabBackgroundNative(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n6 = this.isSelected(n) ? 512 : 1024;
        if (dummyTab == null) {
            dummyTab = new JTabbedPane();
        }
        Region region = Region.TABBED_PANE_TAB;
        if (!(UIManager.getLookAndFeel() instanceof SynthLookAndFeel)) {
            return;
        }
        SynthLookAndFeel synthLookAndFeel = (SynthLookAndFeel)UIManager.getLookAndFeel();
        SynthStyleFactory synthStyleFactory = synthLookAndFeel.getStyleFactory();
        SynthStyle synthStyle = synthStyleFactory.getStyle(dummyTab, region);
        SynthContext synthContext = new SynthContext(dummyTab, region, synthStyle, n6);
        SynthPainter synthPainter = synthStyle.getPainter(synthContext);
        if (n6 == 512) {
            RescaleOp rescaleOp = null;
            if (this.isActive()) {
                rescaleOp = new RescaleOp(1.08f, 0.0f, null);
            } else {
                rescaleOp = new RescaleOp(0.96f, 0.0f, null);
                ++n3;
                --n5;
            }
            BufferedImage bufferedImage = new BufferedImage(n4, n5, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setBackground(UIManager.getColor("Panel.background"));
            graphics2D.clearRect(0, 0, n4, n5);
            long l = System.currentTimeMillis();
            synthPainter.paintTabbedPaneTabBackground(synthContext, graphics2D, 0, 0, n4, n5, n);
            long l2 = System.currentTimeMillis();
            if (l2 - l > 200L) {
                LOG.log(Level.WARNING, "painter.paintTabbedPaneTabBackground1 takes too long x=0 y=0 w=" + n4 + " h=" + n5 + " index:" + n + " Time=" + (l2 - l));
            }
            BufferedImage bufferedImage2 = rescaleOp.filter(bufferedImage, null);
            graphics.drawImage(bufferedImage2, n2, n3, null);
        } else {
            long l = System.currentTimeMillis();
            synthPainter.paintTabbedPaneTabBackground(synthContext, graphics, n2, n3 + 2, n4, n5 - 2, n);
            long l3 = System.currentTimeMillis();
            if (l3 - l > 200L) {
                LOG.log(Level.WARNING, "painter.paintTabbedPaneTabBackground2 takes too long x=" + n2 + " y=" + (n3 + 2) + " w=" + n4 + " h=" + (n5 - 2) + " index:" + n + " Time=" + (l3 - l));
            }
        }
    }

    private void drawBump(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            stringArray = new String[]{"org/openide/awt/resources/gtk_bigclose_enabled.png", "org/openide/awt/resources/gtk_bigclose_pressed.png", stringArray[0], "org/openide/awt/resources/gtk_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_restore_group_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_restore_group_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_restore_group_rollover.png"};
            buttonIconPaths.put(11, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_minimize_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_minimize_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_minimize_rollover.png"};
            buttonIconPaths.put(12, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        GtkViewTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.swing.tabcontrol.plaf.GtkViewTabDisplayerUI");
    }
}

