/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.parosproxy.paros.core.scanner.RPCParameter;

public class JsonParamParser {
    public static final String JSON_RPC_CONTENT_TYPE = "application/json";
    public static final int NAME_SEPARATOR = 58;
    public static final int VALUE_SEPARATOR = 44;
    public static final int BEGIN_ARRAY = 91;
    public static final int QUOTATION_MARK = 34;
    public static final int BEGIN_OBJECT = 123;
    public static final int END_OBJECT = 125;
    public static final int END_ARRAY = 93;
    public static final int BACKSLASH = 92;
    private static final int STATE_INIT = 0;
    private static final int STATE_READ_START_OBJECT = 1;
    private static final int STATE_READ_FIELD = 2;
    private static final int STATE_READ_VALUE = 3;
    private static final int STATE_READ_POST_VALUE = 4;
    private SimpleStringReader sr;
    private boolean scanNullValues;
    private String jsonStr;

    public JsonParamParser(String jsonStr, boolean scanNullValues) {
        this.jsonStr = jsonStr;
        this.scanNullValues = scanNullValues;
    }

    public void setScanNullValues(boolean scan) {
        this.scanNullValues = scan;
    }

    public boolean isScanNullValues() {
        return this.scanNullValues;
    }

    public List<RPCParameter> getParameters() {
        ArrayList<RPCParameter> list = new ArrayList<RPCParameter>();
        if (!this.jsonStr.isEmpty()) {
            this.sr = new SimpleStringReader(this.jsonStr);
            this.parseObject(0, list);
        }
        return list;
    }

    private String getToken(int beginOffset, int endOffset) {
        return this.jsonStr.substring(beginOffset, endOffset);
    }

    private void parseObject(int state, List<RPCParameter> list) {
        boolean objectRead = false;
        boolean done = false;
        String field = null;
        while (!done) {
            switch (state) {
                case 0: {
                    int chr = this.sr.skipWhitespaceRead();
                    if (chr == 123) {
                        this.sr.unreadLastCharacter();
                        state = 1;
                        break;
                    }
                    if (chr == 91) {
                        this.sr.unreadLastCharacter();
                        state = 3;
                        break;
                    }
                    this.sr.unreadLastCharacter();
                    state = 3;
                    break;
                }
                case 1: {
                    int chr = this.sr.skipWhitespaceRead();
                    if (chr == 123) {
                        objectRead = true;
                        chr = this.sr.skipWhitespaceRead();
                        if (chr == 125) {
                            return;
                        }
                        this.sr.unreadLastCharacter();
                        state = 2;
                        break;
                    }
                    if (chr == 91) {
                        this.sr.unreadLastCharacter();
                        state = 3;
                        break;
                    }
                    throw new IllegalArgumentException("Input is invalid JSON; does not start with '{' or '[', c=" + chr);
                }
                case 2: {
                    int chr = this.sr.skipWhitespaceRead();
                    if (chr == 34) {
                        int beginToken = this.sr.getPosition();
                        this.readEscapedString();
                        int endToken = this.sr.getPosition() - 1;
                        field = this.getToken(beginToken, endToken);
                        chr = this.sr.skipWhitespaceRead();
                        if (chr != 58) {
                            throw new IllegalArgumentException("Expected ':' between string field and value at position " + this.sr.getPosition());
                        }
                        this.sr.skipWhitespaceRead();
                        this.sr.unreadLastCharacter();
                        state = 3;
                        break;
                    }
                    throw new IllegalArgumentException("Expected quote at position " + this.sr.getPosition());
                }
                case 3: {
                    if (field == null) {
                        field = "@items";
                    }
                    this.parseValue(field, list);
                    state = 4;
                    break;
                }
                case 4: {
                    int chr = this.sr.skipWhitespaceRead();
                    if (chr == -1 && objectRead) {
                        throw new IllegalArgumentException("EOF reached before closing '}'");
                    }
                    if (chr == 125 || chr == -1) {
                        done = true;
                        break;
                    }
                    if (chr == 44) {
                        state = 2;
                        break;
                    }
                    throw new IllegalArgumentException("Object not ended with '}' or ']' at position " + this.sr.getPosition());
                }
            }
        }
    }

    private static String getUnescapedValue(String value) {
        return StringEscapeUtils.unescapeJava((String)value);
    }

    private void parseValue(String fieldName, List<RPCParameter> list) {
        int chr = this.sr.read();
        if (chr == 34) {
            int beginToken = this.sr.getPosition();
            this.readEscapedString();
            int endToken = this.sr.getPosition() - 1;
            String value = JsonParamParser.getUnescapedValue(this.jsonStr.substring(beginToken, endToken));
            list.add(new RPCParameter(fieldName, value, beginToken, endToken, false));
        } else if (Character.isDigit(chr) || chr == 45) {
            this.sr.unreadLastCharacter();
            int beginToken = this.sr.getPosition();
            do {
                if ((chr = this.sr.read()) != -1) continue;
                throw new IllegalArgumentException("Reached EOF while reading number");
            } while (Character.isDigit(chr) || chr == 46 || chr == 101 || chr == 69 || chr == 43 || chr == 45);
            this.sr.unreadLastCharacter();
            int endToken = this.sr.getPosition();
            String value = JsonParamParser.getUnescapedValue(this.jsonStr.substring(beginToken, endToken));
            list.add(new RPCParameter(fieldName, value, beginToken, endToken, true));
        } else if (chr == 123) {
            this.sr.unreadLastCharacter();
            this.parseObject(1, list);
        } else if (chr == 91) {
            this.parseArray(fieldName, list);
        } else if (chr == 93) {
            this.sr.unreadLastCharacter();
        } else if (chr == 116 || chr == 84) {
            this.sr.unreadLastCharacter();
            this.parseToken("true");
        } else if (chr == 102 || chr == 70) {
            this.sr.unreadLastCharacter();
            this.parseToken("false");
        } else if (chr == 110 || chr == 78) {
            this.sr.unreadLastCharacter();
            if (this.scanNullValues) {
                int start = this.sr.getPosition();
                list.add(new RPCParameter(fieldName, null, start, start + 4, true));
            }
            this.parseToken("null");
        } else {
            if (chr == -1) {
                throw new IllegalArgumentException("EOF reached prematurely");
            }
            throw new IllegalArgumentException("Unknown value type '" + chr + "' for field '" + fieldName + "' at position " + this.sr.getPosition());
        }
    }

    private void parseArray(String fieldName, List<RPCParameter> list) {
        block1: {
            int chr;
            int idx = 0;
            do {
                this.sr.skipWhitespaceRead();
                this.sr.unreadLastCharacter();
                this.parseValue(fieldName + "[" + idx++ + "]", list);
                chr = this.sr.skipWhitespaceRead();
                if (chr == 93) break block1;
            } while (chr == 44);
            throw new IllegalArgumentException("Expected ',' or ']' inside array at position " + this.sr.getPosition());
        }
    }

    private void parseToken(String token) {
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            int chr = this.sr.read();
            if (chr == -1) {
                throw new IllegalArgumentException("EOF reached while reading token: " + token);
            }
            chr = Character.toLowerCase((char)chr);
            char loTokenChar = token.charAt(i);
            if (loTokenChar == chr) continue;
            throw new IllegalArgumentException("Expected token: " + token + " at position " + this.sr.getPosition());
        }
    }

    private void readEscapedString() {
        block2: {
            int chr;
            do {
                if ((chr = this.sr.read()) == 92) {
                    chr = this.sr.read();
                    continue;
                }
                if (chr == 34) break block2;
            } while (chr != -1);
            throw new IllegalArgumentException("EOF reached while reading JSON field name");
        }
    }

    protected class SimpleStringReader {
        private static final String WS = " \t\r\n";
        private String str;
        private int length;
        private int next = 0;

        public SimpleStringReader(String s) {
            this.str = s;
            this.length = s.length();
        }

        public int skipWhitespaceRead() {
            int c = this.read();
            while (WS.indexOf(c) != -1) {
                c = this.read();
            }
            return c;
        }

        public int read() {
            if (this.next >= this.length) {
                return -1;
            }
            return this.str.charAt(this.next++);
        }

        public void unreadLastCharacter() {
            --this.next;
        }

        public int getPosition() {
            return this.next;
        }
    }
}

