/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileTableContentProvider
implements IStructuredContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private final FileSearchPage fPage;

    public FileTableContentProvider(FileSearchPage page) {
        this.fPage = page;
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getLeafCount(Object parentElement) {
        void searchResult;
        if (!(parentElement instanceof AbstractTextSearchResult)) {
            return 0;
        }
        AbstractTextSearchResult abstractTextSearchResult = (AbstractTextSearchResult)parentElement;
        int elementLimit = this.getElementLimit();
        int elementsCount = searchResult.getElementsCount();
        if (elementLimit != -1 && elementsCount > elementLimit) {
            return elementLimit;
        }
        return elementsCount;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof FileSearchResult) {
            FileSearchResult fileSearchResult = (FileSearchResult)inputElement;
            int elementLimit = this.getElementLimit();
            Object[] elements = fileSearchResult.getElements();
            if (elementLimit != -1 && elements.length > elementLimit) {
                Object[] shownElements = new Object[elementLimit];
                System.arraycopy(elements, 0, shownElements, 0, elementLimit);
                return shownElements;
            }
            if (fileSearchResult.getActiveMatchFilters().length > 0) {
                ArrayList<Object> elementList = new ArrayList<Object>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (this.fPage.getDisplayedMatchCount(element) > 0) {
                        elementList.add(element);
                    }
                    ++n2;
                }
                elements = elementList.toArray();
            }
            return elements;
        }
        return this.EMPTY_ARR;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public void elementsChanged(Object[] updatedElements) {
        TableViewer viewer = this.getViewer();
        int elementLimit = this.getElementLimit();
        boolean tableLimited = elementLimit != -1;
        Object[] objectArray = updatedElements;
        int n = updatedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object updatedElement = objectArray[n2];
            if (this.fPage.getDisplayedMatchCount(updatedElement) > 0) {
                if (viewer.contains(updatedElement)) {
                    viewer.update(updatedElement, null);
                } else if (!tableLimited || viewer.getTable().getItemCount() < elementLimit) {
                    viewer.add(updatedElement);
                }
            } else {
                viewer.remove(updatedElement);
            }
            ++n2;
        }
    }

    private int getElementLimit() {
        return this.fPage.getElementLimit();
    }

    private TableViewer getViewer() {
        return (TableViewer)this.fPage.getViewer();
    }

    @Override
    public void clear() {
        this.getViewer().refresh();
    }
}

