/*
 * Decompiled with CFR 0.152.
 */
package mobiledevices.dmg.ghidra;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class GFileUtilityMethods {
    private static final String GHIDRA_FILE_SYSTEM_PREFIX = "ghidra_file_system_";
    private static final String GHIDRA_FILE_SYSTEM_SUFFIX = ".tmp";

    public static final File writeTemporaryFile(InputStream inputStream) throws IOException {
        return GFileUtilityMethods.writeTemporaryFile(inputStream, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File writeTemporaryFile(InputStream inputStream, int maxBytesToWrite) throws IOException {
        File tempOutputFile = File.createTempFile(GHIDRA_FILE_SYSTEM_PREFIX, GHIDRA_FILE_SYSTEM_SUFFIX);
        tempOutputFile.deleteOnExit();
        try (FileOutputStream outputStream = new FileOutputStream(tempOutputFile);){
            int nRead;
            int nWritten = 0;
            byte[] buffer = new byte[8192];
            do {
                if ((nRead = inputStream.read(buffer)) == -1) {
                    break;
                }
                ((OutputStream)outputStream).write(buffer, 0, nRead);
            } while ((nWritten += nRead) < maxBytesToWrite);
        }
        return tempOutputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File writeTemporaryFile(byte[] bytes, String prefix) throws IOException {
        if (prefix == null) {
            prefix = GHIDRA_FILE_SYSTEM_PREFIX;
        }
        if (((String)prefix).length() < 3) {
            for (int i = ((String)prefix).length(); i < 3; ++i) {
                prefix = (String)prefix + "_";
            }
        }
        File tempFile = File.createTempFile((String)prefix, GHIDRA_FILE_SYSTEM_SUFFIX);
        tempFile.deleteOnExit();
        try (FileOutputStream tempFileOut = new FileOutputStream(tempFile);){
            ((OutputStream)tempFileOut).write(bytes);
        }
        return tempFile;
    }
}

