/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import generic.CatenatedCollection;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceInactiveCoordinatesPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionSet;
import ghidra.app.plugin.core.debug.service.breakpoint.LogicalBreakpointInternal;
import ghidra.app.plugin.core.debug.service.breakpoint.LoneLogicalBreakpoint;
import ghidra.app.plugin.core.debug.service.breakpoint.MappedLogicalBreakpoint;
import ghidra.app.plugin.core.debug.service.breakpoint.ProgramBreakpoint;
import ghidra.app.plugin.core.debug.service.breakpoint.TrackedTooSoonException;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.SwingExecutorService;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import ghidra.debug.api.breakpoint.LogicalBreakpointsChangeListener;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.modules.DebuggerStaticMappingChangeListener;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.target.TargetPublicationListener;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.Msg;
import ghidra.util.datastruct.ListenerSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;

@PluginInfo(shortDescription="Debugger logical breakpoints service plugin", description="Aggregates breakpoints from open programs and live traces", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceActivatedPluginEvent.class, TraceInactiveCoordinatesPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class, DebuggerStaticMappingService.class}, servicesProvided={DebuggerLogicalBreakpointService.class})
public class DebuggerLogicalBreakpointServicePlugin
extends Plugin
implements DebuggerLogicalBreakpointService {
    private DebuggerTargetService targetService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private DebuggerStaticMappingService mappingService;
    private DebuggerControlService controlService;
    private final AutoService.Wiring autoServiceWiring;
    private final Object lock = new Object();
    private final ListenerSet<LogicalBreakpointsChangeListener> changeListeners = new ListenerSet(LogicalBreakpointsChangeListener.class, true);
    private final TrackTargetsListener targetsListener = new TrackTargetsListener();
    private final TrackMappingsListener mappingListener = new TrackMappingsListener();
    private final TrackModesListener modeListener = new TrackModesListener();
    private final Map<Trace, InfoPerTrace> traceInfos = new HashMap<Trace, InfoPerTrace>();
    private final Map<Program, InfoPerProgram> programInfos = new HashMap<Program, InfoPerProgram>();
    private final Collection<AbstractInfo> allInfos = new CatenatedCollection(new Collection[]{this.traceInfos.values(), this.programInfos.values()});
    private final ExecutorService executor = SwingExecutorService.MAYBE_NOW;

    public DebuggerLogicalBreakpointServicePlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
    }

    protected void processChange(Consumer<ChangeCollector> processor, String description) {
        this.executor.submit(() -> {
            try (ChangeCollector c = new ChangeCollector((LogicalBreakpointsChangeListener)this.changeListeners.invoke());){
                Object object = this.lock;
                synchronized (object) {
                    processor.accept(c);
                }
            }
            catch (Throwable t) {
                Msg.error((Object)((Object)this), (Object)("Could not process event " + description), (Throwable)t);
            }
        });
    }

    protected void evtMappingsChanged(ChangeCollector c, Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
        AbstractInfo info;
        HashSet<Trace> additionalTraces = new HashSet<Trace>(affectedTraces);
        HashSet<Program> additionalPrograms = new HashSet<Program>(affectedPrograms);
        for (Trace t : affectedTraces) {
            info = this.traceInfos.get(t);
            if (info == null) continue;
            info.forgetMismappedBreakpoints(c.r, additionalTraces, additionalPrograms);
        }
        for (Program p : affectedPrograms) {
            info = this.programInfos.get(p);
            if (info == null) continue;
            info.forgetMismappedBreakpoints(c.r, additionalTraces, additionalPrograms);
        }
        for (Program p : additionalPrograms) {
            info = this.programInfos.get(p);
            if (info == null) continue;
            ((InfoPerProgram)info).reloadBreakpoints(c);
        }
        for (Trace t : additionalTraces) {
            info = this.traceInfos.get(t);
            if (info == null) continue;
            ((InfoPerTrace)info).reloadBreakpoints(c);
        }
    }

    protected void evtModeChanged(ChangeCollector c, Trace trace) {
        InfoPerTrace info = this.traceInfos.get(trace);
        if (info != null) {
            info.reloadBreakpoints(c);
        }
    }

    protected void removeLogicalBreakpointGlobally(LogicalBreakpoint lb) {
        InfoPerProgram info;
        ProgramLocation pLoc = lb.getProgramLocation();
        if (pLoc != null && (info = this.programInfos.get(pLoc.getProgram())) != null) {
            info.removeLogicalBreakpoint(pLoc.getByteAddress(), lb);
        }
        for (Trace t : lb.getMappedTraces()) {
            Address tAddr = lb.getTraceAddress(t);
            InfoPerTrace info2 = this.traceInfos.get(t);
            if (info2 == null) continue;
            info2.removeLogicalBreakpoint(tAddr, lb);
        }
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerTargetService targetService) {
        if (this.targetService != null) {
            this.targetService.removeTargetPublicationListener((TargetPublicationListener)this.targetsListener);
        }
        this.targetService = targetService;
        if (this.targetService != null) {
            this.targetService.addTargetPublicationListener((TargetPublicationListener)this.targetsListener);
        }
    }

    @AutoServiceConsumed
    private void setMappingService(DebuggerStaticMappingService mappingService) {
        if (this.mappingService != null) {
            this.mappingService.removeChangeListener((DebuggerStaticMappingChangeListener)this.mappingListener);
        }
        this.mappingService = mappingService;
        if (this.mappingService != null) {
            this.mappingService.addChangeListener((DebuggerStaticMappingChangeListener)this.mappingListener);
        }
    }

    @AutoServiceConsumed
    private void setControlService(DebuggerControlService editingService) {
        if (this.controlService != null) {
            this.controlService.removeModeChangeListener((DebuggerControlService.ControlModeChangeListener)this.modeListener);
        }
        this.controlService = editingService;
        if (this.controlService != null) {
            this.controlService.addModeChangeListener((DebuggerControlService.ControlModeChangeListener)this.modeListener);
        }
    }

    private void programOpened(Program program) {
        this.processChange(c -> this.evtProgramOpened((ChangeCollector)c, program), "programOpened");
    }

    private void evtProgramOpened(ChangeCollector c, Program program) {
        if (program instanceof TraceProgramView) {
            return;
        }
        InfoPerProgram info = new InfoPerProgram(program);
        if (this.programInfos.put(program, info) != null) {
            throw new AssertionError((Object)"Already tracking program breakpoints");
        }
        info.reloadBreakpoints(c);
    }

    private void programClosed(Program program) {
        this.processChange(c -> this.evtProgramClosed((ChangeCollector)c, program), "programClosed");
    }

    private void evtProgramClosed(ChangeCollector c, Program program) {
        if (program instanceof TraceProgramView) {
            return;
        }
        this.programInfos.remove(program).dispose(c.r);
    }

    private void doTrackTrace(ChangeCollector c, Trace trace, Target target, long snap) {
        InfoPerTrace info = this.traceInfos.get(trace);
        if (info == null) {
            info = new InfoPerTrace(trace);
            this.traceInfos.put(trace, info);
        }
        info.setTargetAndSnap(target, snap, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUntrackTrace(ChangeCollector c, Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace tInfo = this.traceInfos.remove(trace);
            if (tInfo == null) {
                return;
            }
            tInfo.dispose(c.r);
            for (InfoPerProgram pInfo : this.programInfos.values()) {
                for (Set set : pInfo.logicalByAddress.values()) {
                    for (LogicalBreakpointInternal lb : set) {
                        lb.removeTrace(trace);
                        c.a.updated(lb);
                    }
                }
            }
        }
    }

    private void evtTraceTargetPublished(ChangeCollector c, Target target) {
        Trace trace = target.getTrace();
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            return;
        }
        long snap = this.traceManager.getCurrentFor(trace).getSnap();
        this.doTrackTrace(c, trace, target, snap);
    }

    private void evtTraceTargetWithdrawn(ChangeCollector c, Target target) {
        Trace trace = target.getTrace();
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            return;
        }
        long snap = this.traceManager.getCurrentFor(trace).getSnap();
        this.doTrackTrace(c, trace, null, snap);
    }

    private void traceOpened(Trace trace) {
        this.processChange(c -> {
            Target target = this.targetService == null ? null : this.targetService.getTarget(trace);
            long snap = this.traceManager.getCurrentFor(trace).getSnap();
            this.doTrackTrace((ChangeCollector)c, trace, target, snap);
        }, "traceOpened");
    }

    private void traceSnapChanged(DebuggerCoordinates coordinates) {
        if (coordinates.getTrace() == null) {
            return;
        }
        this.processChange(c -> this.doTrackTrace((ChangeCollector)c, coordinates.getTrace(), coordinates.getTarget(), coordinates.getSnap()), "coordinatesActivated");
    }

    private void traceClosed(Trace trace) {
        this.processChange(c -> this.doUntrackTrace((ChangeCollector)c, trace), "traceClosed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LogicalBreakpoint> getAllBreakpoints() {
        Object object = this.lock;
        synchronized (object) {
            HashSet<LogicalBreakpoint> records = new HashSet<LogicalBreakpoint>();
            for (AbstractInfo info : this.allInfos) {
                for (Set recsAtAddress : info.logicalByAddress.values()) {
                    records.addAll(recsAtAddress);
                }
            }
            return records;
        }
    }

    protected static <K, V> NavigableMap<K, Set<V>> copyOf(NavigableMap<? extends K, ? extends Set<? extends V>> map) {
        TreeMap result = new TreeMap();
        for (Map.Entry ent : map.entrySet()) {
            result.put(ent.getKey(), new HashSet((Collection)ent.getValue()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Program program) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.programInfos.get(program);
            if (info == null) {
                return Collections.emptyNavigableMap();
            }
            return DebuggerLogicalBreakpointServicePlugin.copyOf(info.logicalByAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.traceInfos.get(trace);
            if (info == null) {
                return Collections.emptyNavigableMap();
            }
            return DebuggerLogicalBreakpointServicePlugin.copyOf(info.logicalByAddress);
        }
    }

    protected Set<LogicalBreakpoint> doGetBreakpointsAt(AbstractInfo info, Address address) {
        Set set = (Set)info.logicalByAddress.get(address);
        if (set == null) {
            return Set.of();
        }
        return new HashSet<LogicalBreakpoint>(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LogicalBreakpoint> getBreakpointsAt(Program program, Address address) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.programInfos.get(program);
            if (info == null) {
                return Set.of();
            }
            return this.doGetBreakpointsAt(info, address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LogicalBreakpoint> getBreakpointsAt(Trace trace, Address address) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.traceInfos.get(trace);
            if (info == null) {
                return Set.of();
            }
            return this.doGetBreakpointsAt(info, address).stream().filter(lb -> lb.computeStateForTrace(trace) != LogicalBreakpoint.State.NONE).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalBreakpoint getBreakpoint(TraceBreakpointLocation bpt) {
        Trace trace = bpt.getTrace();
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.traceInfos.get(trace);
            if (info == null) {
                return null;
            }
            Address address = bpt.getMinAddress(info.snap);
            if (address == null) {
                return null;
            }
            for (LogicalBreakpoint lb : this.getBreakpointsAt(trace, address)) {
                if (!lb.getTraceBreakpoints(trace).contains(bpt)) continue;
                return lb;
            }
        }
        return null;
    }

    public Set<LogicalBreakpoint> getBreakpointsAt(ProgramLocation loc) {
        return (Set)DebuggerLogicalBreakpointService.programOrTrace((ProgramLocation)loc, this::getBreakpointsAt, this::getBreakpointsAt);
    }

    public void addChangeListener(LogicalBreakpointsChangeListener l) {
        this.changeListeners.add((Object)l);
    }

    public void removeChangeListener(LogicalBreakpointsChangeListener l) {
        this.changeListeners.remove((Object)l);
    }

    public CompletableFuture<Void> changesSettled() {
        return CompletableFuture.supplyAsync(() -> null, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MappedLogicalBreakpoint synthesizeLogicalBreakpoint(Program program, Address address, long length, Collection<TraceBreakpointKind> kinds) {
        MappedLogicalBreakpoint lb = new MappedLogicalBreakpoint(this.tool, program, address, length, kinds);
        Object object = this.lock;
        synchronized (object) {
            for (InfoPerTrace ti : this.traceInfos.values()) {
                TraceLocation loc = ti.toDynamicLocation(lb.getProgramLocation());
                if (loc == null) continue;
                lb.setTraceAddress(ti.trace, loc.getAddress());
                lb.setTarget(ti.trace, ti.target);
            }
        }
        return lb;
    }

    public CompletableFuture<Void> placeBreakpointAt(Program program, Address address, long length, Collection<TraceBreakpointKind> kinds, String name) {
        MappedLogicalBreakpoint lb = this.synthesizeLogicalBreakpoint(program, address, length, kinds);
        return lb.enableWithName(name);
    }

    public CompletableFuture<Void> placeBreakpointAt(Trace trace, Address address, long length, Collection<TraceBreakpointKind> kinds, String name) {
        long snap = this.traceManager.getCurrentFor(trace).getSnap();
        Target target = this.targetService == null ? null : this.targetService.getTarget(trace);
        ProgramLocation staticLocation = this.mappingService.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(trace, null, Lifespan.at((long)snap), address));
        if (staticLocation == null) {
            LoneLogicalBreakpoint lb = new LoneLogicalBreakpoint(this.tool, trace, address, length, kinds);
            lb.setTarget(trace, target);
            return lb.enableForTrace(trace);
        }
        MappedLogicalBreakpoint lb = new MappedLogicalBreakpoint(this.tool, staticLocation.getProgram(), staticLocation.getByteAddress(), length, kinds);
        lb.setTraceAddress(trace, address);
        lb.setTarget(trace, target);
        lb.enableForProgramWithName(name);
        return lb.enableForTrace(trace);
    }

    public CompletableFuture<Void> placeBreakpointAt(ProgramLocation loc, long length, Collection<TraceBreakpointKind> kinds, String name) {
        return (CompletableFuture)DebuggerLogicalBreakpointService.programOrTrace((ProgramLocation)loc, (p, a) -> this.placeBreakpointAt((Program)p, (Address)a, length, kinds, name), (t, a) -> this.placeBreakpointAt((Trace)t, (Address)a, length, kinds, name));
    }

    protected CompletableFuture<Void> actOnAll(Collection<LogicalBreakpoint> col, Trace trace, Consumer<LogicalBreakpoint> consumerForProgram, BiConsumer<BreakpointActionSet, LogicalBreakpointInternal> consumerForTrace) {
        BreakpointActionSet actions = new BreakpointActionSet();
        for (LogicalBreakpoint lb : col) {
            Set participants = lb.getParticipatingTraces();
            if (trace == null || participants.isEmpty() || participants.equals(Set.of(trace))) {
                consumerForProgram.accept(lb);
            }
            if (!(lb instanceof LogicalBreakpointInternal)) continue;
            LogicalBreakpointInternal lbi = (LogicalBreakpointInternal)lb;
            consumerForTrace.accept(actions, lbi);
        }
        return actions.execute();
    }

    public String generateStatusEnable(Collection<LogicalBreakpoint> col, Trace trace) {
        for (LogicalBreakpoint lb : col) {
            String message = lb.generateStatusEnable(trace);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    public CompletableFuture<Void> enableAll(Collection<LogicalBreakpoint> col, Trace trace) {
        return this.actOnAll(col, trace, LogicalBreakpoint::enableForProgram, (actions, lbi) -> lbi.planEnable((BreakpointActionSet)actions, trace));
    }

    public CompletableFuture<Void> disableAll(Collection<LogicalBreakpoint> col, Trace trace) {
        return this.actOnAll(col, trace, LogicalBreakpoint::disableForProgram, (actions, lbi) -> lbi.planDisable((BreakpointActionSet)actions, trace));
    }

    public CompletableFuture<Void> deleteAll(Collection<LogicalBreakpoint> col, Trace trace) {
        return this.actOnAll(col, trace, lb -> {
            if (trace == null) {
                lb.deleteForProgram();
            }
        }, (actions, lbi) -> lbi.planDelete((BreakpointActionSet)actions, trace));
    }

    private ControlMode getMode(Trace trace) {
        return this.controlService == null ? ControlMode.DEFAULT : this.controlService.getCurrentMode(trace);
    }

    private void planActOnLoc(BreakpointActionSet actions, TraceBreakpointLocation tb, TargetBreakpointConsumer targetBptConsumer, EmuBreakpointConsumer emuLocConsumer) {
        ControlMode mode = this.getMode(tb.getTrace());
        if (mode.useEmulatedBreakpoints()) {
            this.planActOnLocEmu(actions, tb, emuLocConsumer);
        } else {
            this.planActOnLocTarget(actions, tb, targetBptConsumer);
        }
    }

    private void planActOnLocTarget(BreakpointActionSet actions, TraceBreakpointLocation tb, TargetBreakpointConsumer targetBptConsumer) {
        Target target;
        Target target2 = target = this.targetService == null ? null : this.targetService.getTarget(tb.getTrace());
        if (target == null) {
            return;
        }
        targetBptConsumer.accept(actions, target, tb);
    }

    private void planActOnLocEmu(BreakpointActionSet actions, TraceBreakpointLocation tb, EmuBreakpointConsumer emuLocConsumer) {
        InfoPerTrace info = this.traceInfos.get(tb.getTrace());
        if (info == null) {
            Msg.error((Object)((Object)this), (Object)("No longer tracking " + String.valueOf(tb)));
            return;
        }
        emuLocConsumer.accept(actions, tb, info.snap);
    }

    protected CompletableFuture<Void> actOnLocs(Collection<TraceBreakpointLocation> col, TargetBreakpointConsumer targetBptConsumer, EmuBreakpointConsumer emuLocConsumer, ProgramBreakpointConsumer progConsumer) {
        BreakpointActionSet actions = new BreakpointActionSet();
        for (TraceBreakpointLocation tb : col) {
            LogicalBreakpoint lb = this.getBreakpoint(tb);
            if (col.containsAll(lb.getTraceBreakpoints())) {
                progConsumer.accept(lb);
            }
            this.planActOnLoc(actions, tb, targetBptConsumer, emuLocConsumer);
        }
        return actions.execute();
    }

    public CompletableFuture<Void> enableLocs(Collection<TraceBreakpointLocation> col) {
        return this.actOnLocs(col, BreakpointActionSet::planEnableTarget, BreakpointActionSet::planEnableEmu, LogicalBreakpoint::enableForProgram);
    }

    public CompletableFuture<Void> disableLocs(Collection<TraceBreakpointLocation> col) {
        return this.actOnLocs(col, BreakpointActionSet::planDisableTarget, BreakpointActionSet::planDisableEmu, LogicalBreakpoint::disableForProgram);
    }

    public CompletableFuture<Void> deleteLocs(Collection<TraceBreakpointLocation> col) {
        return this.actOnLocs(col, BreakpointActionSet::planDeleteTarget, BreakpointActionSet::planDeleteEmu, lb -> {});
    }

    public String generateStatusToggleAt(Set<LogicalBreakpoint> bs, ProgramLocation loc) {
        if (bs == null || bs.isEmpty()) {
            return null;
        }
        LogicalBreakpoint.State state = this.computeState(bs, loc);
        Trace trace = (Trace)DebuggerLogicalBreakpointService.programOrTrace((ProgramLocation)loc, (p, a) -> null, (t, a) -> t);
        boolean mapped = this.anyMapped(bs, trace);
        if (!mapped) {
            return "No breakpoint at this location is mapped to a live trace. Cannot toggle on target. Is there a target? Check your module map.";
        }
        LogicalBreakpoint.State toggled = state.getToggled(mapped);
        if (!toggled.isEnabled()) {
            return null;
        }
        return this.generateStatusEnable(bs, trace);
    }

    public CompletableFuture<Set<LogicalBreakpoint>> toggleBreakpointsAt(Set<LogicalBreakpoint> bs, ProgramLocation loc, Supplier<CompletableFuture<Set<LogicalBreakpoint>>> placer) {
        Trace trace;
        boolean mapped;
        if (bs == null || bs.isEmpty()) {
            return placer.get();
        }
        LogicalBreakpoint.State state = this.computeState(bs, loc);
        LogicalBreakpoint.State toggled = state.getToggled(mapped = this.anyMapped(bs, trace = (Trace)DebuggerLogicalBreakpointService.programOrTrace((ProgramLocation)loc, (p, a) -> null, (t, a) -> t)));
        if (toggled.isEnabled()) {
            return this.enableAll(bs, trace).thenApply(__ -> bs);
        }
        return this.disableAll(bs, trace).thenApply(__ -> bs);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramOpenedPluginEvent) {
            ProgramOpenedPluginEvent ev = (ProgramOpenedPluginEvent)event;
            this.programOpened(ev.getProgram());
        } else if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent ev = (ProgramClosedPluginEvent)event;
            this.programClosed(ev.getProgram());
        } else if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent ev = (TraceOpenedPluginEvent)event;
            this.traceOpened(ev.getTrace());
        } else if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.traceSnapChanged(ev.getActiveCoordinates());
        } else if (event instanceof TraceInactiveCoordinatesPluginEvent) {
            TraceInactiveCoordinatesPluginEvent ev = (TraceInactiveCoordinatesPluginEvent)event;
            this.traceSnapChanged(ev.getCoordinates());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent ev = (TraceClosedPluginEvent)event;
            this.traceClosed(ev.getTrace());
        }
    }

    protected class TrackTargetsListener
    implements TargetPublicationListener {
        protected TrackTargetsListener() {
        }

        public void targetPublished(Target target) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> DebuggerLogicalBreakpointServicePlugin.this.evtTraceTargetPublished((ChangeCollector)c, target), "targetPublished");
        }

        public void targetWithdrawn(Target target) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> DebuggerLogicalBreakpointServicePlugin.this.evtTraceTargetWithdrawn((ChangeCollector)c, target), "targetWithdrawn");
        }
    }

    protected class TrackMappingsListener
    implements DebuggerStaticMappingChangeListener {
        protected TrackMappingsListener() {
        }

        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> DebuggerLogicalBreakpointServicePlugin.this.evtMappingsChanged((ChangeCollector)c, affectedTraces, affectedPrograms), "mappingsChanged");
        }
    }

    protected class TrackModesListener
    implements DebuggerControlService.ControlModeChangeListener {
        protected TrackModesListener() {
        }

        public void modeChanged(Trace trace, ControlMode mode) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> DebuggerLogicalBreakpointServicePlugin.this.evtModeChanged((ChangeCollector)c, trace), "modeChanged");
        }
    }

    protected class InfoPerTrace
    extends AbstractInfo {
        final Map<TraceBreakpointLocation, LogicalBreakpointInternal> logicalByBreakpoint;
        final Trace trace;
        final TraceBreakpointsListener breakpointListener;
        Target target;
        long snap;

        public InfoPerTrace(Trace trace) {
            this.logicalByBreakpoint = new HashMap<TraceBreakpointLocation, LogicalBreakpointInternal>();
            this.snap = -1L;
            this.trace = Objects.requireNonNull(trace);
            this.breakpointListener = new TraceBreakpointsListener(this);
            trace.addListener((DomainObjectListener)this.breakpointListener);
        }

        protected void setTargetAndSnap(Target target, long snap, ChangeCollector c) {
            if (this.target == target && this.snap == snap) {
                return;
            }
            this.target = target;
            this.snap = snap;
            for (InfoPerProgram info : DebuggerLogicalBreakpointServicePlugin.this.programInfos.values()) {
                info.reloadBreakpoints(c);
            }
            this.reloadBreakpoints(c);
        }

        @Override
        protected LogicalBreakpointInternal createLogicalBreakpoint(Address address, long length, Collection<TraceBreakpointKind> kinds) {
            LoneLogicalBreakpoint lb = new LoneLogicalBreakpoint(DebuggerLogicalBreakpointServicePlugin.this.tool, this.trace, address, length, kinds);
            lb.setTarget(this.trace, this.target);
            return lb;
        }

        @Override
        protected void dispose(RemoveCollector r) {
            this.trace.removeListener((DomainObjectListener)this.breakpointListener);
            this.forgetAllBreakpoints(r);
        }

        protected void reloadBreakpoints(ChangeCollector c) {
            this.forgetTraceInvalidBreakpoints(c.r);
            this.trackTraceBreakpoints(c.a);
        }

        protected void forgetAllBreakpoints(RemoveCollector r) {
            ArrayList toForget = new ArrayList();
            for (AddressRange range : this.trace.getBaseAddressFactory().getAddressSet()) {
                toForget.addAll(this.trace.getBreakpointManager().getBreakpointsIntersecting((Lifespan)Lifespan.ALL, range));
            }
            for (TraceBreakpointLocation tb : toForget) {
                this.forgetTraceBreakpoint(r, tb);
            }
        }

        protected void forgetTraceInvalidBreakpoints(RemoveCollector r) {
            ControlMode mode = DebuggerLogicalBreakpointServicePlugin.this.getMode(this.trace);
            for (Map.Entry<TraceBreakpointLocation, LogicalBreakpointInternal> ent : Set.copyOf(this.logicalByBreakpoint.entrySet())) {
                TraceBreakpointLocation tb = ent.getKey();
                LogicalBreakpoint lb = ent.getValue();
                if (!(mode.useEmulatedBreakpoints() || this.target != null && this.target.isBreakpointValid(tb))) {
                    this.forgetTraceBreakpoint(r, tb);
                    continue;
                }
                if (!this.trace.getBreakpointManager().getAllBreakpointLocations().contains(tb)) {
                    this.forgetTraceBreakpoint(r, tb);
                    continue;
                }
                if (!tb.isValid(this.snap)) {
                    this.forgetTraceBreakpoint(r, tb);
                    continue;
                }
                ProgramLocation progLoc = this.computeStaticLocation(tb);
                if (Objects.equals(lb.getProgramLocation(), progLoc)) continue;
                this.forgetTraceBreakpoint(r, tb);
            }
        }

        protected void trackTraceBreakpoints(AddCollector a) {
            ControlMode mode = DebuggerLogicalBreakpointServicePlugin.this.getMode(this.trace);
            if (!mode.useEmulatedBreakpoints() && this.target == null) {
                return;
            }
            ArrayList<TraceBreakpointLocation> visible = new ArrayList<TraceBreakpointLocation>();
            for (AddressRange range : this.trace.getBaseAddressFactory().getAddressSet()) {
                visible.addAll(this.trace.getBreakpointManager().getBreakpointsIntersecting(Lifespan.at((long)this.snap), range));
            }
            this.trackTraceBreakpoints(a, visible, mode);
        }

        protected void trackTraceBreakpoints(AddCollector a, Collection<TraceBreakpointLocation> breakpoints, ControlMode mode) {
            for (TraceBreakpointLocation tb : breakpoints) {
                try {
                    this.trackTraceBreakpoint(a, tb, mode, true);
                }
                catch (TrackedTooSoonException e) {
                    Msg.warn((Object)this, (Object)("Might have lost track of a breakpoint: " + String.valueOf(tb)));
                }
            }
        }

        protected ProgramLocation computeStaticLocation(TraceBreakpointLocation tb) {
            if (DebuggerLogicalBreakpointServicePlugin.this.traceManager == null || !DebuggerLogicalBreakpointServicePlugin.this.traceManager.getOpenTraces().contains(tb.getTrace())) {
                return null;
            }
            Address minAddress = tb.getMinAddress(this.snap);
            if (minAddress == null) {
                return null;
            }
            return DebuggerLogicalBreakpointServicePlugin.this.mappingService.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(this.trace, null, Lifespan.at((long)this.snap), minAddress));
        }

        protected void trackTraceBreakpoint(AddCollector a, TraceBreakpointLocation tb, ControlMode mode, boolean forceUpdate) throws TrackedTooSoonException {
            LogicalBreakpointInternal lb;
            if (!(mode.useEmulatedBreakpoints() || this.target != null && this.target.isBreakpointValid(tb))) {
                return;
            }
            Address traceAddr = tb.getMinAddress(this.snap);
            if (traceAddr == null) {
                return;
            }
            ProgramLocation progLoc = this.computeStaticLocation(tb);
            if (progLoc != null) {
                InfoPerProgram progInfo = DebuggerLogicalBreakpointServicePlugin.this.programInfos.get(progLoc.getProgram());
                lb = progInfo.getOrCreateLogicalBreakpointFor(a, progLoc.getByteAddress(), tb, this.snap);
            } else {
                lb = this.getOrCreateLogicalBreakpointFor(a, traceAddr, tb, this.snap);
            }
            assert (((Set)this.logicalByAddress.get(traceAddr)).contains(lb));
            this.logicalByBreakpoint.put(tb, lb);
            if (lb.trackBreakpoint(tb) || forceUpdate) {
                a.updated(lb);
            }
        }

        protected LogicalBreakpointInternal removeFromLogicalBreakpoint(RemoveCollector r, TraceBreakpointLocation tb) {
            LogicalBreakpointInternal lb = this.logicalByBreakpoint.remove(tb);
            if (lb == null || !lb.untrackBreakpoint(tb)) {
                return null;
            }
            if (lb.isEmpty()) {
                this.removeLogicalBreakpoint(lb.getTraceAddress(this.trace), lb);
                DebuggerLogicalBreakpointServicePlugin.this.removeLogicalBreakpointGlobally(lb);
                r.removed(lb);
            } else {
                r.updated(lb);
            }
            return lb;
        }

        protected void forgetTraceBreakpoint(RemoveCollector r, TraceBreakpointLocation tb) {
            LogicalBreakpointInternal lb = this.removeFromLogicalBreakpoint(r, tb);
            if (lb == null) {
                return;
            }
            assert (lb.isEmpty() == (this.logicalByAddress.get(lb.getTraceAddress(this.trace)) == null || !((Set)this.logicalByAddress.get(tb.getMinAddress(this.snap))).contains(lb)));
        }

        public TraceLocation toDynamicLocation(ProgramLocation loc) {
            if (DebuggerLogicalBreakpointServicePlugin.this.mappingService == null) {
                return null;
            }
            return DebuggerLogicalBreakpointServicePlugin.this.mappingService.getOpenMappedLocation(this.trace, loc, this.snap);
        }
    }

    private static class ChangeCollector
    implements AutoCloseable {
        private final AddCollector a;
        private final RemoveCollector r;

        public ChangeCollector(LogicalBreakpointsChangeListener l) {
            HashSet<LogicalBreakpoint> updated = new HashSet<LogicalBreakpoint>();
            this.a = new AddCollector(l, updated);
            this.r = new RemoveCollector(l, updated);
        }

        @Override
        public void close() {
            this.r.deconflict();
            this.a.deconflict();
            this.r.close();
            this.a.close();
        }
    }

    private static class RemoveCollector
    implements AutoCloseable {
        private final LogicalBreakpointsChangeListener l;
        private final Set<LogicalBreakpoint> removed = new HashSet<LogicalBreakpoint>();
        private final Set<LogicalBreakpoint> updated;

        public RemoveCollector(LogicalBreakpointsChangeListener l, Set<LogicalBreakpoint> updated) {
            this.l = l;
            this.updated = updated;
        }

        protected void updated(LogicalBreakpoint lb) {
            this.updated.add(lb);
        }

        protected void removed(LogicalBreakpoint lb) {
            this.removed.add(lb);
        }

        protected void deconflict() {
            this.updated.removeAll(this.removed);
        }

        @Override
        public void close() {
            this.deconflict();
            if (!this.removed.isEmpty()) {
                this.l.breakpointsRemoved(this.removed);
            }
            if (!this.updated.isEmpty()) {
                this.l.breakpointsUpdated(this.updated);
            }
            this.updated.clear();
        }
    }

    protected class InfoPerProgram
    extends AbstractInfo {
        final Program program;
        final ProgramBreakpointsListener breakpointListener;

        public InfoPerProgram(Program program) {
            this.program = program;
            this.breakpointListener = new ProgramBreakpointsListener(this);
            program.addListener((DomainObjectListener)this.breakpointListener);
        }

        protected void mapTraceAddresses(LogicalBreakpointInternal lb) {
            for (InfoPerTrace ti : DebuggerLogicalBreakpointServicePlugin.this.traceInfos.values()) {
                TraceLocation loc = ti.toDynamicLocation(lb.getProgramLocation());
                if (loc == null) continue;
                lb.setTraceAddress(ti.trace, loc.getAddress());
                lb.setTarget(ti.trace, ti.target);
                ti.logicalByAddress.computeIfAbsent(loc.getAddress(), __ -> new HashSet()).add(lb);
            }
        }

        @Override
        protected LogicalBreakpointInternal createLogicalBreakpoint(Address address, long length, Collection<TraceBreakpointKind> kinds) {
            MappedLogicalBreakpoint lb = new MappedLogicalBreakpoint(DebuggerLogicalBreakpointServicePlugin.this.tool, this.program, address, length, kinds);
            this.mapTraceAddresses(lb);
            return lb;
        }

        protected LogicalBreakpointInternal getOrCreateLogicalBreakpointFor(AddCollector a, Bookmark pb) {
            Address address = pb.getAddress();
            Set set = this.logicalByAddress.computeIfAbsent(address, __ -> new HashSet());
            for (LogicalBreakpointInternal lb : set) {
                if (!lb.canMerge(this.program, pb)) continue;
                return lb;
            }
            LogicalBreakpointInternal lb = this.createLogicalBreakpoint(address, ProgramBreakpoint.lengthFromBookmark(pb), ProgramBreakpoint.kindsFromBookmark(pb));
            set.add(lb);
            a.added(lb);
            return lb;
        }

        protected LogicalBreakpointInternal removeFromLogicalBreakpoint(RemoveCollector r, Bookmark pb, boolean forChange) {
            Address address = pb.getAddress();
            Set set = (Set)this.logicalByAddress.get(address);
            if (set == null) {
                Msg.error((Object)this, (Object)("Breakpoint " + String.valueOf(pb) + " was not tracked before removal!"));
                return null;
            }
            for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                if (!lb.untrackBreakpoint(this.program, pb)) continue;
                if (lb.isEmpty() && !forChange) {
                    this.removeLogicalBreakpoint(address, lb);
                    DebuggerLogicalBreakpointServicePlugin.this.removeLogicalBreakpointGlobally(lb);
                    r.removed(lb);
                } else {
                    r.updated(lb);
                }
                return lb;
            }
            Msg.error((Object)this, (Object)("Breakpoint " + String.valueOf(pb) + " was not tracked before removal!"));
            return null;
        }

        @Override
        protected void dispose(RemoveCollector r) {
            this.program.removeListener((DomainObjectListener)this.breakpointListener);
            this.forgetAllBreakpoints(r);
        }

        protected void reloadBreakpoints(ChangeCollector c) {
            this.forgetProgramInvalidBreakpoints(c.r);
            this.trackAllProgramBreakpoints(c.a);
        }

        protected void forgetAllBreakpoints(RemoveCollector r) {
            ArrayList marks = new ArrayList();
            this.program.getBookmarkManager().getBookmarksIterator("BreakpointEnabled").forEachRemaining(marks::add);
            this.program.getBookmarkManager().getBookmarksIterator("BreakpointDisabled").forEachRemaining(marks::add);
            for (Bookmark pb : marks) {
                this.forgetProgramBreakpoint(r, pb, false);
            }
        }

        protected void forgetProgramInvalidBreakpoints(RemoveCollector r) {
            for (Set set : List.copyOf(this.logicalByAddress.values())) {
                for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                    Bookmark pb = lb.getProgramBookmark();
                    if (pb == null) continue;
                    if (pb != this.program.getBookmarkManager().getBookmark(pb.getId())) {
                        this.forgetProgramBreakpoint(r, pb, false);
                        continue;
                    }
                    if (lb.getProgramLocation().getByteAddress().equals((Object)pb.getAddress())) continue;
                    this.forgetProgramBreakpoint(r, pb, false);
                }
            }
        }

        protected void trackAllProgramBreakpoints(AddCollector a) {
            BookmarkManager bookmarks = this.program.getBookmarkManager();
            this.trackProgramBreakpoints(a, IteratorUtils.asIterable((Iterator)bookmarks.getBookmarksIterator("BreakpointEnabled")));
            this.trackProgramBreakpoints(a, IteratorUtils.asIterable((Iterator)bookmarks.getBookmarksIterator("BreakpointDisabled")));
        }

        protected void trackProgramBreakpoints(AddCollector a, Iterable<Bookmark> bptMarks) {
            for (Bookmark pb : bptMarks) {
                this.trackProgramBreakpoint(a, pb);
            }
        }

        protected void trackProgramBreakpoint(AddCollector a, Bookmark pb) {
            LogicalBreakpointInternal lb = this.getOrCreateLogicalBreakpointFor(a, pb);
            assert (((Set)this.logicalByAddress.get(pb.getAddress())).contains(lb));
            if (lb.trackBreakpoint(pb)) {
                a.updated(lb);
            }
        }

        protected void forgetProgramBreakpoint(RemoveCollector r, Bookmark pb, boolean forChange) {
            LogicalBreakpointInternal lb = this.removeFromLogicalBreakpoint(r, pb, forChange);
            if (lb == null) {
                return;
            }
            assert (this.isConsistentAfterRemoval(pb, lb, forChange));
        }

        private boolean isConsistentAfterRemoval(Bookmark pb, LogicalBreakpointInternal lb, boolean forChange) {
            Set present = (Set)this.logicalByAddress.get(pb.getAddress());
            boolean shouldBeAbsent = lb.isEmpty() && !forChange;
            boolean isAbsent = present == null || !present.contains(lb);
            return shouldBeAbsent == isAbsent;
        }
    }

    private static class AddCollector
    implements AutoCloseable {
        private final LogicalBreakpointsChangeListener l;
        private final Set<LogicalBreakpoint> added = new HashSet<LogicalBreakpoint>();
        private final Set<LogicalBreakpoint> updated;

        public AddCollector(LogicalBreakpointsChangeListener l, Set<LogicalBreakpoint> updated) {
            this.l = l;
            this.updated = updated;
        }

        protected void added(LogicalBreakpoint lb) {
            this.added.add(lb);
        }

        protected void updated(LogicalBreakpoint lb) {
            this.updated.add(lb);
        }

        protected void deconflict() {
            this.updated.removeAll(this.added);
        }

        @Override
        public void close() {
            this.deconflict();
            if (!this.updated.isEmpty()) {
                this.l.breakpointsUpdated(this.updated);
            }
            if (!this.added.isEmpty()) {
                this.l.breakpointsAdded(this.added);
            }
        }
    }

    protected abstract class AbstractInfo {
        final NavigableMap<Address, Set<LogicalBreakpointInternal>> logicalByAddress = new TreeMap<Address, Set<LogicalBreakpointInternal>>();

        protected abstract void dispose(RemoveCollector var1);

        protected abstract LogicalBreakpointInternal createLogicalBreakpoint(Address var1, long var2, Collection<TraceBreakpointKind> var4);

        protected LogicalBreakpointInternal getOrCreateLogicalBreakpointFor(AddCollector a, Address address, TraceBreakpointLocation tb, long snap) throws TrackedTooSoonException {
            Set set = this.logicalByAddress.computeIfAbsent(address, __ -> new HashSet());
            for (LogicalBreakpointInternal lb : set) {
                if (!lb.canMerge(tb, snap)) continue;
                return lb;
            }
            LogicalBreakpointInternal lb = this.createLogicalBreakpoint(address, tb.getLength(snap), tb.getKinds(snap));
            set.add(lb);
            a.added(lb);
            return lb;
        }

        protected boolean removeLogicalBreakpoint(Address address, LogicalBreakpoint lb) {
            for (TraceBreakpointLocation tb : lb.getTraceBreakpoints()) {
                InfoPerTrace info = DebuggerLogicalBreakpointServicePlugin.this.traceInfos.get(tb.getTrace());
                if (info == null) continue;
                info.logicalByBreakpoint.remove(tb);
            }
            Set set = (Set)this.logicalByAddress.get(address);
            if (set == null) {
                return false;
            }
            if (!set.remove(lb)) {
                return false;
            }
            if (set.isEmpty()) {
                this.logicalByAddress.remove(address);
            }
            return true;
        }

        protected boolean isMismapped(LogicalBreakpointInternal lb) {
            if (!(lb instanceof MappedLogicalBreakpoint)) {
                return false;
            }
            HashSet extraneous = new HashSet(lb.getMappedTraces());
            extraneous.removeAll(DebuggerLogicalBreakpointServicePlugin.this.traceInfos.keySet());
            if (!extraneous.isEmpty()) {
                return true;
            }
            for (InfoPerTrace ti : DebuggerLogicalBreakpointServicePlugin.this.traceInfos.values()) {
                TraceLocation loc = ti.toDynamicLocation(lb.getProgramLocation());
                if (!(loc == null ? lb.getTraceAddress(ti.trace) != null : !loc.getAddress().equals((Object)lb.getTraceAddress(ti.trace)))) continue;
                return true;
            }
            return false;
        }

        protected void forgetMismappedBreakpoints(RemoveCollector r, Set<Trace> additionalTraces, Set<Program> additionalPrograms) {
            for (Set set : List.copyOf(this.logicalByAddress.values())) {
                for (LogicalBreakpointInternal lb : Set.copyOf(set)) {
                    if (!this.isMismapped(lb)) continue;
                    DebuggerLogicalBreakpointServicePlugin.this.removeLogicalBreakpointGlobally(lb);
                    r.removed(lb);
                    additionalTraces.addAll(lb.getParticipatingTraces());
                }
            }
        }
    }

    static interface EmuBreakpointConsumer {
        public void accept(BreakpointActionSet var1, TraceBreakpointLocation var2, long var3);
    }

    static interface TargetBreakpointConsumer {
        public void accept(BreakpointActionSet var1, Target var2, TraceBreakpointLocation var3);
    }

    static interface ProgramBreakpointConsumer {
        public void accept(LogicalBreakpoint var1);
    }

    private class ProgramBreakpointsListener
    extends TraceDomainObjectListener {
        private final InfoPerProgram info;
        private ChangeCollector c;

        public ProgramBreakpointsListener(InfoPerProgram info) {
            this.info = info;
            this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, e -> this.objectRestored());
            this.listenForUntyped((EventType)ProgramEvent.BOOKMARK_ADDED, this.onBreakpoint(this::breakpointBookmarkAdded));
            this.listenForUntyped((EventType)ProgramEvent.BOOKMARK_CHANGED, this.onBreakpoint(this::breakpointBookmarkChanged));
            this.listenForUntyped((EventType)ProgramEvent.BOOKMARK_REMOVED, this.onBreakpoint(this::breakpointBookmarkDeleted));
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> {
                this.c = c;
                super.domainObjectChanged(ev);
                this.c = null;
            }, "program-domainObjectChanged");
        }

        private void objectRestored() {
            this.info.reloadBreakpoints(this.c);
        }

        private Consumer<DomainObjectChangeRecord> onBreakpoint(Consumer<Bookmark> handler) {
            return rec -> {
                ProgramChangeRecord pcrec = (ProgramChangeRecord)rec;
                Bookmark pb = (Bookmark)pcrec.getObject();
                String bmType = pb.getTypeString();
                if ("BreakpointEnabled".equals(bmType) || "BreakpointDisabled".equals(bmType)) {
                    handler.accept(pb);
                }
            };
        }

        private void breakpointBookmarkAdded(Bookmark pb) {
            this.info.trackProgramBreakpoint(this.c.a, pb);
        }

        private void breakpointBookmarkChanged(Bookmark pb) {
            this.breakpointBookmarkDeleted(pb, true);
            this.breakpointBookmarkAdded(pb);
        }

        private void breakpointBookmarkDeleted(Bookmark pb) {
            this.breakpointBookmarkDeleted(pb, false);
        }

        private void breakpointBookmarkDeleted(Bookmark pb, boolean forChange) {
            this.info.forgetProgramBreakpoint(this.c.r, pb, forChange);
        }
    }

    private class TraceBreakpointsListener
    extends TraceDomainObjectListener {
        private final InfoPerTrace info;
        private ChangeCollector c;

        public TraceBreakpointsListener(InfoPerTrace info) {
            this.info = info;
            this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, e -> this.objectRestored());
            this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_ADDED, this::breakpointAdded);
            this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_CHANGED, this::breakpointChanged);
            this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_LIFESPAN_CHANGED, this::breakpointLifespanChanged);
            this.listenFor((TraceEvent)TraceEvents.BREAKPOINT_DELETED, this::breakpointDeleted);
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            DebuggerLogicalBreakpointServicePlugin.this.processChange(c -> {
                this.c = c;
                super.domainObjectChanged(ev);
                this.c = null;
            }, "trace-domainObjectChanged");
        }

        private void objectRestored() {
            this.info.reloadBreakpoints(this.c);
        }

        private void breakpointAdded(TraceBreakpointLocation tb) {
            if (!tb.isValid(this.info.snap)) {
                return;
            }
            try {
                this.info.trackTraceBreakpoint(this.c.a, tb, DebuggerLogicalBreakpointServicePlugin.this.getMode(this.info.trace), false);
            }
            catch (TrackedTooSoonException e) {
                Msg.info((Object)((Object)this), (Object)("Ignoring " + String.valueOf(tb) + " added until service has finished loading its trace"));
            }
        }

        private void breakpointChanged(TraceBreakpointLocation tb) {
            if (!tb.isValid(this.info.snap)) {
                return;
            }
            try {
                this.info.trackTraceBreakpoint(this.c.a, tb, DebuggerLogicalBreakpointServicePlugin.this.getMode(this.info.trace), true);
            }
            catch (TrackedTooSoonException e) {
                Msg.info((Object)((Object)this), (Object)("Ignoring " + String.valueOf(tb) + " changed until service has finished loading its trace"));
            }
            catch (NoSuchElementException e) {
                Msg.error((Object)((Object)this), (Object)("!!!! Object-based breakpoint emitted event without a spec: " + String.valueOf(tb)));
            }
        }

        private void breakpointLifespanChanged(AddressSpace spaceIsNull, TraceBreakpointLocation tb, Lifespan oldSpan, Lifespan newSpan) {
            boolean isInNew;
            boolean isInOld = oldSpan.contains(this.info.snap);
            if (isInOld == (isInNew = newSpan.contains(this.info.snap))) {
                return;
            }
            if (isInOld) {
                this.info.forgetTraceBreakpoint(this.c.r, tb);
            } else {
                try {
                    this.info.trackTraceBreakpoint(this.c.a, tb, DebuggerLogicalBreakpointServicePlugin.this.getMode(this.info.trace), false);
                }
                catch (TrackedTooSoonException e) {
                    Msg.info((Object)((Object)this), (Object)("Ignoring " + String.valueOf(tb) + " span changed until service has finished loading its trace"));
                }
            }
        }

        private void breakpointDeleted(TraceBreakpointLocation tb) {
            this.info.forgetTraceBreakpoint(this.c.r, tb);
        }
    }
}

