/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AbstractDemanglerAnalyzer;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.MangledContext;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.SwiftDemanglerOptions;
import ghidra.app.util.demangler.swift.SwiftNativeDemangler;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class SwiftDemanglerAnalyzer
extends AbstractDemanglerAnalyzer {
    private static final String NAME = "Demangler Swift";
    private static final String DESCRIPTION = "Demangles Swift symbols and applies appropriate datatype and calling conventions where possible. Requires Swift to be installed.";
    private static final String OPTION_NAME_SWIFT_DIR = "Swift binary directory";
    private static final String OPTION_DESCRIPTION_SWIFT_DIR = "Path to the Swift installation binary directory, if not on PATH";
    private static final String OPTION_NAME_INCOMPLETE_PREFIX = "Use incomplete demangle label prefix (%s)".formatted("$");
    private static final String OPTION_DESCRIPTION_INCOMPLETE_PREFIX = "Prefix incomplete demangled labels with '%s'".formatted("$");
    private static final String OPTION_NAME_UNSUPPORTED_PREFIX = "Use unsupported demangle label prefix (%s)".formatted("$$");
    private static final String OPTION_DESCRIPTION_UNSUPPORTED_PREFIX = "Prefix unsupported demangled labels with '%s'".formatted("$$");
    private File swiftDir;
    private boolean useIncompletePrefix = true;
    private boolean useUnsupportedPrefix = true;

    public SwiftDemanglerAnalyzer() {
        super(NAME, DESCRIPTION);
        this.demangler = new SwiftDemangler();
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        return this.demangler.canDemangle(program);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            ((SwiftDemangler)this.demangler).initialize(program);
        }
        catch (IOException e) {
            log.appendMsg(e.getMessage());
            return false;
        }
        return super.added(program, set, monitor, log);
    }

    protected DemangledObject doDemangle(MangledContext mangledContext, MessageLog log) throws DemangledException {
        return this.demangler.demangle(mangledContext);
    }

    public void registerOptions(Options options, Program program) {
        HelpLocation help = new HelpLocation("AutoAnalysisPlugin", "Demangler_Analyzer");
        options.registerOption(OPTION_NAME_SWIFT_DIR, OptionType.FILE_TYPE, (Object)this.swiftDir, help, OPTION_DESCRIPTION_SWIFT_DIR);
        options.registerOption(OPTION_NAME_INCOMPLETE_PREFIX, OptionType.BOOLEAN_TYPE, (Object)this.useIncompletePrefix, help, OPTION_DESCRIPTION_INCOMPLETE_PREFIX);
        options.registerOption(OPTION_NAME_UNSUPPORTED_PREFIX, OptionType.BOOLEAN_TYPE, (Object)this.useUnsupportedPrefix, help, OPTION_DESCRIPTION_UNSUPPORTED_PREFIX);
    }

    protected boolean validateOptions(DemanglerOptions options, MessageLog log) {
        if (options instanceof SwiftDemanglerOptions) {
            SwiftDemanglerOptions swiftDemanglerOptions = (SwiftDemanglerOptions)options;
            try {
                new SwiftNativeDemangler(swiftDemanglerOptions.getSwiftDir());
                return true;
            }
            catch (IOException e) {
                log.appendMsg(e.getMessage());
                log.appendMsg("You must have Swift installed to demangle Swift symbols.\nSee the \"Demangler Swift\" analyzer options to configure.");
            }
        }
        return false;
    }

    public void optionsChanged(Options options, Program program) {
        this.swiftDir = options.getFile(OPTION_NAME_SWIFT_DIR, this.swiftDir);
        this.useIncompletePrefix = options.getBoolean(OPTION_NAME_INCOMPLETE_PREFIX, this.useIncompletePrefix);
        this.useUnsupportedPrefix = options.getBoolean(OPTION_NAME_UNSUPPORTED_PREFIX, this.useUnsupportedPrefix);
    }

    protected DemanglerOptions getOptions() {
        SwiftDemanglerOptions swiftDemanglerOptions = new SwiftDemanglerOptions();
        swiftDemanglerOptions.setSwiftDir(this.swiftDir);
        swiftDemanglerOptions.setIncompletePrefix(this.useIncompletePrefix);
        swiftDemanglerOptions.setUnsupportedPrefix(this.useUnsupportedPrefix);
        return swiftDemanglerOptions;
    }
}

