/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder.instruction;

import javax.annotation.Nonnull;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction11n;
import org.jf.dexlib2.util.Preconditions;

public class BuilderInstruction11n
extends BuilderInstruction
implements Instruction11n {
    public static final Format FORMAT = Format.Format11n;
    protected final int registerA;
    protected final int literal;

    public BuilderInstruction11n(@Nonnull Opcode opcode, int registerA, int literal) {
        super(opcode);
        this.registerA = Preconditions.checkNibbleRegister(registerA);
        this.literal = Preconditions.checkNibbleLiteral(literal);
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getNarrowLiteral() {
        return this.literal;
    }

    @Override
    public long getWideLiteral() {
        return this.literal;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

