/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import java.util.HashMap;
import java.util.Map;

class EncodedStringsFilterStats {
    int total;
    int codecErrors;
    int nonStdCtrlChars;
    int failedStringModel;
    int stringLength;
    int requiredScripts;
    int otherScripts;
    int latinScript;
    int commonScript;
    Map<Character.UnicodeScript, Integer> foundScriptCounts = new HashMap<Character.UnicodeScript, Integer>();

    public EncodedStringsFilterStats() {
    }

    public EncodedStringsFilterStats(EncodedStringsFilterStats other) {
        this.total = other.total;
        this.codecErrors = other.codecErrors;
        this.nonStdCtrlChars = other.nonStdCtrlChars;
        this.failedStringModel = other.failedStringModel;
        this.stringLength = other.stringLength;
        this.requiredScripts = other.requiredScripts;
        this.otherScripts = other.otherScripts;
        this.latinScript = other.latinScript;
        this.commonScript = other.commonScript;
        this.foundScriptCounts.putAll(other.foundScriptCounts);
    }

    int getTotalForAdvancedOptions() {
        return this.codecErrors + this.nonStdCtrlChars + this.failedStringModel + this.stringLength;
    }

    int getTotalOmitted() {
        return this.codecErrors + this.nonStdCtrlChars + this.failedStringModel + this.stringLength + this.requiredScripts;
    }

    public EncodedStringsFilterStats clone() {
        return new EncodedStringsFilterStats(this);
    }
}

