/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.widgets.VariableHeightPanel;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GDLabel;
import generic.theme.GIcon;
import ghidra.app.plugin.core.diff.DiffApplySettingsOptionManager;
import ghidra.app.plugin.core.diff.DiffIgnoreAllAction;
import ghidra.app.plugin.core.diff.DiffMergeAllAction;
import ghidra.app.plugin.core.diff.DiffReplaceAllAction;
import ghidra.app.plugin.core.diff.ProgramDiffPlugin;
import ghidra.app.plugin.core.diff.SaveApplySettingsAction;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.util.ProgramMergeFilter;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DiffApplySettingsProvider
extends ComponentProviderAdapter {
    public static final String APPLY_FILTER_CHANGED_ACTION = "Apply Filter Changed";
    public static final Icon ICON = new GIcon("icon.plugin.programdiff.settings");
    public static final String TITLE = "Diff Apply Settings";
    private ProgramDiffPlugin plugin;
    private ArrayList<Choice> choices;
    private Choice programContextCB;
    private Choice bytesCB;
    private Choice codeUnitsCB;
    private Choice refsCB;
    private SymbolsChoice symbolsCB;
    private Choice plateCommentsCB;
    private Choice preCommentsCB;
    private Choice eolCommentsCB;
    private Choice repeatableCommentsCB;
    private Choice postCommentsCB;
    private Choice bookmarksCB;
    private Choice propertiesCB;
    private Choice functionsCB;
    private Choice functionTagsCB;
    private Choice sourceMapCB;
    private int applyProgramContext;
    private int applyBytes;
    private int applyCodeUnits;
    private int applyReferences;
    private int applyPlateComments;
    private int applyPreComments;
    private int applyEolComments;
    private int applyRepeatableComments;
    private int applyPostComments;
    private int applySymbols;
    private int applyBookmarks;
    private int applyProperties;
    private int applyFunctions;
    private int applyFunctionTags;
    private int applySourceMap;
    private int replacePrimary;
    private ProgramMergeFilter applyFilter;
    private boolean adjustingApplyFilter = false;
    private JComponent applyPanel;
    private ArrayList<ActionListener> listenerList = new ArrayList();
    private boolean pgmContextEnabled = true;

    public DiffApplySettingsProvider(ProgramDiffPlugin plugin) {
        super(plugin.getTool(), TITLE, plugin.getName());
        this.plugin = plugin;
        this.setIcon(ICON);
        this.setWindowMenuGroup("Diff");
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setTransient();
        this.setHelpLocation(new HelpLocation("Diff", "Diff_Apply_Settings"));
        this.applyPanel = this.createApplyFilterPanel();
        this.applyPanel.setName("Diff Apply Settings Panel");
    }

    public void configure(ProgramMergeFilter apply) {
        this.setApplyFilter(apply);
    }

    public void addActions() {
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)new SaveApplySettingsAction(this, this.plugin.applySettingsMgr));
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)new DiffIgnoreAllAction(this));
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)new DiffReplaceAllAction(this));
        this.plugin.getTool().addLocalAction((ComponentProvider)this, (DockingActionIf)new DiffMergeAllAction(this));
    }

    private void createChoices() {
        this.choices = new ArrayList();
        this.programContextCB = new Choice("Program Context", false);
        this.programContextCB.addActionListener(e -> {
            this.applyProgramContext = this.programContextCB.getSelectedIndex();
            this.applyFilter.setFilter(1, this.applyProgramContext);
            this.applyFilterChanged();
        });
        this.choices.add(this.programContextCB);
        this.bytesCB = new Choice("Bytes", false);
        this.bytesCB.addActionListener(e -> {
            this.applyBytes = this.bytesCB.getSelectedIndex();
            this.applyFilter.setFilter(2, this.applyBytes);
            this.applyFilterChanged();
        });
        this.choices.add(this.bytesCB);
        this.codeUnitsCB = new Choice("Code Units", false);
        this.codeUnitsCB.addActionListener(e -> {
            this.applyCodeUnits = this.codeUnitsCB.getSelectedIndex();
            this.applyFilter.setFilter(16396, this.applyCodeUnits);
            this.applyFilterChanged();
        });
        this.choices.add(this.codeUnitsCB);
        this.refsCB = new Choice("References", false);
        this.refsCB.addActionListener(e -> {
            this.applyReferences = this.refsCB.getSelectedIndex();
            this.applyFilter.setFilter(16, this.applyReferences);
            this.applyFilterChanged();
        });
        this.choices.add(this.refsCB);
        this.plateCommentsCB = new Choice("Comments, Plate", true);
        this.plateCommentsCB.addActionListener(e -> {
            this.applyPlateComments = this.plateCommentsCB.getSelectedIndex();
            this.applyFilter.setFilter(32, this.applyPlateComments);
            this.applyFilterChanged();
        });
        this.choices.add(this.plateCommentsCB);
        this.preCommentsCB = new Choice("Comments, Pre", true);
        this.preCommentsCB.addActionListener(e -> {
            this.applyPreComments = this.preCommentsCB.getSelectedIndex();
            this.applyFilter.setFilter(64, this.applyPreComments);
            this.applyFilterChanged();
        });
        this.choices.add(this.preCommentsCB);
        this.eolCommentsCB = new Choice("Comments, EOL", true);
        this.eolCommentsCB.addActionListener(e -> {
            this.applyEolComments = this.eolCommentsCB.getSelectedIndex();
            this.applyFilter.setFilter(128, this.applyEolComments);
            this.applyFilterChanged();
        });
        this.choices.add(this.eolCommentsCB);
        this.repeatableCommentsCB = new Choice("Comments, Repeatable", true);
        this.repeatableCommentsCB.addActionListener(e -> {
            this.applyRepeatableComments = this.repeatableCommentsCB.getSelectedIndex();
            this.applyFilter.setFilter(256, this.applyRepeatableComments);
            this.applyFilterChanged();
        });
        this.choices.add(this.repeatableCommentsCB);
        this.postCommentsCB = new Choice("Comments, Post", true);
        this.postCommentsCB.addActionListener(e -> {
            this.applyPostComments = this.postCommentsCB.getSelectedIndex();
            this.applyFilter.setFilter(512, this.applyPostComments);
            this.applyFilterChanged();
        });
        this.choices.add(this.postCommentsCB);
        this.symbolsCB = new SymbolsChoice();
        this.symbolsCB.addActionListener(e -> {
            DiffApplySettingsOptionManager.SYMBOL_MERGE_CHOICE symbols = DiffApplySettingsOptionManager.SYMBOL_MERGE_CHOICE.values()[this.symbolsCB.getSelectedIndex()];
            DiffApplySettingsOptionManager.MERGE_CHOICE merge = this.plugin.applySettingsMgr.convertSymbolMergeChoiceToMergeChoice(symbols);
            DiffApplySettingsOptionManager.REPLACE_CHOICE primary = this.plugin.applySettingsMgr.convertSymbolMergeChoiceToReplaceChoiceForPrimay(symbols);
            this.applySymbols = merge.ordinal();
            this.replacePrimary = primary.ordinal();
            this.applyFilter.setFilter(1024, this.applySymbols);
            this.applyFilter.setFilter(32768, this.replacePrimary);
            this.applyFilterChanged();
        });
        this.choices.add(this.symbolsCB);
        this.bookmarksCB = new Choice("Bookmarks", false);
        this.bookmarksCB.addActionListener(e -> {
            this.applyBookmarks = this.bookmarksCB.getSelectedIndex();
            this.applyFilter.setFilter(2048, this.applyBookmarks);
            this.applyFilterChanged();
        });
        this.choices.add(this.bookmarksCB);
        this.propertiesCB = new Choice("Properties", false);
        this.propertiesCB.addActionListener(e -> {
            this.applyProperties = this.propertiesCB.getSelectedIndex();
            this.applyFilter.setFilter(4096, this.applyProperties);
            this.applyFilterChanged();
        });
        this.choices.add(this.propertiesCB);
        this.functionsCB = new Choice("Functions", false);
        this.functionsCB.addActionListener(e -> {
            this.applyFunctions = this.functionsCB.getSelectedIndex();
            this.applyFilter.setFilter(8192, this.applyFunctions);
            this.applyFilterChanged();
        });
        this.choices.add(this.functionsCB);
        this.functionTagsCB = new Choice("Function Tags", true);
        this.functionTagsCB.addActionListener(e -> {
            this.applyFunctionTags = this.functionTagsCB.getSelectedIndex();
            this.applyFilter.setFilter(65536, this.applyFunctionTags);
            this.applyFilterChanged();
        });
        this.choices.add(this.functionTagsCB);
        this.sourceMapCB = new Choice("Source Map", false);
        if (!this.plugin.getFirstProgram().hasExclusiveAccess()) {
            this.sourceMapCB.setSelectedIndex(0);
        }
        this.sourceMapCB.addActionListener(e -> {
            this.applySourceMap = this.sourceMapCB.getSelectedIndex();
            if (!this.plugin.getFirstProgram().hasExclusiveAccess() && this.applySourceMap != 0) {
                Msg.showWarn((Object)((Object)this), null, (String)"Exclusive Access Required", (Object)"Exclusive access required to change source map information");
                this.sourceMapCB.setSelectedIndex(0);
                this.applySourceMap = 0;
            }
            this.applyFilter.setFilter(131072, this.applySourceMap);
            this.applyFilterChanged();
        });
        this.choices.add(this.sourceMapCB);
        int maxLabelWidth = 0;
        int maxComboWidth = 0;
        for (Choice choice : this.choices) {
            maxLabelWidth = Math.max(maxLabelWidth, choice.label.getPreferredSize().width);
            maxComboWidth = Math.max(maxComboWidth, choice.applyCB.getPreferredSize().width);
        }
        for (Choice choice : this.choices) {
            int height = choice.label.getPreferredSize().height;
            choice.label.setPreferredSize(new Dimension(maxLabelWidth, height));
            height = choice.applyCB.getPreferredSize().height;
            choice.applyCB.setPreferredSize(new Dimension(maxComboWidth, height));
        }
        Collections.sort(this.choices);
    }

    private JComponent createApplyFilterPanel() {
        this.createChoices();
        VariableHeightPanel panel = new VariableHeightPanel(false, 10, 3);
        panel.setToolTipText("<html>For each difference type, select whether to ignore, replace, or merge.<BR>&nbsp&nbsp<B>Ignore</B> - don't apply this type of difference.<BR>&nbsp&nbsp<B>Replace</B> - replace the difference type with the one from program 2.<BR>&nbsp&nbsp<B>Merge</B> - merge the difference type from program 2 with what's there.</HTML>");
        for (Choice choice : this.choices) {
            panel.add((Component)choice);
        }
        return new JScrollPane((Component)panel);
    }

    private void adjustApplyFilter() {
        try {
            this.adjustingApplyFilter = true;
            this.programContextCB.setSelectedIndex(this.applyProgramContext);
            this.bytesCB.setSelectedIndex(this.applyBytes);
            this.codeUnitsCB.setSelectedIndex(this.applyCodeUnits);
            this.refsCB.setSelectedIndex(this.applyReferences);
            this.plateCommentsCB.setSelectedIndex(this.applyPlateComments);
            this.preCommentsCB.setSelectedIndex(this.applyPreComments);
            this.eolCommentsCB.setSelectedIndex(this.applyEolComments);
            this.repeatableCommentsCB.setSelectedIndex(this.applyRepeatableComments);
            this.postCommentsCB.setSelectedIndex(this.applyPostComments);
            int symbolsIndex = this.plugin.applySettingsMgr.convertFiltersToSymbolIndex(this.applySymbols, this.replacePrimary);
            this.symbolsCB.setSelectedIndex(symbolsIndex);
            this.bookmarksCB.setSelectedIndex(this.applyBookmarks);
            this.propertiesCB.setSelectedIndex(this.applyProperties);
            this.functionsCB.setSelectedIndex(this.applyFunctions);
            this.functionTagsCB.setSelectedIndex(this.applyFunctionTags);
            this.sourceMapCB.setSelectedIndex(this.applySourceMap);
        }
        finally {
            this.adjustingApplyFilter = false;
            this.applyFilterChanged();
        }
    }

    void setPgmContextEnabled(boolean enable) {
        this.pgmContextEnabled = enable;
        if (!this.pgmContextEnabled) {
            this.applyProgramContext = 0;
            this.programContextCB.setSelectedIndex(this.applyProgramContext);
        }
    }

    ProgramMergeFilter getApplyFilter() {
        return new ProgramMergeFilter(this.applyFilter);
    }

    void setApplyFilter(ProgramMergeFilter filter) {
        this.applyFilter = new ProgramMergeFilter(filter);
        this.applyProgramContext = this.applyFilter.getFilter(1);
        this.applyBytes = this.applyFilter.getFilter(2);
        this.applyCodeUnits = Math.max(this.applyFilter.getFilter(4), this.applyFilter.getFilter(8));
        this.applyFilter.setFilter(12, this.applyCodeUnits);
        this.applyReferences = this.applyFilter.getFilter(16);
        this.applyPlateComments = this.applyFilter.getFilter(32);
        this.applyPreComments = this.applyFilter.getFilter(64);
        this.applyEolComments = this.applyFilter.getFilter(128);
        this.applyRepeatableComments = this.applyFilter.getFilter(256);
        this.applyPostComments = this.applyFilter.getFilter(512);
        this.applySymbols = this.applyFilter.getFilter(1024);
        this.applyBookmarks = this.applyFilter.getFilter(2048);
        this.applyProperties = this.applyFilter.getFilter(4096);
        this.applyFunctions = this.applyFilter.getFilter(8192);
        this.applyFunctionTags = this.applyFilter.getFilter(65536);
        this.replacePrimary = this.applyFilter.getFilter(32768);
        this.applySourceMap = this.applyFilter.getFilter(131072);
        this.adjustApplyFilter();
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(listener);
    }

    boolean hasApplySelection() {
        return (this.applyProgramContext | this.applyBytes | this.applyCodeUnits | this.applyReferences | this.applyPlateComments | this.applyPreComments | this.applyEolComments | this.applyRepeatableComments | this.applyPostComments | this.applySymbols | this.applyBookmarks | this.applyProperties | this.applyFunctions | this.applyFunctionTags) != 0;
    }

    protected void applyFilterChanged() {
        if (this.adjustingApplyFilter) {
            return;
        }
        for (ActionListener listener : this.listenerList) {
            listener.actionPerformed(new ActionEvent((Object)this, 0, APPLY_FILTER_CHANGED_ACTION));
        }
    }

    public void closeComponent() {
        this.plugin.getTool().showComponentProvider((ComponentProvider)this, false);
    }

    public JComponent getComponent() {
        return this.applyPanel;
    }

    Plugin getPlugin() {
        return this.plugin;
    }

    class Choice
    extends JPanel
    implements Comparable<Choice> {
        private static final long serialVersionUID = 1L;
        String type;
        boolean allowMerge;
        JLabel label;
        JComboBox<Enum<?>> applyCB;

        public Choice(String type, boolean allowMerge) {
            this.setLayout(new BorderLayout());
            this.type = type;
            this.allowMerge = allowMerge;
            this.init();
        }

        protected void init() {
            this.applyCB = new GComboBox((Object[])(this.allowMerge ? DiffApplySettingsOptionManager.MERGE_CHOICE.values() : DiffApplySettingsOptionManager.REPLACE_CHOICE.values()));
            this.applyCB.setName(this.type + " Diff Apply CB");
            this.label = new GDLabel(" " + this.type + " ");
            this.label.setHorizontalAlignment(4);
            this.add(this.applyCB, "East");
            this.add((Component)this.label, "Center");
        }

        void setSelectedIndex(int index) {
            this.applyCB.setSelectedIndex(index);
        }

        int getSelectedIndex() {
            return this.applyCB.getSelectedIndex();
        }

        public void addActionListener(ActionListener listener) {
            this.applyCB.addActionListener(listener);
        }

        public void removeActionListener(ActionListener listener) {
            this.applyCB.removeActionListener(listener);
        }

        void setLabelSize(Dimension preferredSize) {
            this.label.setPreferredSize(preferredSize);
        }

        void setComboSize(Dimension preferredSize) {
            this.applyCB.setPreferredSize(preferredSize);
        }

        @Override
        public int compareTo(Choice o) {
            return this.type.compareTo(o.type);
        }
    }

    class SymbolsChoice
    extends Choice {
        private static final long serialVersionUID = 1L;

        public SymbolsChoice() {
            super("Labels", true);
        }

        @Override
        protected void init() {
            this.applyCB = new GComboBox((Object[])DiffApplySettingsOptionManager.SYMBOL_MERGE_CHOICE.values());
            this.applyCB.setName(this.type + " Diff Apply CB");
            this.label = new GDLabel(" " + this.type + " ");
            this.label.setHorizontalAlignment(4);
            this.add((Component)this.applyCB, "East");
            this.add((Component)this.label, "Center");
        }
    }
}

