/*
 * Decompiled with CFR 0.152.
 */
package ghidra.asm.wild.tree;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseToken;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class WildAssemblyParseToken
extends AssemblyParseToken {
    public final Wildcard wild;

    public WildAssemblyParseToken(AssemblyGrammar grammar, AssemblyTerminal term, String str, String spec) {
        super(grammar, term, str);
        this.wild = Wildcard.parse(spec);
    }

    public String wildcardName() {
        return this.wild.name();
    }

    public static interface Wildcard {
        public static Wildcard parse(String spec) {
            Matcher matRegex = RegexWildcard.PATTERN.matcher(spec);
            if (matRegex.matches()) {
                return RegexWildcard.get(matRegex);
            }
            Matcher matNumeric = NumericWildcard.PATTERN.matcher(spec);
            if (matNumeric.matches()) {
                return NumericWildcard.get(matNumeric);
            }
            Matcher matRanges = RangesWildcard.PATTERN.matcher(spec);
            if (matRanges.matches()) {
                return RangesWildcard.get(matRanges);
            }
            return new FreeWildcard(spec);
        }

        public String name();

        public boolean test(Object var1);
    }

    public record RangesWildcard(String name, List<WildRange> ranges) implements Wildcard
    {
        public static final Pattern PATTERN = Pattern.compile("(?<name>[^\\[]*)\\[(?<ranges>[^\\]]*)\\]");

        public static RangesWildcard get(Matcher matcher) {
            return new RangesWildcard(matcher.group("name"), RangesWildcard.parseRanges(matcher.group("ranges")));
        }

        public static List<WildRange> parseRanges(String str) {
            return Stream.of(str.split(",")).map(WildRange::parse).sorted().toList();
        }

        static long getLong(Object a) {
            if (a instanceof Number) {
                Number n = (Number)a;
                return n.longValue();
            }
            if (a instanceof WildRange) {
                WildRange range = (WildRange)a;
                return range.min;
            }
            throw new AssertionError();
        }

        static int searchComp(Object a, Object b) {
            return Long.compare(RangesWildcard.getLong(a), RangesWildcard.getLong(b));
        }

        public LongStream stream() {
            return this.ranges.stream().flatMapToLong(i -> i.stream());
        }

        @Override
        public boolean test(Object object) {
            if (!(object instanceof Number)) {
                return false;
            }
            Number n = (Number)object;
            long lv = n.longValue();
            int i = Collections.binarySearch(this.ranges, lv, RangesWildcard::searchComp);
            if (i >= 0) {
                return true;
            }
            if ((i = -i - 2) < 0) {
                return false;
            }
            return lv <= this.ranges.get((int)i).max;
        }
    }

    public record WildRange(long min, long max) implements Comparable<WildRange>
    {
        public WildRange {
            if (min > max) {
                throw new AssertionError((Object)"max > max");
            }
        }

        public static WildRange parse(String str) {
            String[] parts = str.split("\\.\\.");
            if (parts.length == 1) {
                long val = Long.decode(parts[0]);
                return new WildRange(val, val);
            }
            if (parts.length == 2) {
                long min = Long.decode(parts[0]);
                long max = Long.decode(parts[1]);
                return new WildRange(min, max);
            }
            throw new IllegalArgumentException("Invalid range specification in wildcard: " + str);
        }

        public LongStream stream() {
            return LongStream.rangeClosed(this.min, this.max);
        }

        @Override
        public int compareTo(WildRange that) {
            return Long.compare(this.min, that.min);
        }
    }

    public record NumericWildcard(String name) implements Wildcard
    {
        static final Pattern PATTERN = Pattern.compile("(?<name>.*)\\[\\.\\.\\]");

        public static NumericWildcard get(Matcher matcher) {
            return new NumericWildcard(matcher.group("name"));
        }

        @Override
        public boolean test(Object object) {
            return object instanceof Number;
        }
    }

    public record RegexWildcard(String name, Pattern pat) implements Wildcard
    {
        static final Pattern PATTERN = Pattern.compile("(?<name>[^/]*)/(?<regex>.*)");

        public static RegexWildcard get(Matcher matcher) {
            return new RegexWildcard(matcher.group("name"), Pattern.compile(matcher.group("regex")));
        }

        @Override
        public boolean test(Object object) {
            if (!(object instanceof CharSequence)) {
                return false;
            }
            CharSequence cs = (CharSequence)object;
            return this.pat.matcher(cs).matches();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof RegexWildcard)) return false;
            RegexWildcard that = (RegexWildcard)o;
            if (!Objects.equals(this.name, that.name)) return false;
            if (!Objects.equals(this.pat.toString(), that.pat.toString())) return false;
            return true;
        }
    }

    public record FreeWildcard(String name) implements Wildcard
    {
        @Override
        public boolean test(Object object) {
            return true;
        }
    }
}

