---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'ContentfulプレビューAPIトークンの機密シークレットまたはトークンの公開'
---

## 説明 {#description}

ContentfulプレビューAPIトークンのパターンに一致するコンテンツがレスポンス本文に含まれていることが判明しました。プレビューAPIトークンは、Content Delivery API（CDA）と同じ動作とパラメータを維持しますが、エントリとアセットの最新のドラフトを配信します。ContentプレビューAPIは、エントリの最新バージョンを表示するために使用されます。このトークンにアクセスできる悪意のある攻撃者は、公開済みおよび未公開のエントリを表示できます。詳細については、[プレビューAPIドキュメント](https://www.contentful.com/developers/docs/references/content-preview-api/)を参照してください。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

キーの漏洩に関するセキュリティインシデントの取り扱いに関する一般的なガイダンスについては、GitLabドキュメントの[インターネットへの認証情報の公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。

プレビューAPIトークンを失効するには:

- サインインして<https://app.contentful.com/>にアクセスします
- 右上隅にある歯車アイコンを選択し、「APIキー」を選択します
- 検出されたAPIキーを見つけ、APIキーのテーブルで名前を選択します
- 右上隅にある「削除」を選択します
- プロンプトが表示されたら、「削除」を選択します。これにより、配信APIトークンも削除されることに注意してください。

新しいAPIキーのセットを生成する必要があります。

詳細については、[認証に関するデベロッパードキュメント](https://www.contentful.com/developers/docs/references/authentication/#the-content-delivery-and-preview-api)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.133 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
