/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.config;

import java.io.File;
import tim.prune.config.Config;

public class ConfigPaths {
    private static final File OLD_DEFAULT_CURRENT_DIR = new File(".pruneconfig");
    private static final File OLD_DEFAULT_HOME_DIR = new File(System.getProperty("user.home"), ".pruneconfig");
    private static final String NEW_DEFAULT_FILENAME = "gpsprune.config";

    private ConfigPaths() {
    }

    public static File loadConfig(Config config) {
        File file = new File(NEW_DEFAULT_FILENAME);
        if (file.exists() && file.canRead() && config.loadFile(file)) {
            return null;
        }
        if (OLD_DEFAULT_CURRENT_DIR.exists() && OLD_DEFAULT_CURRENT_DIR.canRead() && config.loadFile(OLD_DEFAULT_CURRENT_DIR)) {
            return file;
        }
        File file2 = new File(ConfigPaths.getConfigDir(), NEW_DEFAULT_FILENAME);
        if (file2.exists() && file2.canRead() && config.loadFile(file2)) {
            return null;
        }
        if (OLD_DEFAULT_HOME_DIR.exists() && OLD_DEFAULT_HOME_DIR.canRead() && config.loadFile(OLD_DEFAULT_HOME_DIR)) {
            return file2;
        }
        return null;
    }

    public static File getSuggestedConfigFile() {
        return new File(ConfigPaths.getConfigDir(), NEW_DEFAULT_FILENAME);
    }

    public static String getDefaultFilename() {
        return NEW_DEFAULT_FILENAME;
    }

    private static File getConfigDir() {
        String string = System.getenv("XDG_CONFIG_HOME");
        if (string != null && !string.isEmpty()) {
            return new File(string);
        }
        string = System.getenv("APPDATA");
        if (string != null && !string.isEmpty()) {
            return new File(string, "gpsprune");
        }
        return new File(System.getProperty("user.home"), ".config");
    }
}

