/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes two argument inverse tangent.


The first argument to the atan function is provided by a pixel in the
first input image (SetInput1() ) and the corresponding pixel in the
second input image (SetInput2() ) is used as the second argument.

This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

Both pixel input types are cast to double in order to be used as
parameters of std::atan2() . The resulting double value is cast to the
output pixel type.
See:
 itk::simple::Atan2 for the procedural interface

 itk::Atan2ImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAtan2ImageFilter.h
*/
public class Atan2ImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected Atan2ImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.Atan2ImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Atan2ImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(Atan2ImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::Atan2ImageFilter::~Atan2ImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_Atan2ImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::Atan2ImageFilter::Atan2ImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  Atan2ImageFilter() {
    this(SimpleITKJNI.new_Atan2ImageFilter(), true);
  }

  /**
std::string itk::simple::Atan2ImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.Atan2ImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::Atan2ImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.Atan2ImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::Atan2ImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.Atan2ImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::Atan2ImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(Image image1, double constant) {
    return new Image(SimpleITKJNI.Atan2ImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1, constant), true);
  }

  /**
Image itk::simple::Atan2ImageFilter::Execute(Image &amp;&amp;image1, double constant)
*/
public  Image execute(double constant, Image image2) {
    return new Image(SimpleITKJNI.Atan2ImageFilter_execute__SWIG_2(swigCPtr, this, constant, Image.getCPtr(image2), image2), true);
  }

}
