/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.partialimport.AbstractPartialImport;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class UsersPartialImport
extends AbstractPartialImport<UserRepresentation> {
    private final Map<String, String> createdIds = new HashMap<String, String>();

    @Override
    public List<UserRepresentation> getRepList(PartialImportRepresentation partialImportRep) {
        return partialImportRep.getUsers();
    }

    @Override
    public String getName(UserRepresentation user) {
        if (user.getUsername() != null) {
            return user.getUsername();
        }
        return user.getEmail();
    }

    @Override
    public String getModelId(RealmModel realm, KeycloakSession session, UserRepresentation user) {
        if (this.createdIds.containsKey(this.getName(user))) {
            return this.createdIds.get(this.getName(user));
        }
        String userName = user.getUsername();
        if (userName != null) {
            return session.users().getUserByUsername(realm, userName).getId();
        }
        if (!realm.isDuplicateEmailsAllowed()) {
            String email = user.getEmail();
            return session.users().getUserByEmail(realm, email).getId();
        }
        return null;
    }

    @Override
    public boolean exists(RealmModel realm, KeycloakSession session, UserRepresentation user) {
        return this.userNameExists(realm, session, user) || this.userEmailExists(realm, session, user);
    }

    private boolean userNameExists(RealmModel realm, KeycloakSession session, UserRepresentation user) {
        return session.users().getUserByUsername(realm, user.getUsername()) != null;
    }

    private boolean userEmailExists(RealmModel realm, KeycloakSession session, UserRepresentation user) {
        return user.getEmail() != null && !realm.isDuplicateEmailsAllowed() && session.users().getUserByEmail(realm, user.getEmail()) != null;
    }

    @Override
    public String existsMessage(RealmModel realm, UserRepresentation user) {
        if (user.getEmail() == null || !realm.isDuplicateEmailsAllowed()) {
            return "User with user name " + this.getName(user) + " already exists.";
        }
        return "User with user name " + this.getName(user) + " or with email " + user.getEmail() + " already exists.";
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.USER;
    }

    @Override
    public void remove(RealmModel realm, KeycloakSession session, UserRepresentation user) {
        boolean success;
        UserModel userModel = session.users().getUserByUsername(realm, user.getUsername());
        if (userModel == null && !realm.isDuplicateEmailsAllowed()) {
            userModel = session.users().getUserByEmail(realm, user.getEmail());
        }
        if (userModel != null && !(success = new UserManager(session).removeUser(realm, userModel))) {
            throw new RuntimeException("Unable to overwrite user " + this.getName(user));
        }
    }

    @Override
    public void create(RealmModel realm, KeycloakSession session, UserRepresentation user) {
        UserModel userModel;
        if (user.getId() == null) {
            user.setId(KeycloakModelUtils.generateId());
        }
        if ((userModel = RepresentationToModel.createUser((KeycloakSession)session, (RealmModel)realm, (UserRepresentation)user)) == null) {
            throw new RuntimeException("Unable to create user " + this.getName(user));
        }
        this.createdIds.put(this.getName(user), userModel.getId());
    }
}

