/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorAggregator;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.type.CompositeType;

@Internal
public class CompositeNestedGeneratedValueGenerator
implements IdentifierGenerator,
IdentifierGeneratorAggregator,
Serializable {
    private final GenerationContextLocator generationContextLocator;
    private final CompositeType compositeType;
    private final List<GenerationPlan> generationPlans = new ArrayList<GenerationPlan>();

    public CompositeNestedGeneratedValueGenerator(GenerationContextLocator generationContextLocator, CompositeType compositeType) {
        this.generationContextLocator = generationContextLocator;
        this.compositeType = compositeType;
    }

    public CompositeNestedGeneratedValueGenerator(GenerationContextLocator generationContextLocator, CompositeType compositeType, List<GenerationPlan> generationPlans) {
        this.generationContextLocator = generationContextLocator;
        this.compositeType = compositeType;
        this.generationPlans.addAll(generationPlans);
    }

    public void addGeneratedValuePlan(GenerationPlan plan) {
        this.generationPlans.add(plan);
    }

    @Override
    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        Object context = this.generationContextLocator.locateGenerationContext(session, object);
        ArrayList<Object> generatedValues = this.compositeType.isMutable() ? null : new ArrayList<Object>(this.generationPlans.size());
        for (GenerationPlan generationPlan : this.generationPlans) {
            BeforeExecutionGenerator generator = generationPlan.getGenerator();
            if (!generator.generatedBeforeExecution(object, session)) {
                throw new IdentifierGenerationException("Identity generation isn't supported for composite ids");
            }
            Object currentValue = generator.allowAssignedIdentifiers() ? this.compositeType.getPropertyValue(context, generationPlan.getPropertyIndex(), session) : null;
            Object generated = generator.generate(session, object, currentValue, EventType.INSERT);
            if (generatedValues != null) {
                generatedValues.add(generated);
                continue;
            }
            generationPlan.getInjector().set(context, generated);
        }
        if (generatedValues != null) {
            Object[] values = this.compositeType.getPropertyValues(context);
            for (int i = 0; i < generatedValues.size(); ++i) {
                values[this.generationPlans.get((int)i).getPropertyIndex()] = generatedValues.get(i);
            }
            return this.compositeType.replacePropertyValues(context, values, session);
        }
        return context;
    }

    @Override
    public void registerExportables(Database database) {
        for (GenerationPlan plan : this.generationPlans) {
            plan.registerExportables(database);
        }
    }

    @Override
    public void initialize(SqlStringGenerationContext context) {
        for (GenerationPlan plan : this.generationPlans) {
            plan.initialize(context);
        }
    }

    public List<GenerationPlan> getGenerationPlans() {
        return this.generationPlans;
    }

    public GenerationContextLocator getGenerationContextLocator() {
        return this.generationContextLocator;
    }

    public CompositeType getCompositeType() {
        return this.compositeType;
    }

    public static interface GenerationContextLocator {
        public Object locateGenerationContext(SharedSessionContractImplementor var1, Object var2);
    }

    public static interface GenerationPlan
    extends ExportableProducer {
        public void initialize(SqlStringGenerationContext var1);

        public BeforeExecutionGenerator getGenerator();

        public Setter getInjector();

        public int getPropertyIndex();
    }
}

