/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.net.IDN;
import java.util.Map;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailSenderProvider;
import org.keycloak.models.KeycloakSession;

public class SMTPUtil {
    private SMTPUtil() {
    }

    public static void checkSMTPConfiguration(KeycloakSession session, Map<String, String> config) throws EmailException {
        if (config == null || config.isEmpty()) {
            return;
        }
        EmailSenderProvider sender = (EmailSenderProvider)session.getProvider(EmailSenderProvider.class);
        sender.validate(config);
    }

    public static String convertIDNEmailAddress(String email) {
        int idx;
        int n = idx = email == null ? -1 : email.lastIndexOf(64);
        if (idx < 0) {
            return email;
        }
        try {
            return email.substring(0, idx) + "@" + IDN.toASCII(email.substring(idx + 1));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

