/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.BasicLiteralUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiLiteralUtil {
    @NonNls
    public static final String HEX_PREFIX = "0x";
    @NonNls
    public static final String BIN_PREFIX = "0b";
    @NonNls
    public static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    public static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);

    @Nullable
    public static Integer parseInteger(String text) {
        try {
            if (text.startsWith(HEX_PREFIX)) {
                long value2 = PsiLiteralUtil.parseDigits(text.substring(2), 4, 32);
                return (int)value2;
            }
            if (text.startsWith(BIN_PREFIX)) {
                long value3 = PsiLiteralUtil.parseDigits(text.substring(2), 1, 32);
                return (int)value3;
            }
            if (StringUtil.startsWithChar(text, '0')) {
                long value4 = PsiLiteralUtil.parseDigits(text, 3, 32);
                return (int)value4;
            }
            return PsiLiteralUtil.parseIntegerNoPrefix(text);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Nullable
    public static Integer parseIntegerNoPrefix(String text) {
        long l2 = Long.parseLong(text, 10);
        if (text.equals(_2_IN_31) || l2 == (long)((int)l2)) {
            return (int)l2;
        }
        return null;
    }

    @Nullable
    public static Long parseLong(String text) {
        if (StringUtil.endsWithChar(text, 'L') || StringUtil.endsWithChar(text, 'l')) {
            text = text.substring(0, text.length() - 1);
        }
        try {
            if (text.startsWith(HEX_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text.substring(2), 4, 64);
            }
            if (text.startsWith(BIN_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text.substring(2), 1, 64);
            }
            if (StringUtil.startsWithChar(text, '0')) {
                return PsiLiteralUtil.parseDigits(text, 3, 64);
            }
            if (_2_IN_63.equals(text)) {
                return Long.MIN_VALUE;
            }
            return Long.valueOf(text, 10);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Nullable
    public static Float parseFloat(String text) {
        try {
            return Float.valueOf(text);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Nullable
    public static Double parseDouble(String text) {
        try {
            return Double.valueOf(text);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public static long parseDigits(String text, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int textLength = text.length();
        if (textLength == 0) {
            throw new NumberFormatException(text);
        }
        int radix = 1 << bitsInRadix;
        long l2 = integer = textLength == 1 ? 0L : Long.parseLong(text.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text);
        }
        int lastDigit = Character.digit(text.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }

    @NotNull
    public static String stringForCharLiteral(@NotNull String charLiteral) {
        if (charLiteral == null) {
            PsiLiteralUtil.$$$reportNull$$$0(0);
        }
        if ("'\"'".equals(charLiteral)) {
            return "\"\\\"\"";
        }
        if ("'\\''".equals(charLiteral)) {
            return "\"'\"";
        }
        String string = '\"' + charLiteral.substring(1, charLiteral.length() - 1) + '\"';
        if (string == null) {
            PsiLiteralUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String charLiteralString(PsiLiteralExpression expression2) {
        String content;
        Object value2 = expression2.getValue();
        if (!(value2 instanceof String) || ((CharSequence)value2).length() > 1) {
            throw new IllegalArgumentException();
        }
        String string = content = expression2.isTextBlock() ? PsiLiteralUtil.getTextBlockText(expression2) : PsiLiteralUtil.getStringLiteralContent(expression2);
        if (content == null) {
            return null;
        }
        switch (content) {
            case "'": {
                return "'\\''";
            }
            case "\\\"": {
                return "'\"'";
            }
        }
        return '\'' + content + '\'';
    }

    public static boolean isUnsafeLiteral(PsiLiteralExpression expression2) {
        PsiElement literal = expression2.getFirstChild();
        assert (literal instanceof PsiJavaToken) : literal;
        IElementType type = ((PsiJavaToken)literal).getTokenType();
        return (type == JavaTokenType.CHARACTER_LITERAL || type == JavaTokenType.STRING_LITERAL || type == JavaTokenType.TEXT_BLOCK_LITERAL) && expression2.getValue() == null;
    }

    @NotNull
    public static String escapeTextBlockCharacters(@NotNull String s2) {
        if (s2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(2);
        }
        return PsiLiteralUtil.escapeTextBlockCharacters(s2, false, true, true);
    }

    @NotNull
    public static String escapeTextBlockCharacters(@NotNull String s2, boolean escapeStartQuote, boolean escapeEndQuote, boolean escapeSpacesInTheEnd) {
        if (s2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(3);
        }
        int i2 = 0;
        int length = s2.length();
        StringBuilder result2 = new StringBuilder(length);
        while (i2 < length) {
            int nextIdx = PsiLiteralUtil.parseQuotes(i2, s2, result2, escapeStartQuote, escapeEndQuote);
            if (nextIdx != -1) {
                i2 = nextIdx;
                continue;
            }
            nextIdx = PsiLiteralUtil.parseSpaces(i2, s2, result2, escapeSpacesInTheEnd);
            if (nextIdx != -1) {
                i2 = nextIdx;
                continue;
            }
            nextIdx = PsiLiteralUtil.parseBackSlashes(i2, s2, result2);
            if (nextIdx != -1) {
                i2 = nextIdx;
                continue;
            }
            result2.append(s2.charAt(i2));
            ++i2;
        }
        String string = result2.toString();
        if (string == null) {
            PsiLiteralUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static int parseQuotes(int start, @NotNull String s2, @NotNull StringBuilder result2, boolean escapeStartQuote, boolean escapeEndQuote) {
        char c2;
        if (s2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(6);
        }
        if ((c2 = s2.charAt(start)) != '\"') {
            return -1;
        }
        int nQuotes = 1;
        int i2 = start;
        while (true) {
            int nextIdx;
            int n2 = nextIdx = i2 + 1 >= s2.length() ? -1 : PsiLiteralUtil.parseBackSlash(s2, i2 + 1);
            if (nextIdx == -1) {
                nextIdx = i2 + 1;
            }
            if (nextIdx >= s2.length() || s2.charAt(nextIdx) != '\"') break;
            ++nQuotes;
            i2 = nextIdx;
        }
        for (int q2 = 0; q2 < nQuotes; ++q2) {
            if (q2 == 0 && start == 0 && escapeStartQuote || q2 % 3 == 2 || q2 == nQuotes - 1 && i2 + 1 == s2.length() && escapeEndQuote) {
                result2.append("\\\"");
                continue;
            }
            result2.append('\"');
        }
        return i2 + 1;
    }

    private static int parseSpaces(int start, @NotNull String s2, @NotNull StringBuilder result2, boolean escapeSpacesInTheEnd) {
        int nextIdx;
        int i2;
        char c2;
        if (s2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(8);
        }
        if ((c2 = s2.charAt(start)) != ' ') {
            return -1;
        }
        int nSpaces = 0;
        for (i2 = start; i2 < s2.length() && s2.charAt(i2) == ' '; ++i2) {
            ++nSpaces;
        }
        if (i2 >= s2.length() && escapeSpacesInTheEnd) {
            result2.append(StringUtil.repeat(" ", nSpaces - 1)).append("\\s");
            return i2;
        }
        int n2 = nextIdx = i2 >= s2.length() ? -1 : PsiLiteralUtil.parseBackSlash(s2, i2);
        if (nextIdx != -1 && nextIdx < s2.length() && s2.charAt(nextIdx) == 'n') {
            result2.append(StringUtil.repeat(" ", nSpaces - 1)).append("\\s");
            return i2;
        }
        result2.append(StringUtil.repeatSymbol(' ', nSpaces));
        return i2;
    }

    private static int parseBackSlashes(int start, @NotNull String s2, @NotNull StringBuilder result2) {
        int nextIdx;
        int i2;
        if (s2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(10);
        }
        if ((i2 = PsiLiteralUtil.parseBackSlash(s2, start)) == -1) {
            return -1;
        }
        int prev = start;
        int nSlashes = 1;
        while (i2 < s2.length() && (nextIdx = PsiLiteralUtil.parseBackSlash(s2, i2)) != -1) {
            result2.append(s2, prev, i2);
            prev = i2;
            i2 = nextIdx;
            ++nSlashes;
        }
        if (i2 >= s2.length()) {
            result2.append(s2, prev, s2.length());
        } else if (nSlashes % 2 == 0) {
            result2.append(s2, prev, i2);
        } else {
            char next = s2.charAt(i2);
            if (next == 'n') {
                result2.append('\n');
            } else {
                if (next == '\"') {
                    return i2;
                }
                result2.append(s2, prev, i2).append(next);
            }
            return i2 + 1;
        }
        return i2;
    }

    @NotNull
    public static String escapeBackSlashesInTextBlock(@NotNull String str) {
        if (str == null) {
            PsiLiteralUtil.$$$reportNull$$$0(11);
        }
        int i2 = 0;
        int length = str.length();
        StringBuilder result2 = new StringBuilder(length);
        while (i2 < length) {
            int nextIdx = PsiLiteralUtil.parseBackSlash(str, i2);
            if (nextIdx != -1) {
                result2.append("\\\\");
                i2 = nextIdx;
                continue;
            }
            result2.append(str.charAt(i2));
            ++i2;
        }
        String string = result2.toString();
        if (string == null) {
            PsiLiteralUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static int parseBackSlash(@NotNull String str, int idx) {
        char c2;
        if (str == null) {
            PsiLiteralUtil.$$$reportNull$$$0(13);
        }
        if ((c2 = str.charAt(idx)) != '\\') {
            return -1;
        }
        int nextIdx = PsiLiteralUtil.parseEscapedBackSlash(str, idx);
        return nextIdx > 0 ? nextIdx : idx + 1;
    }

    private static int parseEscapedBackSlash(@NotNull String str, int idx) {
        int len;
        if (str == null) {
            PsiLiteralUtil.$$$reportNull$$$0(14);
        }
        if (++idx >= (len = str.length()) || str.charAt(idx) != 'u') {
            return -1;
        }
        while (++idx < len && str.charAt(idx) == 'u') {
        }
        if (idx + 3 >= len) {
            return -1;
        }
        try {
            int code = Integer.parseInt(str.substring(idx, idx + 4), 16);
            if (code == 92) {
                return idx + 4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static String @Nullable [] getTextBlockLines(@NotNull PsiLiteralExpression expression2) {
        if (expression2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(15);
        }
        return BasicLiteralUtil.getTextBlockLines(expression2);
    }

    public static String @Nullable [] getTextBlockLines(String text) {
        return BasicLiteralUtil.getTextBlockLines(text);
    }

    public static boolean isTextBlockWhiteSpace(char c2) {
        return BasicLiteralUtil.isTextBlockWhiteSpace(c2);
    }

    public static int getTextBlockIndent(@NotNull PsiLiteralExpression expression2) {
        if (expression2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(16);
        }
        return BasicLiteralUtil.getTextBlockIndent(expression2);
    }

    public static int getTextBlockIndent(String @NotNull [] lines) {
        if (lines == null) {
            PsiLiteralUtil.$$$reportNull$$$0(17);
        }
        return BasicLiteralUtil.getTextBlockIndent(lines);
    }

    public static int getTextBlockIndent(String @NotNull [] lines, boolean preserveContent, boolean ignoreLastLine) {
        if (lines == null) {
            PsiLiteralUtil.$$$reportNull$$$0(18);
        }
        return BasicLiteralUtil.getTextBlockIndent(lines, preserveContent, ignoreLastLine);
    }

    @Nullable
    public static String getStringLiteralContent(PsiLiteralExpression expression2) {
        String text = expression2.getText();
        int textLength = text.length();
        if (textLength > 1 && text.charAt(0) == '\"' && text.charAt(textLength - 1) == '\"') {
            return text.substring(1, textLength - 1);
        }
        if (textLength > "&quot;".length() && text.startsWith("&quot;") && text.endsWith("&quot;")) {
            return text.substring("&quot;".length(), textLength - "&quot;".length());
        }
        return null;
    }

    @Nullable
    public static String getTextBlockText(PsiLiteralExpression expression2) {
        String[] lines = PsiLiteralUtil.getTextBlockLines(expression2);
        if (lines == null) {
            return null;
        }
        int prefix = PsiLiteralUtil.getTextBlockIndent(lines);
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String line = lines[i2];
            if (!line.isEmpty()) {
                sb.append(PsiLiteralUtil.trimTrailingWhitespaces(line.substring(prefix)));
            }
            if (i2 >= lines.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    @NotNull
    public static String trimTrailingWhitespaces(@NotNull String line) {
        int wsIndex;
        if (line == null) {
            PsiLiteralUtil.$$$reportNull$$$0(19);
        }
        int index = line.length();
        while ((wsIndex = PsiLiteralUtil.parseWhitespaceBackwards(line, index - 1)) != -1) {
            index = wsIndex;
        }
        String string = line.substring(0, index);
        if (string == null) {
            PsiLiteralUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static int parseWhitespaceBackwards(@NotNull String s2, int index) {
        if (s2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(21);
        }
        if (index < 0) {
            return -1;
        }
        if (Character.isWhitespace(s2.charAt(index))) {
            return index;
        }
        if ((index = PsiLiteralUtil.parseUnicodeEscapeBackwards(s2, index, Character::isWhitespace)) < 0) {
            return -1;
        }
        int nBackSlashes = 1;
        if (--index >= 0 && s2.charAt(index) == '\\') {
            ++nBackSlashes;
            nBackSlashes += PsiLiteralUtil.countBackSlashes(s2, index - 1);
        }
        return nBackSlashes % 2 == 0 ? -1 : index + 1;
    }

    private static int countBackSlashes(@NotNull String s2, int index) {
        if (s2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(22);
        }
        int nBackSlashes = 0;
        while (index >= 0) {
            int start;
            int n2 = start = s2.charAt(index) == '\\' ? index : PsiLiteralUtil.parseUnicodeEscapeBackwards(s2, index, c2 -> c2.charValue() == '\\');
            if (start == -1) break;
            ++nBackSlashes;
            index = start - 1;
        }
        return nBackSlashes;
    }

    private static int parseUnicodeEscapeBackwards(@NotNull String s2, int index, @NotNull Predicate<? super Character> charPredicate) {
        if (s2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(23);
        }
        if (charPredicate == null) {
            PsiLiteralUtil.$$$reportNull$$$0(24);
        }
        if (index - 5 < 0) {
            return -1;
        }
        int start = PsiLiteralUtil.findSlashU(s2, index - 4);
        if (start < 0) {
            return -1;
        }
        try {
            int code = Integer.parseInt(s2.substring(index - 3, index + 1), 16);
            if (!charPredicate.test(Character.valueOf((char)code))) {
                return -1;
            }
        }
        catch (NumberFormatException e2) {
            return -1;
        }
        return start;
    }

    private static int findSlashU(@NotNull String s2, int index) {
        if (s2 == null) {
            PsiLiteralUtil.$$$reportNull$$$0(25);
        }
        if (s2.charAt(index) != 'u') {
            return -1;
        }
        while (--index >= 0 && s2.charAt(index) == 'u') {
        }
        if (index < 0 || s2.charAt(index) != '\\') {
            return -1;
        }
        return index;
    }

    @Nullable
    public static TextRange mapBackStringRange(@NotNull String text, int from2, int to) {
        if (text == null) {
            PsiLiteralUtil.$$$reportNull$$$0(26);
        }
        if (from2 > to || to < 0) {
            return null;
        }
        if (text.length() < 2 || !text.startsWith("\"") || !text.endsWith("\"")) {
            return null;
        }
        if (text.indexOf(92) == -1) {
            return new TextRange(from2 + 1, to + 1);
        }
        text = text.substring(1, text.length() - 1);
        int charsSoFar = 0;
        int mappedFrom = -1;
        int i2 = 0;
        while (i2 != -1) {
            if (charsSoFar == from2) {
                mappedFrom = i2;
            }
            if (charsSoFar == to) {
                return new TextRange(mappedFrom + 1, i2 + 1);
            }
            ++charsSoFar;
            i2 = PsiLiteralUtil.getCharEndIndex(text, i2);
        }
        return null;
    }

    @Nullable
    public static TextRange mapBackTextBlockRange(@NotNull String text, int from2, int to, int indent) {
        if (text == null) {
            PsiLiteralUtil.$$$reportNull$$$0(27);
        }
        if (from2 > to || to < 0) {
            return null;
        }
        TextBlockModel model = TextBlockModel.create(text, indent);
        if (model == null) {
            return null;
        }
        return model.mapTextBlockRangeBack(from2, to);
    }

    private static int getCharEndIndex(@NotNull String line, int i2) {
        char c2;
        if (line == null) {
            PsiLiteralUtil.$$$reportNull$$$0(28);
        }
        if (i2 >= line.length()) {
            return -1;
        }
        if ((c2 = line.charAt(i2++)) == '\\') {
            char c1;
            if ((c1 = line.charAt(i2++)) == 'u') {
                while (i2 < line.length() && line.charAt(i2) == 'u') {
                    ++i2;
                }
                i2 += 4;
            } else if (c1 >= '0' && c1 <= '7') {
                char c22;
                char c3 = c22 = i2 < line.length() ? line.charAt(i2) : (char)'\u0000';
                if (c22 >= '0' && c22 <= '7') {
                    char c32;
                    char c4 = c32 = ++i2 < line.length() ? line.charAt(i2) : (char)'\u0000';
                    if (c32 >= '0' && c32 <= '7' && c1 <= '3') {
                        ++i2;
                    }
                }
            }
        }
        return i2;
    }

    @Nullable
    public static String tryConvertNumericLiteral(@NotNull PsiLiteralExpression literal, PsiType wantedType) {
        float f2;
        String text;
        Number value2;
        String text2;
        if (literal == null) {
            PsiLiteralUtil.$$$reportNull$$$0(29);
        }
        PsiType exprType = literal.getType();
        if (PsiTypes.intType().equals(exprType)) {
            if (PsiTypes.longType().equals(wantedType)) {
                return literal.getText() + "L";
            }
            if (PsiTypes.floatType().equals(wantedType) && !(text2 = literal.getText()).startsWith("0")) {
                return text2 + "F";
            }
            if (PsiTypes.doubleType().equals(wantedType) && !(text2 = literal.getText()).startsWith("0")) {
                return text2 + ".0";
            }
        }
        if (PsiTypes.longType().equals(exprType) && PsiTypes.intType().equals(wantedType) && (value2 = ObjectUtils.tryCast(literal.getValue(), Long.class)) != null && (Long)value2 >= Integer.MIN_VALUE && (Long)value2 <= Integer.MAX_VALUE && StringUtil.endsWithIgnoreCase(text = literal.getText(), "L")) {
            return text.substring(0, text.length() - 1);
        }
        if (PsiTypes.doubleType().equals(exprType) && PsiTypes.floatType().equals(wantedType) && (value2 = ObjectUtils.tryCast(literal.getValue(), Double.class)) != null && Float.isFinite(f2 = (float)((Double)value2).doubleValue()) && ((double)f2 != 0.0 || (Double)value2 == 0.0)) {
            String text3 = literal.getText();
            if (StringUtil.endsWithIgnoreCase(text3, "D")) {
                text3 = text3.substring(0, text3.length() - 1);
            }
            return text3 + "F";
        }
        if (PsiTypes.floatType().equals(exprType) && PsiTypes.doubleType().equals(wantedType) && StringUtil.endsWithIgnoreCase(text2 = literal.getText(), "F")) {
            String newLiteral = text2.substring(0, text2.length() - 1);
            if (!StringUtil.containsAnyChar(newLiteral, ".eEpP")) {
                newLiteral = newLiteral + ".0";
            }
            return newLiteral;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 20: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charLiteral";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiLiteralUtil";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charPredicate";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiLiteralUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "stringForCharLiteral";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeTextBlockCharacters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeBackSlashesInTextBlock";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailingWhitespaces";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringForCharLiteral";
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 20: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "escapeTextBlockCharacters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseQuotes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseSpaces";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseBackSlashes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashesInTextBlock";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseBackSlash";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseEscapedBackSlash";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTextBlockLines";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTextBlockIndent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailingWhitespaces";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseWhitespaceBackwards";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "countBackSlashes";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseUnicodeEscapeBackwards";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findSlashU";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "mapBackStringRange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mapBackTextBlockRange";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCharEndIndex";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryConvertNumericLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 12: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TextBlockModel {
        private final String[] lines;
        private final int indent;
        private final int startPrefixLength;

        private TextBlockModel(String[] lines, int indent, int startPrefixLength) {
            this.lines = lines;
            this.indent = indent;
            this.startPrefixLength = startPrefixLength;
        }

        @Nullable
        private TextRange mapTextBlockRangeBack(int from2, int to) {
            int curOffset = this.startPrefixLength;
            int charsSoFar = 0;
            int mappedFrom = -1;
            for (int i2 = 0; i2 < this.lines.length; ++i2) {
                String line = this.lines[i2];
                int linePrefixLength = TextBlockModel.findLinePrefixLength(line, this.indent);
                line = line.substring(linePrefixLength);
                boolean isLastLine = i2 == this.lines.length - 1;
                int lineSuffixLength = TextBlockModel.findLineSuffixLength(line, isLastLine);
                line = line.substring(0, line.length() - lineSuffixLength);
                if (!isLastLine) {
                    line = line + '\n';
                }
                curOffset += linePrefixLength;
                int nextIdx = 0;
                while (true) {
                    if (from2 == charsSoFar) {
                        mappedFrom = curOffset + nextIdx;
                    }
                    if (to == charsSoFar) {
                        return new TextRange(mappedFrom, curOffset + nextIdx);
                    }
                    int charIdx = nextIdx;
                    if ((nextIdx = PsiLiteralUtil.getCharEndIndex(line, charIdx)) == -1) break;
                    ++charsSoFar;
                    if (nextIdx != line.length()) continue;
                    curOffset += lineSuffixLength;
                }
                curOffset += line.length();
            }
            return null;
        }

        private static int findLinePrefixLength(@NotNull String line, int indent) {
            boolean isBlankLine;
            if (line == null) {
                TextBlockModel.$$$reportNull$$$0(0);
            }
            return (isBlankLine = line.chars().allMatch(Character::isWhitespace)) ? line.length() : indent;
        }

        private static int findLineSuffixLength(@NotNull String line, boolean isLastLine) {
            int lastIdx;
            if (line == null) {
                TextBlockModel.$$$reportNull$$$0(1);
            }
            if (isLastLine) {
                return 0;
            }
            for (int i2 = lastIdx = line.length() - 1; i2 >= 0; --i2) {
                if (Character.isWhitespace(line.charAt(i2))) continue;
                return lastIdx - i2;
            }
            return 0;
        }

        @Nullable
        private static TextBlockModel create(@NotNull String text, int indent) {
            if (text == null) {
                TextBlockModel.$$$reportNull$$$0(2);
            }
            if (text.length() < 7 || !text.startsWith("\"\"\"") || !text.endsWith("\"\"\"")) {
                return null;
            }
            int startPrefixLength = TextBlockModel.findStartPrefixLength(text);
            if (startPrefixLength == -1) {
                return null;
            }
            String[] lines = text.substring(startPrefixLength, text.length() - 3).split("\n", -1);
            return new TextBlockModel(lines, indent, startPrefixLength);
        }

        @Contract(pure=true)
        private static int findStartPrefixLength(@NotNull String text) {
            int lineBreakIdx;
            if (text == null) {
                TextBlockModel.$$$reportNull$$$0(3);
            }
            if ((lineBreakIdx = text.indexOf("\n")) == -1) {
                return -1;
            }
            return lineBreakIdx + 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/util/PsiLiteralUtil$TextBlockModel";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findLinePrefixLength";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findLineSuffixLength";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findStartPrefixLength";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

