/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.javahint;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.spi.NbProjectProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.javahint.JavaHintDataPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.javahint.JavaHintLocationPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

public class NewJavaHintIterator
extends BasicWizardIterator {
    private DataModel data;

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new JavaHintDataPanel(wiz, this.data), new JavaHintLocationPanel(wiz, this.data)};
    }

    public Set<?> instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return NewJavaHintIterator.getCreatedFiles(cmf, this.data.getProject());
    }

    static void generateFileChanges(DataModel model) {
        CreatedModifiedFiles cmf = new CreatedModifiedFiles(model.getProject());
        cmf.add(cmf.addModuleDependency("org.netbeans.modules.java.source.base", "java"));
        cmf.add(cmf.addModuleDependency("org.netbeans.modules.java.source", "java"));
        cmf.add(cmf.addModuleDependency("org.netbeans.spi.java.hints", "java"));
        cmf.add(cmf.addModuleDependency("org.netbeans.spi.editor.hints", "ide"));
        cmf.add(cmf.addModuleDependency("org.openide.util"));
        cmf.add(cmf.addModuleDependency("org.netbeans.libs.javacapi", "java"));
        cmf.add(cmf.addTestModuleDependency("org.netbeans.modules.java.hints.test", "java"));
        cmf.add(cmf.addTestModuleDependency("org.netbeans.libs.junit4", "extra"));
        cmf.add(cmf.addTestModuleDependency("org.netbeans.modules.nbjunit", "harness"));
        cmf.add(cmf.addTestModuleDependency("org.netbeans.modules.parsing.api", "ide"));
        cmf.add(cmf.addTestModuleDependency("org.netbeans.modules.projectapi", "ide"));
        NbProjectProvider nbProjectProvider = NewJavaHintIterator.getProjectProvider(model.getProject());
        if (nbProjectProvider != null && nbProjectProvider.isSuiteComponent()) {
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.classfile", "java"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.spi.java.hints", "java"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.java.hints.test", "java"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.java.lexer", "java"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.java.platform", "java"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.java.project", "java"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.api.java", "java"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.lib.nbjavac", "java"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.java.preprocessorbridge", "java"));
            cmf.add(cmf.addModuleToTargetPlatform("org.apache.tools.ant.module", "extide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.options.java", "extide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.insane", "harness"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.project.ant", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.apache.xml.resolver", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.api.java.classpath", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.diff", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.actions", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.document", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.fold", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.fold.nbui", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.errorstripe.api", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.errorstripe", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.guards", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.indent", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.indent.project", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.indent.support", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.lib", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.lib2", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.options.editor", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.settings", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.settings.lib", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.settings.storage", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.editor.util", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.project.libraries", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.libs.freemarker", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.lexer", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.libs.lucene", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.spi.navigator", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.parsing.api", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.parsing.indexing", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.parsing.lucene", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.projectapi", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.project.indexingbridge", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.project.spi.intern", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.projectuiapi.base", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.projectuiapi", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.refactoring.api", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.code.analysis", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.spi.tasklist", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.xml.catalog", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.api.xml", "ide"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.autoupdate.services", "platform"));
            cmf.add(cmf.addModuleToTargetPlatform("org.netbeans.modules.autoupdate.ui", "platform"));
            cmf.add(cmf.addModuleToTargetPlatform("org.openide.execution", "platform"));
        }
        String className = model.getClassName();
        FileObject hintTemplate = CreatedModifiedFiles.getTemplate("javaHint.java");
        assert (hintTemplate != null);
        String hintPath = model.getDefaultPackagePath(className + ".java", false);
        HashMap<String, String> replaceTokens = new HashMap<String, String>();
        replaceTokens.put("CLASS_NAME", className);
        replaceTokens.put("PACKAGE_NAME", model.getPackageName());
        replaceTokens.put("GENERATE_FIX", model.isDoFix() ? "true" : null);
        replaceTokens.put("DISPLAY_NAME", model.getDisplayName());
        replaceTokens.put("DESCRIPTION", NewJavaHintIterator.replaceLineBreaksWithHTMLLineBreaks(model.getDescription()));
        replaceTokens.put("WARNING_MESSAGE", model.getWarningMessage());
        if (model.isDoFix()) {
            replaceTokens.put("FIX_MESSAGE", model.getFixText());
        }
        cmf.add(cmf.createFileWithSubstitutions(hintPath, hintTemplate, replaceTokens));
        String testPath = model.getDefaultPackagePath(className + "Test.java", false, true);
        FileObject testTemplate = null;
        testTemplate = nbProjectProvider != null && nbProjectProvider.isNbPlatformApplication() ? CreatedModifiedFiles.getTemplate("javaHintTestApp.java") : CreatedModifiedFiles.getTemplate("javaHintTest.java");
        assert (testTemplate != null);
        cmf.add(cmf.createFileWithSubstitutions(testPath, testTemplate, replaceTokens));
        model.setCreatedModifiedFiles(cmf);
    }

    private static String replaceLineBreaksWithHTMLLineBreaks(String text) {
        String result = null != text ? text : "";
        result = result.trim().replaceAll("(\r?\n|\r)(?=.)", "<br/>\" +\n\"");
        return result;
    }

    private static NbProjectProvider getProjectProvider(Project prj) {
        return (NbProjectProvider)prj.getLookup().lookup(NbProjectProvider.class);
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private CreatedModifiedFiles files;
        private String className;
        private String displayName;
        private String descriptor;
        private String warningMessage;
        private boolean doFix;
        private String fixText;
        private String codeNameBase;

        DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.files;
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getDescription() {
            return this.descriptor;
        }

        public void setDescription(String descriptor) {
            this.descriptor = descriptor;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public CreatedModifiedFiles getFiles() {
            return this.files;
        }

        public void setFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        public boolean isDoFix() {
            return this.doFix;
        }

        public void setDoFix(boolean doFix) {
            this.doFix = doFix;
        }

        public String getFixText() {
            return this.fixText;
        }

        public void setFixText(String fixText) {
            this.fixText = fixText;
        }

        public String getWarningMessage() {
            return this.warningMessage;
        }

        public void setWarningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
        }

        @Override
        public String getPackageName() {
            String retValue = super.getPackageName();
            if (retValue == null) {
                retValue = this.getCodeNameBase();
                super.setPackageName(retValue);
            }
            return retValue;
        }

        private String getCodeNameBase() {
            if (this.codeNameBase == null) {
                NbModuleProvider mod = (NbModuleProvider)this.getProject().getLookup().lookup(NbModuleProvider.class);
                this.codeNameBase = mod.getCodeNameBase();
            }
            return this.codeNameBase;
        }
    }
}

