/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.sps.impl;

import java.lang.ref.WeakReference;
import java.security.acl.NotOwnerException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.spi.support.GrantPrivilegesProvider;
import org.netbeans.modules.nativeexecution.spi.support.GrantPrivilegesProviderFactory;
import org.netbeans.modules.nativeexecution.sps.impl.SPSCommonImpl;
import org.netbeans.modules.nativeexecution.support.Computable;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class RequestPrivilegesTask
implements Computable<RequestPrivilegesTaskParams, Boolean> {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private WeakReference<GrantPrivilegesProvider> dialogRef = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean compute(RequestPrivilegesTaskParams args) throws InterruptedException {
        RequestPrivilegesTaskPerformer performer = new RequestPrivilegesTaskPerformer(args);
        final Future<Boolean> result = NativeTaskExecutorService.submit(performer, "RequestPrivilegesTask");
        ProgressHandle ph = ProgressHandle.createHandle((String)RequestPrivilegesTask.loc("TaskPrivilegesSupport_Progress_RequestPrivileges", new String[0]), (Cancellable)new Cancellable(){
            final /* synthetic */ RequestPrivilegesTask this$0;
            {
                this.this$0 = this$0;
            }

            public boolean cancel() {
                return result.cancel(true);
            }
        });
        ph.start();
        try {
            Boolean bl = result.get();
            return bl;
        }
        catch (ExecutionException ex) {
            log.fine("ExecutionException in RequestPrivilegesTask : " + ex.toString());
        }
        catch (CancellationException cancellationException) {
        }
        finally {
            ph.finish();
        }
        return Boolean.FALSE;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(SPSCommonImpl.class, (String)key, (Object[])params);
    }

    private class RequestPrivilegesTaskPerformer
    implements Callable<Boolean> {
        private final RequestPrivilegesTaskParams args;

        public RequestPrivilegesTaskPerformer(RequestPrivilegesTaskParams args) {
            this.args = args;
        }

        @Override
        public Boolean call() throws Exception {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(this.args.support.getExecEnv());
            npb.setExecutable("/bin/pfexec").setArguments("/bin/ppriv", "-s", "I+" + this.args.privilegesString, this.args.support.getPID());
            ProcessUtils.ExitStatus res = ProcessUtils.execute(npb);
            if (res.isOK()) {
                return Boolean.TRUE;
            }
            if (!this.args.askForPassword) {
                return Boolean.FALSE;
            }
            if (RequestPrivilegesTask.this.dialogRef == null || RequestPrivilegesTask.this.dialogRef.get() == null) {
                GrantPrivilegesProviderFactory factory = (GrantPrivilegesProviderFactory)Lookup.getDefault().lookup(GrantPrivilegesProviderFactory.class);
                if (factory == null) {
                    return Boolean.FALSE;
                }
                RequestPrivilegesTask.this.dialogRef = new WeakReference<GrantPrivilegesProvider>(factory.create());
            }
            GrantPrivilegesProvider provider = (GrantPrivilegesProvider)RequestPrivilegesTask.this.dialogRef.get();
            while (provider.askPassword()) {
                try {
                    char[] clearPassword = provider.getPassword();
                    this.args.support.requestPrivileges(this.args.requestedPrivileges, provider.getUser(), clearPassword);
                    Arrays.fill(clearPassword, '\u0000');
                    provider.clearPassword();
                    return Boolean.TRUE;
                }
                catch (NotOwnerException notOwnerException) {
                }
            }
            throw new CancellationException();
        }
    }

    public static class RequestPrivilegesTaskParams {
        final Collection<String> requestedPrivileges;
        final boolean askForPassword;
        private final String privilegesString;
        final SPSCommonImpl support;

        public RequestPrivilegesTaskParams(SPSCommonImpl support, Collection<String> requestedPrivileges, boolean askForPassword) {
            this.support = support;
            this.requestedPrivileges = requestedPrivileges;
            this.askForPassword = askForPassword;
            StringBuffer sb = new StringBuffer();
            for (String priv : requestedPrivileges) {
                sb.append(priv).append(",");
            }
            this.privilegesString = sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RequestPrivilegesTaskParams)) {
                throw new IllegalArgumentException();
            }
            RequestPrivilegesTaskParams o = (RequestPrivilegesTaskParams)obj;
            return o.askForPassword == this.askForPassword && o.support == this.support && o.requestedPrivileges.containsAll(this.requestedPrivileges) && this.requestedPrivileges.containsAll(o.requestedPrivileges);
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + (this.askForPassword ? 1 : 0);
            hash = 79 * hash + (this.support != null ? this.support.hashCode() : 0);
            return hash;
        }
    }
}

