/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.server;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.modules.selenium2.server.Selenium2Customizer;
import org.netbeans.modules.selenium2.server.Selenium2ServicesNode;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;

public class Selenium2ServerSupport
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(Selenium2ServerSupport.class.getName());
    private static final Selenium2ServerSupport INSTANCE = new Selenium2ServerSupport();
    private static Object server = null;
    private static boolean isRunning = false;
    private static boolean isStarting = false;
    private static Action action = null;
    private static Task latestTask = null;
    public static final int PORT_DEFAULT = 4444;
    public static final String PORT = "port";
    public static final String USER_EXTENSION_FILE = "user.extension.file";
    public static final String SELENIUM_SERVER_JAR = "selenium.server.jar";
    public static final boolean SINGLE_WINDOW_DEFAULT = false;
    public static final String SINGLE_WINDOW = "single.window";
    public static final String FIREFOX_PROFILE_TEMPLATE_DIR = "firefox.profile.template.dir";

    private Selenium2ServerSupport() {
        Selenium2ServerSupport.getPrefs().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if (Selenium2ServerSupport.this.isRunning()) {
                    action = Action.RELOAD;
                    RequestProcessor.getDefault().post((Runnable)INSTANCE);
                } else {
                    try {
                        Selenium2ServerSupport.initializeServer();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, "Cannot re-initialize Selenium server after change of its configuration.", ex);
                    }
                }
            }
        });
    }

    public static Selenium2ServerSupport getInstance() {
        return INSTANCE;
    }

    public Task startServer() {
        if (this.isRunning()) {
            return Task.EMPTY;
        }
        if (!Selenium2Customizer.isConfiguredProperly() && !this.configureServer()) {
            return Task.EMPTY;
        }
        action = Action.START;
        return Selenium2ServerSupport.postTask();
    }

    public Task stopServer() {
        if (!this.isRunning()) {
            return Task.EMPTY;
        }
        action = Action.STOP;
        return Selenium2ServerSupport.postTask();
    }

    public Task restartServer() {
        if (!this.isRunning()) {
            return this.startServer();
        }
        action = Action.RESTART;
        return Selenium2ServerSupport.postTask();
    }

    public boolean configureServer() {
        final boolean[] res = new boolean[1];
        Runnable r = new Runnable(){
            final /* synthetic */ Selenium2ServerSupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                boolean b = Selenium2Customizer.showCustomizer();
                Selenium2ServicesNode.getInstance().refresh();
                res[0] = b;
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return res[0];
    }

    public boolean isRunning() {
        return isRunning;
    }

    public boolean isStarting() {
        return isStarting;
    }

    private static Task postTask() {
        RequestProcessor.Task t = RequestProcessor.getDefault().post((Runnable)INSTANCE);
        latestTask = t;
        return t;
    }

    @Override
    public void run() {
        try {
            isStarting = true;
            Selenium2ServicesNode.getInstance().refresh();
            if (server == null) {
                Selenium2ServerSupport.initializeServer();
            }
            switch (action.ordinal()) {
                case 0: {
                    this.callSeleniumServerMethod("boot");
                    this.callSeleniumServerMethod("start");
                    break;
                }
                case 1: {
                    this.callSeleniumServerMethod("stop");
                    break;
                }
                case 2: {
                    this.callSeleniumServerMethod("stop");
                    this.callSeleniumServerMethod("boot");
                    this.callSeleniumServerMethod("start");
                    break;
                }
                case 3: {
                    this.callSeleniumServerMethod("stop");
                    server = null;
                    Selenium2ServerSupport.initializeServer();
                    this.callSeleniumServerMethod("boot");
                    this.callSeleniumServerMethod("start");
                    break;
                }
                default: {
                    assert (false) : "Invalid option";
                    break;
                }
            }
            isStarting = false;
            Selenium2ServicesNode.getInstance().refresh();
            if (action == null) {
                return;
            }
            isRunning = action != Action.STOP;
            action = null;
        }
        catch (BindException bi) {
            LOGGER.log(Level.INFO, "Port already in use - the server is probably already running.", bi);
        }
        catch (Exception exc) {
            LOGGER.log(Level.INFO, null, exc);
        }
    }

    protected static URLClassLoader getSeleniumServerClassLoader() {
        URL url = null;
        try {
            url = Utilities.toURI((File)new File(Selenium2ServerSupport.getPrefs().get(SELENIUM_SERVER_JAR, null))).toURL();
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return URLClassLoader.newInstance(new URL[]{url});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callSeleniumServerMethod(String method) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader curr = server.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(curr);
            server.getClass().getMethod(method, new Class[0]).invoke(server, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        catch (SecurityException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private static void initializeServer() throws Exception {
        File userExtensionFile;
        String userExtensionsString;
        File ffProfileDir;
        URLClassLoader urlClassLoader = Selenium2ServerSupport.getSeleniumServerClassLoader();
        Class<?> seleniumServer = urlClassLoader.loadClass("org.openqa.selenium.server.SeleniumServer");
        Class<?> remoteControlConfiguration = urlClassLoader.loadClass("org.openqa.selenium.server.RemoteControlConfiguration");
        Object remoteControlConfigurationInstance = remoteControlConfiguration.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        int port = Selenium2ServerSupport.getPrefs().getInt(PORT, 4444);
        remoteControlConfiguration.getMethod("setPort", Integer.TYPE).invoke(remoteControlConfigurationInstance, port);
        boolean runInSingleWindow = Selenium2ServerSupport.getPrefs().getBoolean(SINGLE_WINDOW, false);
        remoteControlConfiguration.getMethod("setSingleWindow", Boolean.TYPE).invoke(remoteControlConfigurationInstance, runInSingleWindow);
        String firefoxProfileDir = Selenium2ServerSupport.getPrefs().get(FIREFOX_PROFILE_TEMPLATE_DIR, "");
        if (!firefoxProfileDir.isEmpty() && (ffProfileDir = new File(firefoxProfileDir)).exists()) {
            remoteControlConfiguration.getMethod("setFirefoxProfileTemplate", File.class).invoke(remoteControlConfigurationInstance, ffProfileDir);
        }
        if (!(userExtensionsString = Selenium2ServerSupport.getPrefs().get(USER_EXTENSION_FILE, "")).isEmpty() && (userExtensionFile = new File(userExtensionsString)).exists()) {
            remoteControlConfiguration.getMethod("setUserExtensions", File.class).invoke(remoteControlConfigurationInstance, userExtensionFile);
        }
        server = seleniumServer.getConstructor(remoteControlConfiguration).newInstance(remoteControlConfigurationInstance);
    }

    public static Preferences getPrefs() {
        return NbPreferences.forModule(Selenium2Customizer.class);
    }

    static void waitAllTasksFinished() {
        if (latestTask == null) {
            return;
        }
        while (!latestTask.isFinished()) {
            latestTask.waitFinished();
        }
    }

    private static enum Action {
        START,
        STOP,
        RESTART,
        RELOAD;

    }
}

