/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.caret;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.EditorCaret;

final class CaretItem
implements Comparable {
    private static final Logger LOG = Logger.getLogger(CaretItem.class.getName());
    private static final int REMOVED_IN_TRANSACTION = 1;
    private static final int INFO_OBSOLETE = 2;
    private static final int UPDATE_CARET_BOUNDS = 4;
    private static final int CARET_PAINTED = 8;
    private final EditorCaret editorCaret;
    private Position dotPos;
    private Position.Bias dotBias;
    private Position markPos;
    private Position.Bias markBias;
    private Point magicCaretPosition;
    private CaretInfo info;
    private Rectangle caretBounds;
    private int transactionIndexHint;
    private int statusBits;

    CaretItem(EditorCaret editorCaret, Position dotPos, Position.Bias dotBias, Position markPos, Position.Bias markBias) {
        this.editorCaret = editorCaret;
        this.dotPos = dotPos;
        this.dotBias = dotBias;
        this.markPos = markPos;
        this.markBias = markBias;
        this.statusBits = 4;
    }

    EditorCaret editorCaret() {
        return this.editorCaret;
    }

    void ensureValidInfo() {
        if (this.info == null) {
            this.info = new CaretInfo(this);
        }
    }

    void clearInfo() {
        this.info = null;
    }

    CaretInfo getValidInfo() {
        this.ensureValidInfo();
        return this.info;
    }

    @CheckForNull
    Position getDotPosition() {
        return this.dotPos;
    }

    @NonNull
    Position.Bias getDotBias() {
        return this.dotBias;
    }

    @CheckForNull
    Position getMarkPosition() {
        return this.markPos;
    }

    @NonNull
    Position.Bias getMarkBias() {
        return this.markBias;
    }

    int getDot() {
        return this.dotPos != null ? this.dotPos.getOffset() : 0;
    }

    int getMark() {
        return this.markPos != null ? this.markPos.getOffset() : 0;
    }

    boolean isSelection() {
        return this.dotPos != null && this.markPos != null && this.markPos != this.dotPos && this.dotPos.getOffset() != this.markPos.getOffset();
    }

    boolean isSelectionShowing() {
        return this.editorCaret.isSelectionVisible() && this.isSelection();
    }

    Position getSelectionStart() {
        return this.dotPos;
    }

    Position getSelectionEnd() {
        return this.dotPos;
    }

    Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    void setDotPos(Position dotPos) {
        this.dotPos = dotPos;
    }

    void setMarkPos(Position markPos) {
        this.markPos = markPos;
    }

    void setMagicCaretPosition(Point newMagicCaretPosition) {
        this.magicCaretPosition = newMagicCaretPosition;
    }

    synchronized Rectangle setCaretBoundsWithRepaint(Rectangle newCaretBounds, JTextComponent c, String logMessage, int logIndex) {
        Rectangle oldCaretBounds = this.caretBounds;
        boolean repaintOld = oldCaretBounds != null && (this.statusBits & 8) != 0;
        this.statusBits &= 0xFFFFFFF3;
        boolean log = EditorCaret.LOG.isLoggable(Level.FINE);
        if (repaintOld) {
            if (log) {
                this.logRepaint(logMessage + "-setBoundsRepaint-repaintOld", logIndex, oldCaretBounds);
            }
            c.repaint(oldCaretBounds);
        }
        if (!repaintOld || !newCaretBounds.equals(oldCaretBounds)) {
            if (log) {
                this.logRepaint(logMessage + "-setBoundsRepaint-repaintNew", logIndex, newCaretBounds);
            }
            c.repaint(newCaretBounds);
        }
        this.caretBounds = newCaretBounds;
        return oldCaretBounds;
    }

    synchronized Rectangle setCaretBounds(Rectangle newCaretBounds) {
        Rectangle oldCaretBounds = this.caretBounds;
        this.statusBits &= 0xFFFFFFF3;
        this.caretBounds = newCaretBounds;
        return oldCaretBounds;
    }

    synchronized Rectangle repaint(JTextComponent c, String logMessage, int logIndex) {
        Rectangle bounds = this.caretBounds;
        if (bounds != null) {
            this.statusBits &= 0xFFFFFFF7;
            if (EditorCaret.LOG.isLoggable(Level.FINE)) {
                this.logRepaint(logMessage, logIndex, bounds);
            }
            c.repaint(bounds);
        }
        return bounds;
    }

    synchronized Rectangle repaintIfShowing(JTextComponent c, String logMessage, int logIndex) {
        Rectangle bounds = this.caretBounds;
        if (bounds != null) {
            boolean repaint;
            boolean bl = repaint = (this.statusBits & 8) != 0;
            if (repaint) {
                this.statusBits &= 0xFFFFFFF7;
                if (EditorCaret.LOG.isLoggable(Level.FINE)) {
                    this.logRepaint(logMessage + "-repaintIfShowing", logIndex, bounds);
                }
                c.repaint(bounds);
            }
        }
        return bounds;
    }

    synchronized Rectangle getCaretBounds() {
        return this.caretBounds;
    }

    int getTransactionIndexHint() {
        return this.transactionIndexHint;
    }

    void setTransactionIndexHint(int transactionIndexHint) {
        this.transactionIndexHint = transactionIndexHint;
    }

    synchronized void markRemovedInTransaction() {
        this.statusBits |= 1;
    }

    synchronized boolean getAndClearRemovedInTransaction() {
        boolean ret = (this.statusBits & 1) != 0;
        this.statusBits &= 0xFFFFFFFE;
        return ret;
    }

    synchronized void markInfoObsolete() {
        this.statusBits |= 2;
    }

    synchronized boolean getAndClearInfoObsolete() {
        boolean ret = (this.statusBits & 2) != 0;
        this.statusBits &= 0xFFFFFFFD;
        return ret;
    }

    synchronized void markUpdateCaretBounds() {
        this.statusBits |= 4;
    }

    synchronized boolean getAndClearUpdateCaretBounds() {
        boolean ret = (this.statusBits & 4) != 0;
        this.statusBits &= 0xFFFFFFFB;
        return ret;
    }

    synchronized void markCaretPainted() {
        this.statusBits |= 8;
    }

    public int compareTo(Object o) {
        return this.getDot() - ((CaretItem)o).getDot();
    }

    void logRepaint(String logMessage, int itemIndex, Rectangle r) {
        EditorCaret.LOG.fine(logMessage + (itemIndex != -1 ? (itemIndex != -2 ? "[" + itemIndex + "]" : "LAST") : "") + ": Rect=" + CaretItem.r2s(r) + ", item=" + this + "\n");
    }

    static String r2s(Rectangle r) {
        return r != null ? "[x=" + r.x + ",y=" + r.y + ",w=" + r.width + ",h=" + r.height + "]" : null;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("CI@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", dot=").append(this.dotPos).append(", mark=").append(this.markPos);
        if ((this.statusBits & 1) != 0) {
            sb.append(" REMOVED_IN_TRANSACTION");
        }
        if ((this.statusBits & 2) != 0) {
            sb.append(" INFO_OBSOLETE");
        }
        if ((this.statusBits & 4) != 0) {
            sb.append(" UPDATE_CARET_BOUNDS");
        }
        if ((this.statusBits & 8) != 0) {
            sb.append(" CARET_PAINTED");
        }
        return sb.toString();
    }

    public synchronized String toStringDetail() {
        return this.toString() + ", bounds=" + CaretItem.r2s(this.caretBounds) + ", magicCP=" + this.magicCaretPosition;
    }
}

