/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.AddonVersions;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AddonOptionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="addonSchemaVersion")
    private final String addonSchemaVersion;
    @JsonProperty(value="addonGroup")
    private final String addonGroup;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="isEssential")
    private final Boolean isEssential;
    @JsonProperty(value="versions")
    private final List<AddonVersions> versions;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"name", "addonSchemaVersion", "addonGroup", "lifecycleState", "description", "isEssential", "versions", "freeformTags", "definedTags", "systemTags", "timeCreated"})
    public AddonOptionSummary(String name, String addonSchemaVersion, String addonGroup, LifecycleState lifecycleState, String description, Boolean isEssential, List<AddonVersions> versions, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, Date timeCreated) {
        this.name = name;
        this.addonSchemaVersion = addonSchemaVersion;
        this.addonGroup = addonGroup;
        this.lifecycleState = lifecycleState;
        this.description = description;
        this.isEssential = isEssential;
        this.versions = versions;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getAddonSchemaVersion() {
        return this.addonSchemaVersion;
    }

    public String getAddonGroup() {
        return this.addonGroup;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsEssential() {
        return this.isEssential;
    }

    public List<AddonVersions> getVersions() {
        return this.versions;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AddonOptionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", addonSchemaVersion=").append(String.valueOf(this.addonSchemaVersion));
        sb.append(", addonGroup=").append(String.valueOf(this.addonGroup));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", isEssential=").append(String.valueOf(this.isEssential));
        sb.append(", versions=").append(String.valueOf(this.versions));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddonOptionSummary)) {
            return false;
        }
        AddonOptionSummary other = (AddonOptionSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.addonSchemaVersion, other.addonSchemaVersion) && Objects.equals(this.addonGroup, other.addonGroup) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.description, other.description) && Objects.equals(this.isEssential, other.isEssential) && Objects.equals(this.versions, other.versions) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.addonSchemaVersion == null ? 43 : this.addonSchemaVersion.hashCode());
        result = result * 59 + (this.addonGroup == null ? 43 : this.addonGroup.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.isEssential == null ? 43 : this.isEssential.hashCode());
        result = result * 59 + (this.versions == null ? 43 : this.versions.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="addonSchemaVersion")
        private String addonSchemaVersion;
        @JsonProperty(value="addonGroup")
        private String addonGroup;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isEssential")
        private Boolean isEssential;
        @JsonProperty(value="versions")
        private List<AddonVersions> versions;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder addonSchemaVersion(String addonSchemaVersion) {
            this.addonSchemaVersion = addonSchemaVersion;
            this.__explicitlySet__.add("addonSchemaVersion");
            return this;
        }

        public Builder addonGroup(String addonGroup) {
            this.addonGroup = addonGroup;
            this.__explicitlySet__.add("addonGroup");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isEssential(Boolean isEssential) {
            this.isEssential = isEssential;
            this.__explicitlySet__.add("isEssential");
            return this;
        }

        public Builder versions(List<AddonVersions> versions) {
            this.versions = versions;
            this.__explicitlySet__.add("versions");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public AddonOptionSummary build() {
            AddonOptionSummary model = new AddonOptionSummary(this.name, this.addonSchemaVersion, this.addonGroup, this.lifecycleState, this.description, this.isEssential, this.versions, this.freeformTags, this.definedTags, this.systemTags, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AddonOptionSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("addonSchemaVersion")) {
                this.addonSchemaVersion(model.getAddonSchemaVersion());
            }
            if (model.wasPropertyExplicitlySet("addonGroup")) {
                this.addonGroup(model.getAddonGroup());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("isEssential")) {
                this.isEssential(model.getIsEssential());
            }
            if (model.wasPropertyExplicitlySet("versions")) {
                this.versions(model.getVersions());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

