/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.ClusterPodNetworkOptionDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ClusterOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="kubernetesVersions")
    private final List<String> kubernetesVersions;
    @JsonProperty(value="clusterPodNetworkOptions")
    private final List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions;

    @Deprecated
    @ConstructorProperties(value={"kubernetesVersions", "clusterPodNetworkOptions"})
    public ClusterOptions(List<String> kubernetesVersions, List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions) {
        this.kubernetesVersions = kubernetesVersions;
        this.clusterPodNetworkOptions = clusterPodNetworkOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getKubernetesVersions() {
        return this.kubernetesVersions;
    }

    public List<ClusterPodNetworkOptionDetails> getClusterPodNetworkOptions() {
        return this.clusterPodNetworkOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterOptions(");
        sb.append("super=").append(super.toString());
        sb.append("kubernetesVersions=").append(String.valueOf(this.kubernetesVersions));
        sb.append(", clusterPodNetworkOptions=").append(String.valueOf(this.clusterPodNetworkOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterOptions)) {
            return false;
        }
        ClusterOptions other = (ClusterOptions)((Object)o);
        return Objects.equals(this.kubernetesVersions, other.kubernetesVersions) && Objects.equals(this.clusterPodNetworkOptions, other.clusterPodNetworkOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.kubernetesVersions == null ? 43 : this.kubernetesVersions.hashCode());
        result = result * 59 + (this.clusterPodNetworkOptions == null ? 43 : this.clusterPodNetworkOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="kubernetesVersions")
        private List<String> kubernetesVersions;
        @JsonProperty(value="clusterPodNetworkOptions")
        private List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder kubernetesVersions(List<String> kubernetesVersions) {
            this.kubernetesVersions = kubernetesVersions;
            this.__explicitlySet__.add("kubernetesVersions");
            return this;
        }

        public Builder clusterPodNetworkOptions(List<ClusterPodNetworkOptionDetails> clusterPodNetworkOptions) {
            this.clusterPodNetworkOptions = clusterPodNetworkOptions;
            this.__explicitlySet__.add("clusterPodNetworkOptions");
            return this;
        }

        public ClusterOptions build() {
            ClusterOptions model = new ClusterOptions(this.kubernetesVersions, this.clusterPodNetworkOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClusterOptions model) {
            if (model.wasPropertyExplicitlySet("kubernetesVersions")) {
                this.kubernetesVersions(model.getKubernetesVersions());
            }
            if (model.wasPropertyExplicitlySet("clusterPodNetworkOptions")) {
                this.clusterPodNetworkOptions(model.getClusterPodNetworkOptions());
            }
            return this;
        }
    }
}

