/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.options;

import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.phpunit.commands.SkeletonGenerator;
import org.netbeans.modules.php.phpunit.util.PhpUnitUtils;

public final class PhpUnitOptionsValidator {
    private final ValidationResult result = new ValidationResult();

    public PhpUnitOptionsValidator validate(String phpUnitPath, String skeletnGeneratorPath) {
        this.validatePhpUnitPath(phpUnitPath);
        this.validateSkeletonGeneratorPath(skeletnGeneratorPath);
        return this;
    }

    public ValidationResult getResult() {
        return this.result;
    }

    public PhpUnitOptionsValidator validatePhpUnitPath(String phpUnitPath) {
        String warning = PhpUnitUtils.validatePhpUnitPath(phpUnitPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"phpUnitPath", warning));
        }
        return this;
    }

    private PhpUnitOptionsValidator validateSkeletonGeneratorPath(String skeletonGeneratorPath) {
        String warning = SkeletonGenerator.validate(skeletonGeneratorPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"skeletonGeneratorPath", warning));
        }
        return this;
    }
}

