/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.build.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.clientproject.build.AdvancedTask;
import org.netbeans.modules.web.clientproject.build.AdvancedTasksStorage;
import org.netbeans.modules.web.clientproject.build.Tasks;
import org.netbeans.modules.web.clientproject.build.ui.AdvancedTasksPanel;
import org.netbeans.modules.web.clientproject.build.ui.Bundle;
import org.netbeans.modules.web.clientproject.build.ui.VerticalGridLayout;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class TasksMenu
extends JMenu {
    static final Logger LOGGER = Logger.getLogger(TasksMenu.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(TasksMenu.class);
    final BuildTools.TasksMenuSupport support;
    final AdvancedTasksStorage advancedTasksStorage;
    final Object lock = new Object();
    private boolean menuBuilt = false;
    private volatile Tasks tasks = null;

    public TasksMenu(BuildTools.TasksMenuSupport support) {
        super(support.getTitle(BuildTools.TasksMenuSupport.Title.MENU));
        this.support = support;
        this.advancedTasksStorage = AdvancedTasksStorage.forBuildToolSupport(support);
    }

    boolean isMenuBuilt() {
        assert (EventQueue.isDispatchThread());
        return this.menuBuilt;
    }

    void setMenuBuilt(boolean menuBuilt) {
        assert (EventQueue.isDispatchThread());
        this.menuBuilt = menuBuilt;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        assert (EventQueue.isDispatchThread());
        if (!this.isMenuBuilt()) {
            this.setMenuBuilt(true);
            this.buildMenu();
        }
        return super.getPopupMenu();
    }

    private void buildMenu() {
        assert (EventQueue.isDispatchThread());
        assert (this.tasks == null) : this.tasks;
        this.addLoadingMenuItem();
        RP.post(new Runnable(){

            @Override
            public void run() {
                AdvancedTasksStorage.Data data = TasksMenu.this.advancedTasksStorage.loadTasks();
                Future<List<String>> simpleTasks = TasksMenu.this.support.getTasks();
                try {
                    TasksMenu.this.tasks = new Tasks(data.getTasks(), data.isShowSimpleTasks(), simpleTasks.get(1L, TimeUnit.MINUTES));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    TasksMenu.this.errorOccured(Bundle.TasksMenu_error_execution(TasksMenu.this.support.getTitle(BuildTools.TasksMenuSupport.Title.MENU), ProjectUtils.getInformation((Project)TasksMenu.this.support.getProject()).getDisplayName()));
                }
                catch (TimeoutException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    TasksMenu.this.errorOccured(Bundle.TasksMenu_error_timeout(TasksMenu.this.support.getTitle(BuildTools.TasksMenuSupport.Title.MENU), ProjectUtils.getInformation((Project)TasksMenu.this.support.getProject()).getDisplayName()));
                }
                TasksMenu.this.rebuildMenu();
            }
        });
    }

    void rebuildMenu() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TasksMenu.this.removeAll();
                TasksMenu.this.addMenuItems();
                TasksMenu.this.refreshMenu();
            }
        });
    }

    void errorOccured(String message) {
        if (this.isShowing()) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
        }
    }

    void refreshMenu() {
        JPopupMenu popupMenu = this.getPopupMenu();
        popupMenu.pack();
        popupMenu.invalidate();
        popupMenu.revalidate();
        popupMenu.repaint();
    }

    void addMenuItems() {
        assert (EventQueue.isDispatchThread());
        if (this.tasks == null || this.tasks.getSimpleTasks() == null) {
            this.addConfigureToolMenuItem();
            return;
        }
        VerticalGridLayout vgl = new VerticalGridLayout();
        this.getPopupMenu().setLayout(vgl);
        List<String> simpleTasks = this.tasks.getSimpleTasks();
        assert (simpleTasks != null);
        LinkedHashSet<String> allTasks = new LinkedHashSet<String>(simpleTasks);
        String defaultTaskName = this.support.getDefaultTaskName();
        if (defaultTaskName != null) {
            allTasks.remove(defaultTaskName);
            this.addTaskMenuItem(true, defaultTaskName);
            this.addSeparator();
        }
        this.addAdvancedTasksMenuItems();
        if (this.tasks.isShowSimpleTasks()) {
            this.addTasksMenuItems(allTasks);
        }
        if (!this.tasks.getAdvancedTasks().isEmpty() || this.tasks.isShowSimpleTasks() && !allTasks.isEmpty()) {
            this.addSeparator();
        }
        this.addManageMenuItems(allTasks);
        this.addReloadTasksMenuItem();
    }

    @CheckForNull
    private void addTasksMenuItems(Collection<String> tasks) {
        assert (EventQueue.isDispatchThread());
        assert (tasks != null);
        for (String task : tasks) {
            this.addTaskMenuItem(false, task);
        }
    }

    private void addAdvancedTasksMenuItems() {
        assert (EventQueue.isDispatchThread());
        assert (this.tasks != null);
        for (AdvancedTask task : this.tasks.getAdvancedTasks()) {
            this.addTaskMenuItem(task);
        }
    }

    private void addManageMenuItems(final Collection<String> simpleTasks) {
        assert (EventQueue.isDispatchThread());
        assert (simpleTasks != null);
        JMenuItem menuItem = new JMenuItem(Bundle.TasksMenu_menu_manage());
        menuItem.addActionListener(new ActionListener(){
            final /* synthetic */ TasksMenu this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                assert (EventQueue.isDispatchThread());
                ArrayList<String> simpleTasksWithDefaultTask = new ArrayList<String>(simpleTasks.size() + 1);
                simpleTasksWithDefaultTask.add("");
                simpleTasksWithDefaultTask.addAll(simpleTasks);
                AdvancedTasksPanel panel = AdvancedTasksPanel.open(this.this$0.support.getTitle(BuildTools.TasksMenuSupport.Title.MANAGE_ADVANCED), this.this$0.support.getTitle(BuildTools.TasksMenuSupport.Title.TASKS_LABEL), this.this$0.support.getBuildToolExecName(), simpleTasksWithDefaultTask, this.this$0.tasks.getAdvancedTasks(), this.this$0.tasks.isShowSimpleTasks());
                if (panel != null) {
                    AdvancedTasksStorage.Data data;
                    Object object = this.this$0.lock;
                    synchronized (object) {
                        data = new AdvancedTasksStorage.Data().setTasks(panel.getTasks()).setShowSimpleTasks(panel.isShowSimpleTasks());
                    }
                    RP.post(new Runnable(){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            assert (!EventQueue.isDispatchThread());
                            try {
                                Object object = this.this$1.this$0.lock;
                                synchronized (object) {
                                    this.this$1.this$0.advancedTasksStorage.storeTasks(data);
                                }
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.INFO, "Cannot store tasks", ex);
                            }
                        }
                    });
                }
            }
        });
        this.add(menuItem);
    }

    private void addTaskMenuItem(final boolean isDefault, final String task) {
        JMenuItem menuitem = new JMenuItem(task);
        menuitem.addActionListener(new ActionListener(){
            final /* synthetic */ TasksMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RP.post(new Runnable(){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        if (isDefault) {
                            this.this$1.this$0.support.runTask(new String[0]);
                        } else {
                            this.this$1.this$0.support.runTask(task);
                        }
                    }
                });
            }
        });
        this.add(menuitem);
    }

    private void addTaskMenuItem(final AdvancedTask task) {
        assert (task != null);
        JMenuItem menuitem = new JMenuItem(task.getName());
        menuitem.addActionListener(new ActionListener(){
            final /* synthetic */ TasksMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RP.post(new Runnable(){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        String fullCommand = task.getFullCommand();
                        if (StringUtilities.hasText(fullCommand)) {
                            this.this$1.this$0.support.runTask(Utilities.parseParameters((String)fullCommand));
                        } else {
                            this.this$1.this$0.support.runTask(new String[0]);
                        }
                    }
                });
            }
        });
        this.add(menuitem);
    }

    private void addLoadingMenuItem() {
        JMenuItem menuItem = new JMenuItem(this.support.getTitle(BuildTools.TasksMenuSupport.Title.LOADING_TASKS));
        menuItem.setEnabled(false);
        this.add(menuItem);
    }

    private void addConfigureToolMenuItem() {
        JMenuItem menuItem = new JMenuItem(this.support.getTitle(BuildTools.TasksMenuSupport.Title.CONFIGURE_TOOL));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksMenu.this.support.configure();
            }
        });
        this.add(menuItem);
    }

    private void addReloadTasksMenuItem() {
        JMenuItem menuItem = new JMenuItem(Bundle.TasksMenu_menu_reload());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                assert (EventQueue.isDispatchThread());
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        TasksMenu.this.support.reloadTasks();
                    }
                });
                TasksMenu.this.setMenuBuilt(false);
            }
        });
        this.add(menuItem);
    }
}

