/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatus;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent;
import io.fabric8.kubernetes.api.model.storage.VolumeError;
import io.fabric8.kubernetes.api.model.storage.VolumeErrorBuilder;
import io.fabric8.kubernetes.api.model.storage.VolumeErrorFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class VolumeAttachmentStatusFluentImpl<A extends VolumeAttachmentStatusFluent<A>>
extends BaseFluent<A>
implements VolumeAttachmentStatusFluent<A> {
    private VolumeErrorBuilder attachError;
    private Boolean attached;
    private Map<String, String> attachmentMetadata;
    private VolumeErrorBuilder detachError;
    private Map<String, Object> additionalProperties;

    public VolumeAttachmentStatusFluentImpl() {
    }

    public VolumeAttachmentStatusFluentImpl(VolumeAttachmentStatus instance) {
        if (instance != null) {
            this.withAttachError(instance.getAttachError());
            this.withAttached(instance.getAttached());
            this.withAttachmentMetadata(instance.getAttachmentMetadata());
            this.withDetachError(instance.getDetachError());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    @Deprecated
    public VolumeError getAttachError() {
        return this.attachError != null ? this.attachError.build() : null;
    }

    @Override
    public VolumeError buildAttachError() {
        return this.attachError != null ? this.attachError.build() : null;
    }

    @Override
    public A withAttachError(VolumeError attachError) {
        this._visitables.get((Object)"attachError").remove(this.attachError);
        if (attachError != null) {
            this.attachError = new VolumeErrorBuilder(attachError);
            this._visitables.get((Object)"attachError").add(this.attachError);
        } else {
            this.attachError = null;
            this._visitables.get((Object)"attachError").remove(this.attachError);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAttachError() {
        return this.attachError != null;
    }

    @Override
    public A withNewAttachError(String message, String time) {
        return this.withAttachError(new VolumeError(message, time));
    }

    @Override
    public VolumeAttachmentStatusFluent.AttachErrorNested<A> withNewAttachError() {
        return new AttachErrorNestedImpl();
    }

    @Override
    public VolumeAttachmentStatusFluent.AttachErrorNested<A> withNewAttachErrorLike(VolumeError item) {
        return new AttachErrorNestedImpl(item);
    }

    @Override
    public VolumeAttachmentStatusFluent.AttachErrorNested<A> editAttachError() {
        return this.withNewAttachErrorLike(this.getAttachError());
    }

    @Override
    public VolumeAttachmentStatusFluent.AttachErrorNested<A> editOrNewAttachError() {
        return this.withNewAttachErrorLike(this.getAttachError() != null ? this.getAttachError() : new VolumeErrorBuilder().build());
    }

    @Override
    public VolumeAttachmentStatusFluent.AttachErrorNested<A> editOrNewAttachErrorLike(VolumeError item) {
        return this.withNewAttachErrorLike(this.getAttachError() != null ? this.getAttachError() : item);
    }

    @Override
    public Boolean getAttached() {
        return this.attached;
    }

    @Override
    public A withAttached(Boolean attached) {
        this.attached = attached;
        return (A)this;
    }

    @Override
    public Boolean hasAttached() {
        return this.attached != null;
    }

    @Override
    public A addToAttachmentMetadata(String key, String value) {
        if (this.attachmentMetadata == null && key != null && value != null) {
            this.attachmentMetadata = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.attachmentMetadata.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAttachmentMetadata(Map<String, String> map) {
        if (this.attachmentMetadata == null && map != null) {
            this.attachmentMetadata = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.attachmentMetadata.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAttachmentMetadata(String key) {
        if (this.attachmentMetadata == null) {
            return (A)this;
        }
        if (key != null && this.attachmentMetadata != null) {
            this.attachmentMetadata.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAttachmentMetadata(Map<String, String> map) {
        if (this.attachmentMetadata == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.attachmentMetadata == null) continue;
                this.attachmentMetadata.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    @Override
    public <K, V> A withAttachmentMetadata(Map<String, String> attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata == null ? null : new LinkedHashMap<String, String>(attachmentMetadata);
        return (A)this;
    }

    @Override
    public Boolean hasAttachmentMetadata() {
        return this.attachmentMetadata != null;
    }

    @Override
    @Deprecated
    public VolumeError getDetachError() {
        return this.detachError != null ? this.detachError.build() : null;
    }

    @Override
    public VolumeError buildDetachError() {
        return this.detachError != null ? this.detachError.build() : null;
    }

    @Override
    public A withDetachError(VolumeError detachError) {
        this._visitables.get((Object)"detachError").remove(this.detachError);
        if (detachError != null) {
            this.detachError = new VolumeErrorBuilder(detachError);
            this._visitables.get((Object)"detachError").add(this.detachError);
        } else {
            this.detachError = null;
            this._visitables.get((Object)"detachError").remove(this.detachError);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDetachError() {
        return this.detachError != null;
    }

    @Override
    public A withNewDetachError(String message, String time) {
        return this.withDetachError(new VolumeError(message, time));
    }

    @Override
    public VolumeAttachmentStatusFluent.DetachErrorNested<A> withNewDetachError() {
        return new DetachErrorNestedImpl();
    }

    @Override
    public VolumeAttachmentStatusFluent.DetachErrorNested<A> withNewDetachErrorLike(VolumeError item) {
        return new DetachErrorNestedImpl(item);
    }

    @Override
    public VolumeAttachmentStatusFluent.DetachErrorNested<A> editDetachError() {
        return this.withNewDetachErrorLike(this.getDetachError());
    }

    @Override
    public VolumeAttachmentStatusFluent.DetachErrorNested<A> editOrNewDetachError() {
        return this.withNewDetachErrorLike(this.getDetachError() != null ? this.getDetachError() : new VolumeErrorBuilder().build());
    }

    @Override
    public VolumeAttachmentStatusFluent.DetachErrorNested<A> editOrNewDetachErrorLike(VolumeError item) {
        return this.withNewDetachErrorLike(this.getDetachError() != null ? this.getDetachError() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeAttachmentStatusFluentImpl that = (VolumeAttachmentStatusFluentImpl)o;
        if (!Objects.equals(this.attachError, that.attachError)) {
            return false;
        }
        if (!Objects.equals(this.attached, that.attached)) {
            return false;
        }
        if (!Objects.equals(this.attachmentMetadata, that.attachmentMetadata)) {
            return false;
        }
        if (!Objects.equals(this.detachError, that.detachError)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attachError, this.attached, this.attachmentMetadata, this.detachError, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachError != null) {
            sb.append("attachError:");
            sb.append(this.attachError + ",");
        }
        if (this.attached != null) {
            sb.append("attached:");
            sb.append(this.attached + ",");
        }
        if (this.attachmentMetadata != null && !this.attachmentMetadata.isEmpty()) {
            sb.append("attachmentMetadata:");
            sb.append(this.attachmentMetadata + ",");
        }
        if (this.detachError != null) {
            sb.append("detachError:");
            sb.append(this.detachError + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAttached() {
        return this.withAttached(true);
    }

    class DetachErrorNestedImpl<N>
    extends VolumeErrorFluentImpl<VolumeAttachmentStatusFluent.DetachErrorNested<N>>
    implements VolumeAttachmentStatusFluent.DetachErrorNested<N>,
    Nested<N> {
        VolumeErrorBuilder builder;

        DetachErrorNestedImpl(VolumeError item) {
            this.builder = new VolumeErrorBuilder(this, item);
        }

        DetachErrorNestedImpl() {
            this.builder = new VolumeErrorBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeAttachmentStatusFluentImpl.this.withDetachError(this.builder.build());
        }

        @Override
        public N endDetachError() {
            return this.and();
        }
    }

    class AttachErrorNestedImpl<N>
    extends VolumeErrorFluentImpl<VolumeAttachmentStatusFluent.AttachErrorNested<N>>
    implements VolumeAttachmentStatusFluent.AttachErrorNested<N>,
    Nested<N> {
        VolumeErrorBuilder builder;

        AttachErrorNestedImpl(VolumeError item) {
            this.builder = new VolumeErrorBuilder(this, item);
        }

        AttachErrorNestedImpl() {
            this.builder = new VolumeErrorBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeAttachmentStatusFluentImpl.this.withAttachError(this.builder.build());
        }

        @Override
        public N endAttachError() {
            return this.and();
        }
    }
}

