/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.terraform;

import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.languages.hcl.HCLParserResult;
import org.netbeans.modules.languages.hcl.HCLSemanticAnalyzer;
import org.netbeans.modules.languages.hcl.SourceRef;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.HCLResolveOperation;
import org.netbeans.modules.languages.hcl.ast.HCLTreeWalker;
import org.netbeans.modules.languages.hcl.ast.HCLVariable;
import org.netbeans.modules.languages.hcl.terraform.TerraformParserResult;

public final class TerraformSemanticAnalyzer
extends HCLSemanticAnalyzer {
    private static final Set<String> RESOLVE_BASES = Set.of("data", "local", "module", "path", "provider", "var");
    private static final Set<String> LITERAL_TYPES = Set.of("bool", "number", "null", "string");

    @Override
    protected HCLSemanticAnalyzer.Highlighter createHighlighter(HCLParserResult result) {
        return new TerraformHighlighter(result.getReferences());
    }

    private class TerraformHighlighter
    extends HCLSemanticAnalyzer.DefaultHighlighter {
        private TerraformParserResult.BlockType rootBlockType;

        protected TerraformHighlighter(SourceRef refs) {
            super(refs);
        }

        @Override
        protected void highlight(HCLTreeWalker.Step step) {
            HCLElement hCLElement;
            super.highlight(step);
            if (step.depth() == 1 && (hCLElement = step.node()) instanceof HCLBlock) {
                HCLBlock block = (HCLBlock)hCLElement;
                dcl = block.declaration();
                if (!dcl.isEmpty()) {
                    this.rootBlockType = TerraformParserResult.BlockType.get(((HCLIdentifier)dcl.get(0)).id());
                }
            } else {
                HCLVariable var;
                String name;
                HCLElement var2;
                dcl = step.node();
                if (dcl instanceof HCLResolveOperation.Attribute) {
                    HCLExpression hCLExpression;
                    HCLResolveOperation.Attribute attr = (HCLResolveOperation.Attribute)dcl;
                    if (this.rootBlockType != null && (hCLExpression = attr.base()) instanceof HCLVariable) {
                        var2 = (HCLVariable)hCLExpression;
                        String name2 = ((HCLVariable)var2).name().id();
                        switch (this.rootBlockType) {
                            case CHECK: 
                            case DATA: 
                            case LOCALS: 
                            case MODULE: 
                            case OUTPUT: 
                            case PROVIDER: 
                            case RESOURCE: {
                                if (!RESOLVE_BASES.contains(name2)) break;
                                this.mark(attr.base(), ColoringAttributes.FIELD_SET);
                            }
                        }
                    }
                } else if (this.rootBlockType == TerraformParserResult.BlockType.VARIABLE && (var2 = step.node()) instanceof HCLVariable && LITERAL_TYPES.contains(name = (var = (HCLVariable)var2).name().id())) {
                    this.mark(var, ColoringAttributes.FIELD_SET);
                }
            }
        }
    }
}

