/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.indices.TermsLookup;
import org.opensearch.protobufs.FieldValue;
import org.opensearch.protobufs.FieldValueArray;
import org.opensearch.protobufs.TermsQuery;
import org.opensearch.protobufs.TermsQueryField;
import org.opensearch.protobufs.TermsQueryValueType;
import org.opensearch.protobufs.ValueType;
import org.opensearch.transport.grpc.proto.response.common.FieldValueProtoUtils;

class TermsQueryBuilderProtoUtils {
    private TermsQueryBuilderProtoUtils() {
    }

    static TermsQueryBuilder fromProto(TermsQuery termsQueryProto) {
        if (termsQueryProto == null) {
            throw new IllegalArgumentException("TermsQuery must not be null");
        }
        if (termsQueryProto.getTermsCount() != 1) {
            throw new IllegalArgumentException("TermsQuery must contain exactly one field, found: " + termsQueryProto.getTermsCount());
        }
        String fieldName = (String)termsQueryProto.getTermsMap().keySet().iterator().next();
        TermsQueryField termsQueryField = (TermsQueryField)termsQueryProto.getTermsMap().get(fieldName);
        TermsQueryValueType vt = termsQueryProto.hasValueType() ? termsQueryProto.getValueType() : TermsQueryValueType.TERMS_QUERY_VALUE_TYPE_DEFAULT;
        TermsQueryBuilder builder = TermsQueryBuilderProtoUtils.fromProto(fieldName, termsQueryField, vt);
        if (termsQueryProto.hasBoost()) {
            builder.boost(termsQueryProto.getBoost());
        }
        if (termsQueryProto.hasXName()) {
            builder.queryName(termsQueryProto.getXName());
        }
        return builder;
    }

    static TermsQueryBuilder fromProto(TermsQueryField termsQueryProto) {
        TermsQueryBuilder termsQueryBuilder;
        String fieldName = null;
        List<Object> values = null;
        TermsLookup termsLookup = null;
        switch (termsQueryProto.getTermsQueryFieldCase()) {
            case FIELD_VALUE_ARRAY: {
                values = TermsQueryBuilderProtoUtils.parseFieldValueArray(termsQueryProto.getFieldValueArray());
                break;
            }
            case LOOKUP: {
                termsLookup = TermsQueryBuilderProtoUtils.parseTermsLookup(termsQueryProto.getLookup());
                break;
            }
            default: {
                throw new IllegalArgumentException("Neither field_value_array nor lookup is set");
            }
        }
        if (values == null && termsLookup == null) {
            throw new IllegalArgumentException("Either field_value_array or lookup must be set");
        }
        if (values == null) {
            termsQueryBuilder = new TermsQueryBuilder(fieldName, termsLookup);
        } else if (termsLookup == null) {
            termsQueryBuilder = new TermsQueryBuilder(fieldName, values);
        } else {
            throw new IllegalArgumentException("values and termsLookup cannot both be null");
        }
        return termsQueryBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static TermsQueryBuilder fromProto(String fieldName, TermsQueryField termsQueryField, TermsQueryValueType valueTypeProto) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("fieldName must be provided");
        }
        List<Object> values = null;
        TermsLookup termsLookup = null;
        switch (termsQueryField.getTermsQueryFieldCase()) {
            case FIELD_VALUE_ARRAY: {
                values = TermsQueryBuilderProtoUtils.parseFieldValueArray(termsQueryField.getFieldValueArray());
                break;
            }
            case LOOKUP: {
                termsLookup = TermsQueryBuilderProtoUtils.parseTermsLookup(termsQueryField.getLookup());
                break;
            }
            default: {
                throw new IllegalArgumentException("Neither field_value_array nor lookup is set");
            }
        }
        if (values == null && termsLookup == null) {
            throw new IllegalArgumentException("Either field_value_array or lookup must be set");
        }
        TermsQueryBuilder.ValueType valueType = TermsQueryBuilderProtoUtils.parseValueType(valueTypeProto);
        if (valueType == TermsQueryBuilder.ValueType.BITMAP) {
            if (values != null && values.size() == 1) {
                Object v = values.get(0);
                if (v instanceof BytesRef) {
                    BytesRef bytesRef = (BytesRef)v;
                    byte[] decoded = Base64.getDecoder().decode(bytesRef.utf8ToString());
                    values.set(0, new BytesArray(decoded));
                } else {
                    if (!(v instanceof String)) throw new IllegalArgumentException("Invalid value for bitmap type");
                    String string = (String)v;
                    byte[] decoded = Base64.getDecoder().decode(string);
                    values.set(0, new BytesArray(decoded));
                }
            } else if (termsLookup == null) {
                throw new IllegalArgumentException("Bitmap type requires a single base64 value or a lookup");
            }
        }
        TermsQueryBuilder termsQueryBuilder = values != null ? new TermsQueryBuilder(fieldName, values) : new TermsQueryBuilder(fieldName, termsLookup);
        return termsQueryBuilder.valueType(valueType);
    }

    public static TermsQueryBuilder.ValueType parseValueType(ValueType valueType) {
        switch (valueType) {
            case VALUE_TYPE_BITMAP: {
                return TermsQueryBuilder.ValueType.BITMAP;
            }
            case VALUE_TYPE_DEFAULT: {
                return TermsQueryBuilder.ValueType.DEFAULT;
            }
        }
        return TermsQueryBuilder.ValueType.DEFAULT;
    }

    protected static TermsQueryBuilder.ValueType parseValueType(TermsQueryValueType valueTypeProto) {
        switch (valueTypeProto) {
            case TERMS_QUERY_VALUE_TYPE_BITMAP: {
                return TermsQueryBuilder.ValueType.BITMAP;
            }
        }
        return TermsQueryBuilder.ValueType.DEFAULT;
    }

    private static List<Object> parseFieldValueArray(FieldValueArray fieldValueArray) {
        if (fieldValueArray == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (FieldValue fieldValue : fieldValueArray.getFieldValueArrayList()) {
            Object convertedValue = FieldValueProtoUtils.fromProto(fieldValue);
            if (convertedValue == null) {
                throw new IllegalArgumentException("No value specified for terms query");
            }
            values.add(convertedValue);
        }
        return values;
    }

    private static TermsLookup parseTermsLookup(org.opensearch.protobufs.TermsLookup lookup) {
        if (lookup == null) {
            return null;
        }
        TermsLookup tl = new TermsLookup(lookup.getIndex(), lookup.getId(), lookup.getPath());
        if (lookup.hasRouting()) {
            tl.routing(lookup.getRouting());
        }
        return tl;
    }
}

