/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.Version;
import org.opensearch.action.ActionModule;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.cluster.ClusterSettingsResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsModule;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.discovery.InitializeExtensionRequest;
import org.opensearch.discovery.InitializeExtensionResponse;
import org.opensearch.env.EnvironmentSettingsResponse;
import org.opensearch.extensions.AddSettingsUpdateConsumerRequest;
import org.opensearch.extensions.AddSettingsUpdateConsumerRequestHandler;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.extensions.ExtensionDependency;
import org.opensearch.extensions.ExtensionDependencyResponse;
import org.opensearch.extensions.ExtensionRequest;
import org.opensearch.extensions.ExtensionsSettings;
import org.opensearch.extensions.action.ExtensionActionRequest;
import org.opensearch.extensions.action.ExtensionActionResponse;
import org.opensearch.extensions.action.ExtensionTransportActionsHandler;
import org.opensearch.extensions.action.RegisterTransportActionsRequest;
import org.opensearch.extensions.action.RemoteExtensionActionResponse;
import org.opensearch.extensions.action.TransportActionRequestFromExtension;
import org.opensearch.extensions.rest.RegisterRestActionsRequest;
import org.opensearch.extensions.rest.RestActionsRequestHandler;
import org.opensearch.extensions.settings.CustomSettingsRequestHandler;
import org.opensearch.extensions.settings.RegisterCustomSettingsRequest;
import org.opensearch.identity.IdentityService;
import org.opensearch.identity.tokens.AuthToken;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.node.NodeClient;

public class ExtensionsManager {
    public static final String REQUEST_EXTENSION_ACTION_NAME = "internal:discovery/extensions";
    public static final String REQUEST_EXTENSION_CLUSTER_STATE = "internal:discovery/clusterstate";
    public static final String REQUEST_EXTENSION_CLUSTER_SETTINGS = "internal:discovery/clustersettings";
    public static final String REQUEST_EXTENSION_ENVIRONMENT_SETTINGS = "internal:discovery/enviornmentsettings";
    public static final String REQUEST_EXTENSION_ADD_SETTINGS_UPDATE_CONSUMER = "internal:discovery/addsettingsupdateconsumer";
    public static final String REQUEST_EXTENSION_UPDATE_SETTINGS = "internal:discovery/updatesettings";
    public static final String REQUEST_EXTENSION_DEPENDENCY_INFORMATION = "internal:discovery/dependencyinformation";
    public static final String REQUEST_EXTENSION_REGISTER_CUSTOM_SETTINGS = "internal:discovery/registercustomsettings";
    public static final String REQUEST_EXTENSION_REGISTER_REST_ACTIONS = "internal:discovery/registerrestactions";
    public static final String REQUEST_EXTENSION_REGISTER_TRANSPORT_ACTIONS = "internal:discovery/registertransportactions";
    public static final String REQUEST_REST_EXECUTE_ON_EXTENSION_ACTION = "internal:extensions/restexecuteonextensiontaction";
    public static final String REQUEST_EXTENSION_HANDLE_TRANSPORT_ACTION = "internal:extensions/handle-transportaction";
    public static final String REQUEST_EXTENSION_HANDLE_REMOTE_TRANSPORT_ACTION = "internal:extensions/handle-remote-transportaction";
    public static final String TRANSPORT_ACTION_REQUEST_FROM_EXTENSION = "internal:extensions/request-transportaction-from-extension";
    public static final int EXTENSION_REQUEST_WAIT_TIMEOUT = 10;
    private static final Logger logger = LogManager.getLogger(ExtensionsManager.class);
    private ExtensionTransportActionsHandler extensionTransportActionsHandler;
    private Map<String, ExtensionsSettings.Extension> extensionSettingsMap;
    private Map<String, DiscoveryExtensionNode> initializedExtensions;
    private Map<String, DiscoveryExtensionNode> extensionIdMap;
    private RestActionsRequestHandler restActionsRequestHandler;
    private CustomSettingsRequestHandler customSettingsRequestHandler;
    private TransportService transportService;
    private ClusterService clusterService;
    private final Set<Setting<?>> additionalSettings;
    private Settings environmentSettings;
    private AddSettingsUpdateConsumerRequestHandler addSettingsUpdateConsumerRequestHandler;
    private NodeClient client;
    private IdentityService identityService;

    public ExtensionsManager(Set<Setting<?>> additionalSettings, IdentityService identityService) throws IOException {
        logger.info("ExtensionsManager initialized");
        this.initializedExtensions = new HashMap<String, DiscoveryExtensionNode>();
        this.extensionIdMap = new HashMap<String, DiscoveryExtensionNode>();
        this.extensionSettingsMap = new HashMap<String, ExtensionsSettings.Extension>();
        this.transportService = null;
        this.clusterService = null;
        this.additionalSettings = new HashSet();
        if (additionalSettings != null) {
            this.additionalSettings.addAll(additionalSettings);
        }
        this.client = null;
        this.extensionTransportActionsHandler = null;
        this.identityService = identityService;
    }

    public void initializeServicesAndRestHandler(ActionModule actionModule, SettingsModule settingsModule, TransportService transportService, ClusterService clusterService, Settings initialEnvironmentSettings, NodeClient client, IdentityService identityService) {
        this.restActionsRequestHandler = new RestActionsRequestHandler(actionModule.getRestController(), this.extensionIdMap, transportService, identityService);
        this.customSettingsRequestHandler = new CustomSettingsRequestHandler(settingsModule);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.environmentSettings = initialEnvironmentSettings;
        this.addSettingsUpdateConsumerRequestHandler = new AddSettingsUpdateConsumerRequestHandler(clusterService, transportService, REQUEST_EXTENSION_UPDATE_SETTINGS, settingsModule);
        this.client = client;
        this.extensionTransportActionsHandler = new ExtensionTransportActionsHandler(this.extensionIdMap, transportService, client, actionModule, this);
        this.registerRequestHandler(actionModule.getDynamicActionRegistry());
    }

    public Optional<DiscoveryExtensionNode> lookupInitializedExtensionById(String extensionId) {
        return Optional.ofNullable(this.initializedExtensions.get(extensionId));
    }

    public Optional<ExtensionsSettings.Extension> lookupExtensionSettingsById(String extensionId) {
        return Optional.ofNullable(this.extensionSettingsMap.get(extensionId));
    }

    public RemoteExtensionActionResponse handleRemoteTransportRequest(ExtensionActionRequest request) throws Exception {
        return this.extensionTransportActionsHandler.sendRemoteTransportRequestToExtension(request);
    }

    public ExtensionActionResponse handleTransportRequest(ExtensionActionRequest request) throws Exception {
        return this.extensionTransportActionsHandler.sendTransportRequestToExtension(request);
    }

    private void registerRequestHandler(ActionModule.DynamicActionRegistry dynamicActionRegistry) {
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_REGISTER_REST_ACTIONS, "generic", false, false, RegisterRestActionsRequest::new, (request, channel, task) -> channel.sendResponse(this.restActionsRequestHandler.handleRegisterRestActionsRequest((RegisterRestActionsRequest)request, dynamicActionRegistry)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_REGISTER_CUSTOM_SETTINGS, "generic", false, false, RegisterCustomSettingsRequest::new, (request, channel, task) -> channel.sendResponse(this.customSettingsRequestHandler.handleRegisterCustomSettingsRequest((RegisterCustomSettingsRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_CLUSTER_STATE, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_CLUSTER_SETTINGS, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_ENVIRONMENT_SETTINGS, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_DEPENDENCY_INFORMATION, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_ADD_SETTINGS_UPDATE_CONSUMER, "generic", false, false, AddSettingsUpdateConsumerRequest::new, (request, channel, task) -> channel.sendResponse(this.addSettingsUpdateConsumerRequestHandler.handleAddSettingsUpdateConsumerRequest((AddSettingsUpdateConsumerRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_REGISTER_TRANSPORT_ACTIONS, "generic", false, false, RegisterTransportActionsRequest::new, (request, channel, task) -> channel.sendResponse(this.extensionTransportActionsHandler.handleRegisterTransportActionsRequest((RegisterTransportActionsRequest)request)));
        this.transportService.registerRequestHandler(TRANSPORT_ACTION_REQUEST_FROM_EXTENSION, "generic", false, false, TransportActionRequestFromExtension::new, (request, channel, task) -> channel.sendResponse((TransportResponse)this.extensionTransportActionsHandler.handleTransportActionRequestFromExtension((TransportActionRequestFromExtension)request)));
    }

    public DiscoveryExtensionNode loadExtension(ExtensionsSettings.Extension extension) throws IOException {
        this.validateExtension(extension);
        DiscoveryExtensionNode discoveryExtensionNode = new DiscoveryExtensionNode(extension.getName(), extension.getUniqueId(), new TransportAddress(InetAddress.getByName(extension.getHostAddress()), Integer.parseInt(extension.getPort())), new HashMap<String, String>(), Version.fromString((String)extension.getOpensearchVersion()), Version.fromString((String)extension.getMinimumCompatibleVersion()), extension.getDependencies());
        this.extensionIdMap.put(extension.getUniqueId(), discoveryExtensionNode);
        this.extensionSettingsMap.put(extension.getUniqueId(), extension);
        logger.info("Loaded extension with uniqueId " + extension.getUniqueId() + ": " + String.valueOf(extension));
        return discoveryExtensionNode;
    }

    public void initializeExtension(ExtensionsSettings.Extension extension) throws IOException {
        DiscoveryExtensionNode node = this.loadExtension(extension);
        this.initializeExtensionNode(node);
    }

    private void validateField(String fieldName, String value) throws IOException {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IOException("Required field [" + fieldName + "] is missing in the request");
        }
    }

    private void validateExtension(ExtensionsSettings.Extension extension) throws IOException {
        this.validateField("extension name", extension.getName());
        this.validateField("extension uniqueId", extension.getUniqueId());
        this.validateField("extension host address", extension.getHostAddress());
        this.validateField("extension port", extension.getPort());
        this.validateField("extension version", extension.getVersion());
        this.validateField("opensearch version", extension.getOpensearchVersion());
        this.validateField("minimum opensearch version", extension.getMinimumCompatibleVersion());
        if (this.extensionIdMap.containsKey(extension.getUniqueId())) {
            throw new IOException("Duplicate uniqueId [" + extension.getUniqueId() + "]. Did not load extension: " + String.valueOf(extension));
        }
    }

    public void initialize() {
        for (DiscoveryExtensionNode extension : this.extensionIdMap.values()) {
            this.initializeExtensionNode(extension);
        }
    }

    public void initializeExtensionNode(final DiscoveryExtensionNode extensionNode) {
        final CompletableFuture inProgressFuture = new CompletableFuture();
        final TransportResponseHandler<InitializeExtensionResponse> initializeExtensionResponseHandler = new TransportResponseHandler<InitializeExtensionResponse>(){

            public InitializeExtensionResponse read(StreamInput in) throws IOException {
                return new InitializeExtensionResponse(in);
            }

            @Override
            public void handleResponse(InitializeExtensionResponse response) {
                for (DiscoveryExtensionNode extension : ExtensionsManager.this.extensionIdMap.values()) {
                    if (!extension.getName().equals(response.getName())) continue;
                    extension.setImplementedInterfaces(response.getImplementedInterfaces());
                    ExtensionsManager.this.initializedExtensions.put(extension.getId(), extension);
                    logger.info("Initialized extension: " + extension.getName());
                    break;
                }
                inProgressFuture.complete(response);
            }

            @Override
            public void handleException(TransportException exp) {
                logger.error((Message)new ParameterizedMessage("Extension initialization failed", new Object[0]), (Throwable)((Object)exp));
                inProgressFuture.completeExceptionally((Throwable)((Object)exp));
            }

            @Override
            public String executor() {
                return "generic";
            }
        };
        logger.info("Sending extension request type: internal:discovery/extensions");
        this.transportService.getThreadPool().generic().execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                logger.warn("Error registering extension: " + extensionNode.getId(), (Throwable)e);
                ExtensionsManager.this.extensionIdMap.remove(extensionNode.getId());
                Throwable throwable = e.getCause();
                if (throwable instanceof ConnectTransportException) {
                    ConnectTransportException connectTransportException = (ConnectTransportException)((Object)throwable);
                    logger.info("No response from extension to request.", (Throwable)e);
                    throw connectTransportException;
                }
                throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    throw runtimeException;
                }
                throwable = e.getCause();
                if (throwable instanceof Error) {
                    Error error = (Error)throwable;
                    throw error;
                }
                throw new RuntimeException(e.getCause());
            }

            @Override
            protected void doRun() throws Exception {
                ExtensionsManager.this.transportService.connectToExtensionNode(extensionNode);
                ExtensionsManager.this.transportService.sendRequest(extensionNode, ExtensionsManager.REQUEST_EXTENSION_ACTION_NAME, new InitializeExtensionRequest(ExtensionsManager.this.transportService.getLocalNode(), extensionNode, ExtensionsManager.this.issueServiceAccount(extensionNode)), initializeExtensionResponseHandler);
            }
        });
    }

    TransportResponse handleExtensionRequest(ExtensionRequest extensionRequest) throws Exception {
        switch (extensionRequest.getRequestType()) {
            case REQUEST_EXTENSION_CLUSTER_STATE: {
                return new ClusterStateResponse(this.clusterService.getClusterName(), this.clusterService.state(), false);
            }
            case REQUEST_EXTENSION_CLUSTER_SETTINGS: {
                return new ClusterSettingsResponse(this.clusterService);
            }
            case REQUEST_EXTENSION_ENVIRONMENT_SETTINGS: {
                return new EnvironmentSettingsResponse(this.environmentSettings);
            }
            case REQUEST_EXTENSION_DEPENDENCY_INFORMATION: {
                String uniqueId = extensionRequest.getUniqueId();
                if (uniqueId == null) {
                    return new ExtensionDependencyResponse(this.initializedExtensions.entrySet().stream().map(e -> (DiscoveryExtensionNode)e.getValue()).collect(Collectors.toList()));
                }
                ExtensionDependency matchingId = new ExtensionDependency(uniqueId, Version.CURRENT);
                return new ExtensionDependencyResponse(this.initializedExtensions.entrySet().stream().map(e -> (DiscoveryExtensionNode)e.getValue()).filter(e -> e.dependenciesContain(matchingId)).collect(Collectors.toList()));
            }
        }
        throw new IllegalArgumentException("Handler not present for the provided request");
    }

    private String issueServiceAccount(DiscoveryExtensionNode extension) {
        AuthToken serviceAccountToken = this.identityService.getTokenManager().issueServiceAccountToken(extension.getId());
        return serviceAccountToken.asAuthHeaderValue();
    }

    static String getRequestExtensionActionName() {
        return REQUEST_EXTENSION_ACTION_NAME;
    }

    static String getRequestExtensionClusterState() {
        return REQUEST_EXTENSION_CLUSTER_STATE;
    }

    static String getRequestExtensionClusterSettings() {
        return REQUEST_EXTENSION_CLUSTER_SETTINGS;
    }

    static Logger getLogger() {
        return logger;
    }

    TransportService getTransportService() {
        return this.transportService;
    }

    ClusterService getClusterService() {
        return this.clusterService;
    }

    Map<String, DiscoveryExtensionNode> getExtensionIdMap() {
        return this.extensionIdMap;
    }

    RestActionsRequestHandler getRestActionsRequestHandler() {
        return this.restActionsRequestHandler;
    }

    void setExtensionIdMap(Map<String, DiscoveryExtensionNode> extensionIdMap) {
        this.extensionIdMap = extensionIdMap;
    }

    void setRestActionsRequestHandler(RestActionsRequestHandler restActionsRequestHandler) {
        this.restActionsRequestHandler = restActionsRequestHandler;
    }

    void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    CustomSettingsRequestHandler getCustomSettingsRequestHandler() {
        return this.customSettingsRequestHandler;
    }

    void setCustomSettingsRequestHandler(CustomSettingsRequestHandler customSettingsRequestHandler) {
        this.customSettingsRequestHandler = customSettingsRequestHandler;
    }

    AddSettingsUpdateConsumerRequestHandler getAddSettingsUpdateConsumerRequestHandler() {
        return this.addSettingsUpdateConsumerRequestHandler;
    }

    void setAddSettingsUpdateConsumerRequestHandler(AddSettingsUpdateConsumerRequestHandler addSettingsUpdateConsumerRequestHandler) {
        this.addSettingsUpdateConsumerRequestHandler = addSettingsUpdateConsumerRequestHandler;
    }

    Settings getEnvironmentSettings() {
        return this.environmentSettings;
    }

    public Set<Setting<?>> getAdditionalSettings() {
        return this.additionalSettings;
    }

    public static enum OpenSearchRequestType {
        REQUEST_OPENSEARCH_NAMED_WRITEABLE_REGISTRY;

    }
}

