/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.replication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.TransportActions;
import org.opensearch.action.support.TransportIndicesResolvingAction;
import org.opensearch.action.support.broadcast.BroadcastRequest;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.opensearch.action.support.replication.ReplicationRequest;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.ResolvedIndices;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.CountDown;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public abstract class TransportBroadcastReplicationAction<Request extends BroadcastRequest<Request>, Response extends BroadcastResponse, ShardRequest extends ReplicationRequest<ShardRequest>, ShardResponse extends ReplicationResponse>
extends HandledTransportAction<Request, Response>
implements TransportIndicesResolvingAction<Request> {
    private final TransportReplicationAction replicatedBroadcastShardAction;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public TransportBroadcastReplicationAction(String name, Writeable.Reader<Request> requestReader, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransportReplicationAction replicatedBroadcastShardAction) {
        super(name, transportService, actionFilters, requestReader);
        this.replicatedBroadcastShardAction = replicatedBroadcastShardAction;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    protected void doExecute(Task task, Request request, final ActionListener<Response> listener) {
        final ClusterState clusterState = this.clusterService.state();
        List<ShardId> shards = this.shards(request, clusterState);
        final CopyOnWriteArrayList shardsResponses = new CopyOnWriteArrayList();
        if (shards.size() == 0) {
            this.finishAndNotifyListener(listener, shardsResponses);
        }
        final CountDown responsesCountDown = new CountDown(shards.size());
        for (final ShardId shardId : shards) {
            ActionListener shardActionListener = new ActionListener<ShardResponse>(){

                public void onResponse(ShardResponse shardResponse) {
                    shardsResponses.add(shardResponse);
                    TransportBroadcastReplicationAction.this.logger.trace("{}: got response from {}", (Object)TransportBroadcastReplicationAction.this.actionName, (Object)shardId);
                    if (responsesCountDown.countDown()) {
                        TransportBroadcastReplicationAction.this.finishAndNotifyListener(listener, shardsResponses);
                    }
                }

                public void onFailure(Exception e) {
                    ReplicationResponse.ShardInfo.Failure[] failures;
                    TransportBroadcastReplicationAction.this.logger.trace("{}: got failure from {}", (Object)TransportBroadcastReplicationAction.this.actionName, (Object)shardId);
                    int totalNumCopies = clusterState.getMetadata().getIndexSafe(shardId.getIndex()).getNumberOfReplicas() + 1;
                    Object shardResponse = TransportBroadcastReplicationAction.this.newShardResponse();
                    if (TransportActions.isShardNotAvailableException(e)) {
                        failures = new ReplicationResponse.ShardInfo.Failure[]{};
                    } else {
                        ReplicationResponse.ShardInfo.Failure failure = new ReplicationResponse.ShardInfo.Failure(shardId, null, e, ExceptionsHelper.status((Throwable)e), true);
                        failures = new ReplicationResponse.ShardInfo.Failure[totalNumCopies];
                        Arrays.fill((Object[])failures, (Object)failure);
                    }
                    ((ReplicationResponse)((Object)shardResponse)).setShardInfo(new ReplicationResponse.ShardInfo(totalNumCopies, 0, failures));
                    shardsResponses.add(shardResponse);
                    if (responsesCountDown.countDown()) {
                        TransportBroadcastReplicationAction.this.finishAndNotifyListener(listener, shardsResponses);
                    }
                }
            };
            this.shardExecute(task, request, shardId, shardActionListener);
        }
    }

    @Override
    public ResolvedIndices resolveIndices(Request request) {
        return ResolvedIndices.of(this.resolveIndices(request, this.clusterService.state()));
    }

    private ResolvedIndices.Local.Concrete resolveIndices(Request request, ClusterState clusterState) {
        return this.indexNameExpressionResolver.concreteResolvedIndices(clusterState, (IndicesRequest)request);
    }

    protected void shardExecute(Task task, Request request, ShardId shardId, ActionListener<ShardResponse> shardActionListener) {
        ShardRequest shardRequest = this.newShardRequest(request, shardId);
        shardRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.replicatedBroadcastShardAction.execute(shardRequest, shardActionListener);
    }

    protected List<ShardId> shards(Request request, ClusterState clusterState) {
        ArrayList<ShardId> shardIds = new ArrayList<ShardId>();
        Set<String> concreteIndices = this.resolveIndices(request, clusterState).namesOfConcreteIndices();
        for (String index : concreteIndices) {
            IndexMetadata indexMetadata = clusterState.metadata().getIndices().get(index);
            if (indexMetadata == null) continue;
            for (IndexShardRoutingTable shardRouting : clusterState.getRoutingTable().indicesRouting().get(index).getShards().values()) {
                shardIds.add(shardRouting.shardId());
            }
        }
        return shardIds;
    }

    protected abstract ShardResponse newShardResponse();

    protected abstract ShardRequest newShardRequest(Request var1, ShardId var2);

    private void finishAndNotifyListener(ActionListener listener, CopyOnWriteArrayList<ShardResponse> shardsResponses) {
        this.logger.trace("{}: got all shard responses", (Object)this.actionName);
        int successfulShards = 0;
        int failedShards = 0;
        int totalNumCopies = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        for (int i = 0; i < shardsResponses.size(); ++i) {
            ReplicationResponse shardResponse = (ReplicationResponse)((Object)shardsResponses.get(i));
            if (shardResponse == null) continue;
            failedShards += shardResponse.getShardInfo().getFailed();
            successfulShards += shardResponse.getShardInfo().getSuccessful();
            totalNumCopies += shardResponse.getShardInfo().getTotal();
            if (shardFailures == null) {
                shardFailures = new ArrayList<DefaultShardOperationFailedException>();
            }
            for (ReplicationResponse.ShardInfo.Failure failure : shardResponse.getShardInfo().getFailures()) {
                shardFailures.add(new DefaultShardOperationFailedException((OpenSearchException)new BroadcastShardOperationFailedException(failure.fullShardId(), failure.getCause())));
            }
        }
        listener.onResponse((Object)this.newResponse(successfulShards, failedShards, totalNumCopies, shardFailures));
    }

    protected abstract BroadcastResponse newResponse(int var1, int var2, int var3, List<DefaultShardOperationFailedException> var4);
}

