/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.general.EcKeyGenerationParameters;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.WNafUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class EcKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    EcDomainParameters params;
    SecureRandom random;

    EcKeyPairGenerator() {
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        EcKeyGenerationParameters ecKeyGenerationParameters = (EcKeyGenerationParameters)keyGenerationParameters;
        this.random = ecKeyGenerationParameters.getRandom();
        this.params = ecKeyGenerationParameters.getDomainParameters();
        if (this.random == null) {
            throw new IllegalArgumentException("No random provided where one required.");
        }
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = new BigInteger(n, this.random)).compareTo(TWO) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new EcPublicKeyParameters(eCPoint, this.params), new EcPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

