/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandlerv2;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.actionv2.SearchMonitorV2Action;
import org.opensearch.alerting.actionv2.SearchMonitorV2Request;
import org.opensearch.alerting.resthandlerv2.RestSearchMonitorV2ActionKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.util.RestHandlerUtilsKt;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/alerting/resthandlerv2/RestSearchMonitorV2Action;", "Lorg/opensearch/rest/BaseRestHandler;", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;)V", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "filterBy", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "searchMonitorResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/action/search/SearchResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "opensearch-alerting"})
public final class RestSearchMonitorV2Action
extends BaseRestHandler {
    @NotNull
    private final Settings settings;
    private volatile Boolean filterBy;

    public RestSearchMonitorV2Action(@NotNull Settings settings, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.settings = settings;
        this.filterBy = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> RestSearchMonitorV2Action._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public String getName() {
        return "search_monitor_v2_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.POST, AlertingPlugin.MONITOR_V2_BASE_URI + "/_search"), new RestHandler.Route(RestRequest.Method.GET, AlertingPlugin.MONITOR_V2_BASE_URI + "/_search")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestSearchMonitorV2ActionKt.access$getLog$p().debug(request.method() + " " + AlertingPlugin.MONITOR_V2_BASE_URI + "/_search");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(RestHandlerUtilsKt.context(request));
        String[] stringArray = new String[]{".opendistro-alerting-config"};
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(stringArray);
        Intrinsics.checkNotNull((Object)searchRequest);
        SearchMonitorV2Request searchMonitorV2Request = new SearchMonitorV2Request(searchRequest);
        return arg_0 -> RestSearchMonitorV2Action.prepareRequest$lambda$1(client, searchMonitorV2Request, this, arg_0);
    }

    private final RestResponseListener<SearchResponse> searchMonitorResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<SearchResponse>(channel){
            final /* synthetic */ RestChannel $channel;
            {
                this.$channel = $channel;
                super($channel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RestResponse buildResponse(SearchResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (response2.isTimedOut()) {
                    return (RestResponse)new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response2.toString());
                }
                try {
                    Iterator iterator = response2.getHits().iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        SearchHit hit = (SearchHit)iterator2.next();
                        Closeable closeable = (Closeable)XContentType.JSON.xContent().createParser(this.$channel.request().getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        Throwable throwable = null;
                        try {
                            XContentParser hitsParser = (XContentParser)closeable;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)hitsParser);
                            String string = hit.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                            ScheduledJob monitorV2 = ScheduledJob.Companion.parse(hitsParser, string, hit.getVersion());
                            XContentBuilder xcb = monitorV2.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
                            SearchHit searchHit = hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                }
                catch (Exception e) {
                    RestSearchMonitorV2ActionKt.access$getLog$p().error("The monitor_v2 parsing failed. Will return response as is.");
                }
                return (RestResponse)new BytesRestResponse(RestStatus.OK, response2.toXContent(this.$channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }

    private static final void _init_$lambda$0(RestSearchMonitorV2Action this$0, Boolean it) {
        this$0.filterBy = it;
    }

    private static final void prepareRequest$lambda$1(NodeClient $client, SearchMonitorV2Request $searchMonitorV2Request, RestSearchMonitorV2Action this$0, RestChannel channel) {
        ActionType actionType = SearchMonitorV2Action.Companion.getINSTANCE();
        ActionRequest actionRequest = $searchMonitorV2Request;
        Intrinsics.checkNotNull((Object)channel);
        $client.execute(actionType, actionRequest, (ActionListener)this$0.searchMonitorResponse(channel));
    }
}

