/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsPath;

public class DescribeNetworkInsightsPathsPublisher
implements SdkPublisher<DescribeNetworkInsightsPathsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeNetworkInsightsPathsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNetworkInsightsPathsPublisher(Ec2AsyncClient client, DescribeNetworkInsightsPathsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNetworkInsightsPathsPublisher(Ec2AsyncClient client, DescribeNetworkInsightsPathsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNetworkInsightsPathsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNetworkInsightsPathsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkInsightsPath> networkInsightsPaths() {
        Function<DescribeNetworkInsightsPathsResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInsightsPaths() != null) {
                return response.networkInsightsPaths().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeNetworkInsightsPathsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeNetworkInsightsPathsResponseFetcher
    implements AsyncPageFetcher<DescribeNetworkInsightsPathsResponse> {
        private DescribeNetworkInsightsPathsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkInsightsPathsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeNetworkInsightsPathsResponse> nextPage(DescribeNetworkInsightsPathsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkInsightsPathsPublisher.this.client.describeNetworkInsightsPaths(DescribeNetworkInsightsPathsPublisher.this.firstRequest);
            }
            return DescribeNetworkInsightsPathsPublisher.this.client.describeNetworkInsightsPaths((DescribeNetworkInsightsPathsRequest)((Object)DescribeNetworkInsightsPathsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

