/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.lucene;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.util.IOSupplier;
import org.opensearch.lucene.SeededMappedDISI;
import org.opensearch.lucene.SeededTopDocsDISI;

public class ReentrantKnnCollectorManager
implements KnnCollectorManager {
    @Generated
    private static final Logger log = LogManager.getLogger(ReentrantKnnCollectorManager.class);
    @NonNull
    private final KnnCollectorManager knnCollectorManager;
    @NonNull
    private final Map<Integer, TopDocs> segmentOrdToResults;
    @NonNull
    private final Object query;
    @NonNull
    private final String field;

    public KnnCollector newCollector(int visitLimit, KnnSearchStrategy searchStrategy, LeafReaderContext ctx) throws IOException {
        IOSupplier vectorScorerSupplier;
        KnnCollector delegateCollector = this.knnCollectorManager.newCollector(visitLimit, searchStrategy, ctx);
        TopDocs seedTopDocs = this.segmentOrdToResults.get(ctx.ord);
        if (seedTopDocs == null || seedTopDocs.totalHits.value() == 0L) {
            log.warn("Seed top docs was empty, expected non-empty top results to be given.");
            assert (false);
            return delegateCollector;
        }
        LeafReader reader = ctx.reader();
        Object object = this.query;
        if (object instanceof float[]) {
            float[] floatQuery = (float[])object;
            vectorValues = reader.getFloatVectorValues(this.field);
            if (vectorValues == null) {
                log.error("Acquired null {} for field [{}]", (Object)FloatVectorValues.class.getSimpleName(), (Object)this.field);
                FloatVectorValues.checkField((LeafReader)reader, (String)this.field);
                return null;
            }
            vectorScorerSupplier = () -> ReentrantKnnCollectorManager.lambda$newCollector$0((FloatVectorValues)vectorValues, floatQuery);
        } else {
            vectorValues = this.query;
            if (vectorValues instanceof byte[]) {
                byte[] byteQuery = (byte[])vectorValues;
                vectorValues = reader.getByteVectorValues(this.field);
                if (vectorValues == null) {
                    log.error("Acquired null {} for field [{}]", (Object)ByteVectorValues.class.getSimpleName(), (Object)this.field);
                    ByteVectorValues.checkField((LeafReader)reader, (String)this.field);
                    return null;
                }
                vectorScorerSupplier = () -> ReentrantKnnCollectorManager.lambda$newCollector$1((ByteVectorValues)vectorValues, byteQuery);
            } else {
                throw new IllegalStateException("Unknown query type: " + String.valueOf(this.query.getClass()));
            }
        }
        VectorScorer scorer = (VectorScorer)vectorScorerSupplier.get();
        if (scorer == null) {
            log.error("Acquired null {} for field [{}]", (Object)VectorScorer.class.getSimpleName(), (Object)this.field);
            return delegateCollector;
        }
        DocIdSetIterator vectorIterator = scorer.iterator();
        if (vectorIterator instanceof KnnVectorValues.DocIndexIterator) {
            KnnVectorValues.DocIndexIterator indexIterator = (KnnVectorValues.DocIndexIterator)vectorIterator;
            SeededMappedDISI seedDocs = new SeededMappedDISI(indexIterator, new SeededTopDocsDISI(seedTopDocs));
            return this.knnCollectorManager.newCollector(visitLimit, (KnnSearchStrategy)new KnnSearchStrategy.Seeded((DocIdSetIterator)seedDocs, seedTopDocs.scoreDocs.length, searchStrategy), ctx);
        }
        log.error("`vectorIterator` was not one of [{}, {}] and was {}", (Object)IndexedDISI.class.getSimpleName(), (Object)KnnVectorValues.DocIndexIterator.class.getSimpleName(), (Object)(vectorIterator == null ? "null" : vectorIterator.getClass().getSimpleName()));
        return delegateCollector;
    }

    @Generated
    public ReentrantKnnCollectorManager(@NonNull KnnCollectorManager knnCollectorManager, @NonNull Map<Integer, TopDocs> segmentOrdToResults, @NonNull Object query, @NonNull String field) {
        if (knnCollectorManager == null) {
            throw new NullPointerException("knnCollectorManager is marked non-null but is null");
        }
        if (segmentOrdToResults == null) {
            throw new NullPointerException("segmentOrdToResults is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.knnCollectorManager = knnCollectorManager;
        this.segmentOrdToResults = segmentOrdToResults;
        this.query = query;
        this.field = field;
    }

    private static /* synthetic */ VectorScorer lambda$newCollector$1(ByteVectorValues vectorValues, byte[] byteQuery) throws IOException {
        return vectorValues.scorer(byteQuery);
    }

    private static /* synthetic */ VectorScorer lambda$newCollector$0(FloatVectorValues vectorValues, float[] floatQuery) throws IOException {
        return vectorValues.scorer(floatQuery);
    }
}

