/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.remote;

import java.net.http.HttpRequest;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.connector.ConnectorClientConfig;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.engine.algorithms.remote.RemoteConnectorExecutor;

public abstract class AbstractConnectorExecutor
implements RemoteConnectorExecutor {
    @Generated
    private static final Logger log = LogManager.getLogger(AbstractConnectorExecutor.class);
    private ConnectorClientConfig connectorClientConfig;

    public void initialize(Connector connector) {
        this.connectorClientConfig = connector.getConnectorClientConfig() != null ? connector.getConnectorClientConfig() : new ConnectorClientConfig();
    }

    protected void getMcpRequestHeaders(HttpRequest.Builder builder) {
        String[] mcpHeaders;
        if (this.getClient() == null) {
            return;
        }
        ThreadContext threadContext = this.getClient().threadPool().getThreadContext();
        for (String headerName : mcpHeaders = new String[]{"aws-access-key-id", "aws-secret-access-key", "aws-session-token", "aws-region", "aws-service-name", "opensearch-url"}) {
            String headerValue = threadContext.getHeader(headerName);
            if (headerValue == null || headerValue.isEmpty()) continue;
            builder.setHeader(headerName, headerValue);
            log.debug("Get MCP header: {}", (Object)headerName);
        }
    }

    protected ThreadedActionListener<Tuple<Integer, ModelTensors>> createThreadedListener(Logger logger, ActionListener<Tuple<Integer, ModelTensors>> actionListener) {
        return new ThreadedActionListener(logger, this.getClient().threadPool(), "opensearch_ml_predict_remote", actionListener, false);
    }

    @Generated
    public void setConnectorClientConfig(ConnectorClientConfig connectorClientConfig) {
        this.connectorClientConfig = connectorClientConfig;
    }

    @Override
    @Generated
    public ConnectorClientConfig getConnectorClientConfig() {
        return this.connectorClientConfig;
    }
}

